namespace gnomeguitar_cs
{
	
	
	public class FretNo
	{
		int fretNo;
		string[] numerals = new string[15] {"", "I", "II", "III", "IV", "V", "VI",
			       "VII", "VIII", "IX", "X", "XI", "XII",
			       "XIII", "XIV"};
		
		public static bool operator == (FretNo x, FretNo y) {
			return x.fretNo == y.fretNo;
		}
		
		public static bool operator != (FretNo x, FretNo y) {
			return x.fretNo != y.fretNo;
		}
		
		public override bool Equals(object o) {
			if(!(o is FretNo))
				return false;
			return this == (FretNo)o;
		}
		
		public override int GetHashCode()
		{
			return (int)fretNo;
		}
		
		public static implicit operator int(FretNo x) {
				return x.fretNo;
		}
				
		public FretNo (string text)
		{
			if (text == null || text == ""){
				fretNo = -1;
			} else {
				fretNo = short.Parse (text);
			}
		}
		
		public FretNo (int fretNo)
		{
			this.fretNo=fretNo;
		}
		
		public string to_text() 
		{
			string text;
	
			if (fretNo == -1){
				text = "None";
			} else {
				text = string.Format("{0:G}", fretNo);
			}
	
			return text;
		}
		
		public string to_roman_numerals()
		{
			return numerals[fretNo];
		}
	}
}
