using System.Text;

namespace gnomeguitar_cs
{
	
	public class GuitarString {  
		Note tuned;
		Note fretted;
		Relation relation;
		Finger finger;
		FretNo fretNo;
		
		public GuitarString ()
		{
			tuned = new Note(NoteValue.NO_NOTE);
			fretted = new Note(NoteValue.NO_NOTE);
			relation = new Relation("");
			finger = new Finger(FingerValue.NO_FINGER);
			fretNo = new FretNo(-1);			                    	
		}

		
		public GuitarString (Note note)
		{
			set_tuned (note);
			fretted = new Note(NoteValue.NO_NOTE);
			relation = new Relation("");
			finger = new Finger(FingerValue.NO_FINGER);
			fretNo = new FretNo(-1);
		}

		public void set_tuned (Note tuned)
		{
			this.tuned = tuned;
		}

		public Note get_tuned ()
		{
			return tuned;
		}

		public void set_fretted (Note fretted)
		{
			this.fretted = fretted;

			//If we don't do this if fretted is NO_NOTE and auto set is called it is mistaken for an unknown fretted
			if(fretted == NoteValue.NO_NOTE){
				this.fretNo = new FretNo(-1);
			}
		}

		public void set_relation(Relation relation)
		{
			this.relation = relation;
		}
	
		public Note get_fretted ()
		{
			//not really sure what is going on here :/

//			if ((fretted == NoteValue.NO_NOTE || fretted == NoteValue.UNKNOWN)
//			    && fretNo != -1)
//			{
//				fretted = new Note(get_tuned());
//				fretted.plus_interval(fretNo);
//			}
			return fretted;
		}

		public void set_fretNo (FretNo fretNo)
		{
			this.fretNo = fretNo;
		}

		public FretNo get_fretNo ()
		{
			return this.fretNo;
		}

		public Relation get_relation ()
		{
			//surely relation should always be legal?
//			if(fretNo != -1 && relation == "X"){
//				return new Relation("U");
//			}
			return relation;
		}

		public void set_finger (Finger finger)
		{
			this.finger = finger;
		}

		public Finger get_finger ()
		{
			//why isn't finger always legal?
//			if(fretNo != -1 && this.finger == FingerValue.NOT_USED){
//				return new Finger(FingerValue.UNKNOWN);
//			}
			return finger; 
		}

		public string to_text ()
		{
			StringBuilder text;
			
			text = new StringBuilder("\t\tTuned = ");
			text.AppendFormat("{0}\n\t\tFretted = {1}\n\t\tFretNo = {2}\n\t\tRelation = {3}\n\t\tFinger =  {4}\n",
			                  tuned_to_text(),
			                  fretted_to_text(),
			                  fretNo_to_text(),
			                  relation_to_text(),
			                  finger_to_text());
			
			return text.ToString();
		} 

		public string tuned_to_text ()
		{
			return get_tuned().to_text();
		}

		public string fretted_to_text()
		{
			return get_fretted().to_text();
		}

		public string fretNo_to_text ()
		{
			return get_fretNo().to_text();
		}

		public string relation_to_text ()
		{
			return get_relation().to_text();
		}

		public string finger_to_text ()
		{
			return get_finger().to_text();
		}

		public bool played()
		{
			bool played;
			
			if (get_fretNo() == -1){
				played = false;
			} else {
				played = true;
			}

			return played;
		}

		public bool is12plus()
		{
			return get_fretNo() > 11? true: false;
		}

		public void set_12plus(bool is12plus)
		{
			int fretNo;
			
			fretNo = get_fretNo();
			if (is12plus && fretNo < 12){
				set_fretNo(new FretNo(fretNo + 12));
			} else if (!is12plus && fretNo > 11) {
				set_fretNo(new FretNo(fretNo - 12));
			}
		}

		public string to_xml()
		{
			StringBuilder xml;
			string tuned;	
			string fretted;
			string fretNo;
			string relation;
			string finger;
	
			xml = new StringBuilder();
			
			tuned = get_tuned().to_text();
			fretted = get_fretted().to_text();
			if (fretted == "X"){
				fretted = "";
			}
			fretNo = get_fretNo().to_text();
			if (fretNo == "None"){
				fretNo = "";
			}
			relation = get_relation().to_text();
			if (relation == "X"){
				relation = "";
			}
			finger = get_finger().to_text();
			if (finger == "None"){
				finger = "";
			}
			xml.AppendFormat("<guitarString><tuned>{0}</tuned><fretted>{1}</fretted><fretNo>{2}</fretNo><relation>{3}</relation><finger>{4}</finger></guitarString>",
			                 tuned,fretted,fretNo,relation,finger);

			return xml.ToString();
		}

		public bool is_equal(GuitarString other)
		{
			Note thisTuned;
			Note otherTuned;
			Note thisFretted;
			Note otherFretted;
			Relation thisRelation;
			Relation otherRelation;
			Finger thisFinger;
			Finger otherFinger;

			thisTuned = get_tuned();
			otherTuned = other.get_tuned();
			if (thisTuned != otherTuned){
				return false;
			}

			thisFretted = get_fretted();
			otherFretted = other.get_fretted();
			if(thisFretted != otherFretted){
				return false;
			}
	
			thisRelation = get_relation();
			otherRelation = other.get_relation();
			if(thisRelation != otherRelation){
				return false;
			}	
		
			thisFinger = get_finger();
			otherFinger = other.get_finger();
			if(thisFinger != otherFinger){
				return false;
			}
			
			return true;
		}

		public void auto_set_fretNo()
		{
			Note fretted;
			Note tuned;
			int i;
			
			tuned = new Note(get_tuned());
			fretted = get_fretted();
			if (fretted == NoteValue.NO_NOTE){
				set_fretNo(new FretNo(-1));
			} else {
				for (i = 0; tuned.compare_enharmonic_notes(fretted); 
				     i++, tuned.plus_semiTone()){}
				if (is12plus()){
					i += 12;
				}
			
				set_fretNo(new FretNo(i));
			}
			      
		}
	}
}