using System;

namespace gnomeguitar_cs
{
	public enum NoteEventType {
			ADDED,
			REMOVED,
			SHARPENED,
			UN_SHARPENED,
			DOUBLE_SHARPENED,
			UN_DOUBLE_SHARPENED,
			FLATTENED,
			UN_FLATTENED,
			DOUBLE_FLATTENED,
			UN_DOUBLE_FLATTENED,
			CHANGED
		}
	
	public class NotesChangedArgs : EventArgs
	{	
		public NoteEventType eventType;
		public ushort noteNo;
		
		public NotesChangedArgs(NoteEventType eventType)
		{
			this.eventType = eventType;
			noteNo = 0;
		}
		
		public NotesChangedArgs(NoteEventType eventType, ushort noteNo)
		{
			this.eventType = eventType;
			this.noteNo = noteNo;
		}	
	}
		
	public class HomogeneousChordGroup : ChordGroup 
	{
	
		public delegate void WrittensChangedHandler (object chordGroup, EventArgs information);
		public delegate void NotesChangedHandler (object chordGroup, NotesChangedArgs information);		
		public event WrittensChangedHandler onWrittensChanged;
		public event NotesChangedHandler onNotesChanged;
		
		public HomogeneousChordGroup ()
		{
		}
		
		public HomogeneousChordGroup (ChordGroup chordGroup) : base (chordGroup.ToArray())
		{
		}

		public void new_major_open_chords()
		{
			clear();
			foreach (NoteValue note in Note.noteValues){
				if (note != NoteValue.NO_NOTE 
				    && note != NoteValue.ANY
				    && note != NoteValue.UNKNOWN)
				{
					add(new Chord(new Note(note)));
				}
			}
			set_names("Major");	
		}	

		public void add_construction(Relation relation)
		{
			foreach (Chord chord in this){ 
				chord.add_construction(relation);
			}
			if(onNotesChanged != null){onNotesChanged(this, new NotesChangedArgs(NoteEventType.ADDED, relation.to_noteNo()));}
		}

		public void set_construction(Construction construction)
		{
			foreach (Chord chord in this){ 
				chord.set_construction(construction);
			}
			if(onNotesChanged != null){onNotesChanged(this, new NotesChangedArgs(NoteEventType.CHANGED));}
		}

		public void remove_construction(Relation relation)
		{
			foreach (Chord chord in this){ 
				chord.remove_construction(relation);
			}
			if(onNotesChanged != null){onNotesChanged(this, new NotesChangedArgs(NoteEventType.REMOVED, relation.to_noteNo()));}
		}

		public void flatten_construction(Relation relation)
		{
			foreach (Chord chord in this){ 
				chord.flatten_construction(relation);
			}
			if(onNotesChanged != null){onNotesChanged(this, new NotesChangedArgs(NoteEventType.FLATTENED, relation.to_noteNo()));}	
		}

		public void sharpen_construction(Relation relation)
		{
			foreach (Chord chord in this){ 
				chord.sharpen_construction(relation);
			}
			if(onNotesChanged != null){onNotesChanged(this, new NotesChangedArgs(NoteEventType.SHARPENED, relation.to_noteNo()));}
		}

		public void doubleFlatten_construction(Relation relation)
		{
			foreach (Chord chord in this){
				chord.double_flatten_construction(relation);
			}
			if(onNotesChanged != null){onNotesChanged(this, new NotesChangedArgs(NoteEventType.DOUBLE_FLATTENED, relation.to_noteNo()));}
		}

		public void doubleSharpen_construction(Relation relation)
		{
			foreach (Chord chord in this){
				chord.double_sharpen_construction(relation);
			}
			if(onNotesChanged != null){onNotesChanged(this, new NotesChangedArgs(NoteEventType.DOUBLE_SHARPENED, relation.to_noteNo()));}
		}

		public void set_names(string genericName)
		{
			foreach (Chord chord in this){
				chord.set_generic_name(genericName);
			}
		}

		public Construction get_construction()
		{
			return	get_any_chord().get_construction(); 
		}
	
		public GenericWrittenGroup get_genericWrittens()
		{
			GenericWrittenGroup genericWrittens;
			WrittenGroup writtens;

			writtens = get_any_chord().get_writtens();

			genericWrittens = new GenericWrittenGroup();
			foreach (Written written in writtens){
				genericWrittens.add(written.to_generic());
			}

			return genericWrittens;
		}

		public ChordType get_chordType()
		{
			Chord chord;
			ChordType type;

			chord = get_any_chord();
			if (chord == null){
				type = new ChordType("");
			} else {
				type = chord.get_chordType();
			}
			return type;
		}


		public void add_written(GenericWritten genericWritten)
		{
			foreach (Chord chord in this){
				chord.append_written(new Written(genericWritten, chord.get_root()) );
			}
			
			if(onWrittensChanged != null){onWrittensChanged(this, new EventArgs());}	
		}

		public void remove_written(GenericWritten genericWritten)
		{
			foreach (Chord chord in this){
				chord.remove_written(new Written(genericWritten, chord.get_root()) );
			}
			if(onWrittensChanged != null){onWrittensChanged(this, new EventArgs());}
		}

/***************************************************************************
 ***************************PRIVATE STUFF***********************************
 **************************************************************************/

		public override void add(Object obj)
		{
			ChordType chordType, selfType;
			Chord chord = (Chord)obj;
			
			chordType = chord.get_chordType();
			selfType = get_chordType();
			if((selfType != "") && (chordType != selfType))
			{return;}
				
			base.add(chord);
		}

//Don't see the point in this
//NULL (or equivalent is legal for the second arg it means any
		public override ChordGroup create_type_sub_group (ChordType type)
		{
			return new HomogeneousChordGroup(base.create_type_sub_group(type));
		}
	
		public override ChordGroup create_root_sub_group (Note root)
		{
			return new HomogeneousChordGroup(base.create_root_sub_group(root));
		}

		public override ChordGroup create_key_sub_group (Note key)
		{
			return new HomogeneousChordGroup(base.create_key_sub_group(key));
		}

		public override ChordGroup create_shape_sub_group (ChordShape shape)
		{
				return new HomogeneousChordGroup(base.create_shape_sub_group(shape));
		}
			
		public override ChordGroup create_tuning_sub_group (Tuning tuning)
		{
			return new HomogeneousChordGroup(base.create_tuning_sub_group(tuning)); 
		}

		public override ChordGroup create_sub_group(ChordType type, Note root, Note key, ChordShape shape)
		{
			return new HomogeneousChordGroup(base.create_sub_group(type,root,key,shape));
		}
	
		Chord get_any_chord()
		{
			if(get_no() != 0){
				return (Chord)nth(0);
			} else {
				return null;
			}
		}
	}
}