namespace gnomeguitar_cs
{
	public enum NoteValue {
			NO_NOTE, UNKNOWN, ANY,
			Abb, Ab, A, A_SHARP, A_SHARP_SHARP,
			Bbb, Bb, B, B_SHARP, B_SHARP_SHARP,
			Cbb, Cb, C, C_SHARP, C_SHARP_SHARP,
			Dbb, Db, D,  D_SHARP, D_SHARP_SHARP,
			Ebb, Eb, E, E_SHARP, E_SHARP_SHARP,
			Fbb, Fb, F, F_SHARP, F_SHARP_SHARP,
			Gbb, Gb, G, G_SHARP, G_SHARP_SHARP
		}	
	
	
	public class Note
	{
		public static readonly NoteValue[] noteValues = {NoteValue.NO_NOTE, NoteValue.UNKNOWN, NoteValue.ANY,
			NoteValue.Abb, NoteValue.Ab, NoteValue.A, NoteValue.A_SHARP, NoteValue.A_SHARP_SHARP,
			NoteValue.Bbb, NoteValue.Bb, NoteValue.B, NoteValue.B_SHARP, NoteValue.B_SHARP_SHARP,
			NoteValue.Cbb, NoteValue.Cb, NoteValue.C, NoteValue.C_SHARP, NoteValue.C_SHARP_SHARP,
			NoteValue.Dbb, NoteValue.Db, NoteValue.D,  NoteValue.D_SHARP, NoteValue.D_SHARP_SHARP,
			NoteValue.Ebb, NoteValue.Eb, NoteValue.E, NoteValue.E_SHARP, NoteValue.E_SHARP_SHARP,
			NoteValue.Fbb, NoteValue.Fb, NoteValue.F, NoteValue.F_SHARP, NoteValue.F_SHARP_SHARP,
			NoteValue.Gbb, NoteValue.Gb, NoteValue.G, NoteValue.G_SHARP, NoteValue.G_SHARP_SHARP
		};	

		NoteValue nv;
		
		public Note ()
		{
			nv=NoteValue.NO_NOTE;
		}
		
		public Note(NoteValue nv)
		{
			this.nv = nv;
		}
//		public Note(Note note)
//		{
//			this.nv = (NoteValue)note;
//		}
		public Note(string text)
		{
			nv = text_to_noteValue(text);
		}
		 
		public static bool operator == (Note x, Note y) {
			return x.nv == y.nv;
		}
		
		public static bool operator != (Note x, Note y) {
			return x.nv != y.nv;
		}
		
		public override bool Equals(object o) {
			if(!(o is Note))
				return false;
			return this == (Note)o;
		}
		
		public override int GetHashCode()
		{
			return (int)nv;
		}
		
		public static implicit operator NoteValue(Note x) {
			return x.nv;
		}
		
		public string to_text()
		{
			return noteValue_to_text(nv);
		}
	
		//can't think how to make this work taking an Interval	
		public void plus_interval (int noSemiTones)
		{
			short i;
	
			for (i = 0; i < noSemiTones; i++){
				plus_semiTone();
			}
		}
	

		public void plus_scale_interval (Interval interval)
		{	
			switch (interval.iv){
			case IntervalValue.SEMI_TONE: plus_scale_semiTone(); break;
			case IntervalValue.TONE: plus_scale_tone(); break;
			}
		}


		public void minus_scale_interval (Interval interval)
		{
			switch (interval.iv){
			case IntervalValue.SEMI_TONE: minus_scale_semiTone(); break;
			case IntervalValue.TONE: minus_scale_tone(); break;
			}
		}
		
		public void plus_semiTone ()
		{	
		switch (nv){
		case NoteValue.NO_NOTE: nv = NoteValue.NO_NOTE; break;
		case NoteValue.UNKNOWN: nv = NoteValue.UNKNOWN; break;
		case NoteValue.Abb: nv = NoteValue.Ab; break;
		case NoteValue.Ab: nv = NoteValue.A; break;
		case NoteValue.A: nv = NoteValue.A_SHARP; break;
		case NoteValue.A_SHARP: nv = NoteValue.B; break;
		case NoteValue.A_SHARP_SHARP: nv = NoteValue.C_SHARP; break;
		case NoteValue.Bbb: nv = NoteValue.Bb; break;
		case NoteValue.Bb: nv = NoteValue.B; break;
		case NoteValue.B: nv = NoteValue.C; break;
		case NoteValue.B_SHARP: nv = NoteValue.C_SHARP; break;
		case NoteValue.B_SHARP_SHARP: nv = NoteValue.C_SHARP_SHARP; break;
		case NoteValue.Cbb: nv = NoteValue.Cb; break;
		case NoteValue.Cb: nv = NoteValue.C; break;
		case NoteValue.C: nv = NoteValue.C_SHARP; break;
		case NoteValue.C_SHARP: nv = NoteValue.D; break;
		case NoteValue.C_SHARP_SHARP: nv = NoteValue.D_SHARP; break;
		case NoteValue.Dbb: nv = NoteValue.Db; break;
		case NoteValue.Db: nv = NoteValue.D; break;
		case NoteValue.D: nv = NoteValue.D_SHARP; break;
		case NoteValue.D_SHARP: nv = NoteValue.E; break;
		case NoteValue.D_SHARP_SHARP: nv = NoteValue.E_SHARP; break;
		case NoteValue.Ebb: nv = NoteValue.Eb; break;
		case NoteValue.Eb: nv = NoteValue.E; break;
		case NoteValue.E: nv = NoteValue.F; break;
		case NoteValue.E_SHARP: nv = NoteValue.F_SHARP; break;
		case NoteValue.E_SHARP_SHARP: nv = NoteValue.F_SHARP_SHARP; break;
		case NoteValue.Fbb: nv = NoteValue.Fb; break;
		case NoteValue.Fb: nv = NoteValue.F; break;
		case NoteValue.F: nv = NoteValue.F_SHARP; break;
		case NoteValue.F_SHARP: nv = NoteValue.G; break;
		case NoteValue.F_SHARP_SHARP: nv = NoteValue.G_SHARP; break;
		case NoteValue.Gbb: nv = NoteValue.Gb; break;
		case NoteValue.Gb: nv = NoteValue.G; break;
		case NoteValue.G: nv = NoteValue.G_SHARP; break;
		case NoteValue.G_SHARP: nv = NoteValue.A; break;
		case NoteValue.G_SHARP_SHARP: nv = NoteValue.A_SHARP; break;
		}	
	}
	
	public void sharpen ()
	{	
		switch (nv){
		case NoteValue.NO_NOTE: nv = NoteValue.NO_NOTE; break;
		case NoteValue.UNKNOWN: nv = NoteValue.UNKNOWN; break;
		case NoteValue.Abb: nv = NoteValue.Ab; break;
		case NoteValue.Ab: nv = NoteValue.A; break;
		case NoteValue.A: nv = NoteValue.A_SHARP; break;
		case NoteValue.A_SHARP: nv = NoteValue.A_SHARP_SHARP; break;
		case NoteValue.A_SHARP_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Bbb: nv = NoteValue.Bb; break;
		case NoteValue.Bb: nv = NoteValue.B; break;
		case NoteValue.B: nv = NoteValue.B_SHARP; break;
		case NoteValue.B_SHARP: nv = NoteValue.B_SHARP_SHARP; break;
		case NoteValue.B_SHARP_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Cbb: nv = NoteValue.Cb; break;
		case NoteValue.Cb: nv = NoteValue.C; break;
		case NoteValue.C: nv = NoteValue.C_SHARP; break;
		case NoteValue.C_SHARP: nv = NoteValue.C_SHARP_SHARP; break;
		case NoteValue.C_SHARP_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Dbb: nv = NoteValue.Db; break;
		case NoteValue.Db: nv = NoteValue.D; break;
		case NoteValue.D: nv = NoteValue.D_SHARP; break;
		case NoteValue.D_SHARP: nv = NoteValue.D_SHARP_SHARP; break;
		case NoteValue.D_SHARP_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Ebb: nv = NoteValue.Eb; break;
		case NoteValue.Eb: nv = NoteValue.E; break;
		case NoteValue.E: nv = NoteValue.E_SHARP; break;
		case NoteValue.E_SHARP: nv = NoteValue.E_SHARP_SHARP; break;
		case NoteValue.E_SHARP_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Fbb: nv = NoteValue.Fb; break;
		case NoteValue.Fb: nv = NoteValue.F; break;
		case NoteValue.F: nv = NoteValue.F_SHARP; break;
		case NoteValue.F_SHARP: nv = NoteValue.F_SHARP_SHARP; break;
		case NoteValue.F_SHARP_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Gbb: nv = NoteValue.Gb; break;
		case NoteValue.Gb: nv = NoteValue.G; break;
		case NoteValue.G: nv = NoteValue.G_SHARP; break;
		case NoteValue.G_SHARP: nv = NoteValue.G_SHARP_SHARP; break;
		case NoteValue.G_SHARP_SHARP: nv = NoteValue.NO_NOTE; break;
		}
	}

	public void doubleSharpen ()
	{	
		switch (nv){
		case NoteValue.NO_NOTE: nv = NoteValue.NO_NOTE; break;
		case NoteValue.UNKNOWN: nv = NoteValue.UNKNOWN; break;
		case NoteValue.Abb: nv = NoteValue.A; break;
		case NoteValue.Ab: nv = NoteValue.A_SHARP; break;
		case NoteValue.A: nv = NoteValue.A_SHARP_SHARP; break;
		case NoteValue.A_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.A_SHARP_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Bbb: nv = NoteValue.B; break;
		case NoteValue.Bb: nv = NoteValue.B_SHARP; break;
		case NoteValue.B: nv = NoteValue.B_SHARP_SHARP; break;
		case NoteValue.B_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.B_SHARP_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Cbb: nv = NoteValue.C; break;
		case NoteValue.Cb: nv = NoteValue.C_SHARP; break;
		case NoteValue.C: nv = NoteValue.C_SHARP_SHARP; break;
		case NoteValue.C_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.C_SHARP_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Dbb: nv = NoteValue.D; break;
		case NoteValue.Db: nv = NoteValue.D_SHARP; break;
		case NoteValue.D: nv = NoteValue.D_SHARP_SHARP; break;
		case NoteValue.D_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.D_SHARP_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Ebb: nv = NoteValue.E; break;
		case NoteValue.Eb: nv = NoteValue.E_SHARP; break;
		case NoteValue.E: nv = NoteValue.E_SHARP_SHARP; break;
		case NoteValue.E_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.E_SHARP_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Fbb: nv = NoteValue.F; break;
		case NoteValue.Fb: nv = NoteValue.F_SHARP; break;
		case NoteValue.F: nv = NoteValue.F_SHARP_SHARP; break;
		case NoteValue.F_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.F_SHARP_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Gbb: nv = NoteValue.G; break;
		case NoteValue.Gb: nv = NoteValue.G_SHARP; break;
		case NoteValue.G: nv = NoteValue.G_SHARP_SHARP; break;
		case NoteValue.G_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.G_SHARP_SHARP: nv = NoteValue.NO_NOTE; break;
		}
	}

	public void flatten ()
	{
		switch (nv){
		case NoteValue.NO_NOTE: nv = NoteValue.NO_NOTE; break; 
		case NoteValue.UNKNOWN: nv = NoteValue.UNKNOWN; break;
		case NoteValue.Abb: nv = NoteValue.NO_NOTE; break; 
		case NoteValue.Ab: nv = NoteValue.Abb; break;
		case NoteValue.A: nv = NoteValue.Ab; break;
		case NoteValue.A_SHARP: nv = NoteValue.A; break;
		case NoteValue.A_SHARP_SHARP: nv = NoteValue.A_SHARP; break;
		case NoteValue.Bbb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Bb: nv = NoteValue.Bbb; break;
		case NoteValue.B: nv = NoteValue.Bb; break;
		case NoteValue.B_SHARP: nv = NoteValue.B; break;
		case NoteValue.B_SHARP_SHARP: nv = NoteValue.B_SHARP; break;
		case NoteValue.Cbb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Cb: nv = NoteValue.Cbb; break;
		case NoteValue.C: nv = NoteValue.Cb; break;
		case NoteValue.C_SHARP: nv = NoteValue.C; break;
		case NoteValue.C_SHARP_SHARP: nv = NoteValue.C_SHARP; break;
		case NoteValue.Dbb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Db: nv = NoteValue.Dbb; break;
		case NoteValue.D: nv = NoteValue.Db; break;
		case NoteValue.D_SHARP: nv = NoteValue.D; break;
		case NoteValue.D_SHARP_SHARP: nv = NoteValue.D_SHARP; break;
		case NoteValue.Ebb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Eb: nv = NoteValue.Ebb; break;
		case NoteValue.E: nv = NoteValue.Eb; break;
		case NoteValue.E_SHARP: nv = NoteValue.E; break;
		case NoteValue.E_SHARP_SHARP: nv = NoteValue.E_SHARP; break;
		case NoteValue.Fbb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Fb: nv = NoteValue.Fbb; break;
		case NoteValue.F: nv = NoteValue.Fb; break;
		case NoteValue.F_SHARP: nv = NoteValue.F; break;
		case NoteValue.F_SHARP_SHARP: nv = NoteValue.F_SHARP; break;
		case NoteValue.Gbb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Gb: nv = NoteValue.Gbb; break;
		case NoteValue.G: nv = NoteValue.Gb; break;
		case NoteValue.G_SHARP: nv = NoteValue.G; break;
		case NoteValue.G_SHARP_SHARP: nv = NoteValue.G_SHARP; break;
		}	
	}
	
	public void doubleFlatten ()
	{
		switch (nv){
		case NoteValue.NO_NOTE: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Abb: nv = NoteValue.NO_NOTE; break; 
		case NoteValue.Ab: nv = NoteValue.NO_NOTE; break;
		case NoteValue.A: nv = NoteValue.Abb; break;
		case NoteValue.A_SHARP: nv = NoteValue.Ab; break;
		case NoteValue.A_SHARP_SHARP: nv = NoteValue.A; break;
		case NoteValue.Bbb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Bb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.B: nv = NoteValue.Bbb; break;
		case NoteValue.B_SHARP: nv = NoteValue.Bb; break;
		case NoteValue.B_SHARP_SHARP: nv = NoteValue.B; break;
		case NoteValue.Cbb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Cb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.C: nv = NoteValue.Cbb; break;
		case NoteValue.C_SHARP: nv = NoteValue.Cb; break;
		case NoteValue.C_SHARP_SHARP: nv = NoteValue.C; break;
		case NoteValue.Dbb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Db: nv = NoteValue.NO_NOTE; break;
		case NoteValue.D: nv = NoteValue.Dbb; break;
		case NoteValue.D_SHARP: nv = NoteValue.Db; break;
		case NoteValue.D_SHARP_SHARP: nv = NoteValue.D; break;
		case NoteValue.Ebb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Eb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.E: nv = NoteValue.Ebb; break;
		case NoteValue.E_SHARP: nv = NoteValue.Eb; break;
		case NoteValue.E_SHARP_SHARP: nv = NoteValue.E; break;
		case NoteValue.Fbb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Fb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.F: nv = NoteValue.Fbb; break;
		case NoteValue.F_SHARP: nv = NoteValue.Fb; break;
		case NoteValue.F_SHARP_SHARP: nv = NoteValue.F; break;
		case NoteValue.Gbb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Gb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.G: nv = NoteValue.Gbb; break;
		case NoteValue.G_SHARP: nv = NoteValue.Gb; break;
		case NoteValue.G_SHARP_SHARP: nv = NoteValue.G; break;
		}
	}

	public void plus_scale_semiTone ()
	{
		switch (nv){
		case NoteValue.NO_NOTE: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Abb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Ab: nv = NoteValue.Bbb; break;
		case NoteValue.A: nv = NoteValue.Bb; break;
		case NoteValue.A_SHARP: nv = NoteValue.B; break;
		case NoteValue.A_SHARP_SHARP: nv = NoteValue.B_SHARP; break;
		case NoteValue.Bbb: nv = NoteValue.Cbb; break;
		case NoteValue.Bb: nv = NoteValue.Cb; break;
		case NoteValue.B: nv = NoteValue.C; break;
		case NoteValue.B_SHARP: nv = NoteValue.C_SHARP; break;
		case NoteValue.B_SHARP_SHARP: nv = NoteValue.C_SHARP_SHARP; break;
		case NoteValue.Cbb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Cb: nv = NoteValue.Dbb; break;
		case NoteValue.C: nv = NoteValue.Db; break;
		case NoteValue.C_SHARP: nv = NoteValue.D; break;
		case NoteValue.C_SHARP_SHARP: nv = NoteValue.D_SHARP; break;
		case NoteValue.Dbb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Db: nv = NoteValue.Ebb; break;
		case NoteValue.D: nv = NoteValue.Eb; break;
		case NoteValue.D_SHARP: nv = NoteValue.E; break;
		case NoteValue.D_SHARP_SHARP: nv = NoteValue.E_SHARP; break;
		case NoteValue.Ebb: nv = NoteValue.Fbb; break;
		case NoteValue.Eb: nv = NoteValue.Fb; break;
		case NoteValue.E: nv = NoteValue.F; break;
		case NoteValue.E_SHARP: nv = NoteValue.F_SHARP; break;
		case NoteValue.E_SHARP_SHARP: nv = NoteValue.F_SHARP_SHARP; break;
		case NoteValue.Fbb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Fb: nv = NoteValue.Gbb; break;
		case NoteValue.F: nv = NoteValue.Gb; break;
		case NoteValue.F_SHARP: nv = NoteValue.G; break;
		case NoteValue.F_SHARP_SHARP: nv = NoteValue.G_SHARP; break;
		case NoteValue.Gbb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Gb: nv = NoteValue.Abb; break;
		case NoteValue.G: nv = NoteValue.Ab; break;
		case NoteValue.G_SHARP: nv = NoteValue.A; break;
		case NoteValue.G_SHARP_SHARP: nv = NoteValue.A_SHARP; break;
		}
	}
	
	public void minus_scale_semiTone ()
	{
		switch (nv){
		case NoteValue.NO_NOTE: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Abb: nv = NoteValue.Gb; break; 
		case NoteValue.Ab: nv = NoteValue.G; break;
		case NoteValue.A: nv = NoteValue.G_SHARP; break;
		case NoteValue.A_SHARP: nv = NoteValue.G_SHARP_SHARP; break;
		case NoteValue.A_SHARP_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Bbb: nv = NoteValue.Ab; break;
		case NoteValue.Bb: nv = NoteValue.A; break;
		case NoteValue.B: nv = NoteValue.A_SHARP; break;
		case NoteValue.B_SHARP: nv = NoteValue.A_SHARP_SHARP; break;
		case NoteValue.B_SHARP_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Cbb: nv = NoteValue.Bbb; break;
		case NoteValue.Cb: nv = NoteValue.Bb; break;
		case NoteValue.C: nv = NoteValue.B; break;
		case NoteValue.C_SHARP: nv = NoteValue.B_SHARP; break;
		case NoteValue.C_SHARP_SHARP: nv = NoteValue.B_SHARP_SHARP; break;
		case NoteValue.Dbb: nv = NoteValue.Cb; break;
		case NoteValue.Db: nv = NoteValue.C; break;
		case NoteValue.D: nv = NoteValue.C_SHARP; break;
		case NoteValue.D_SHARP: nv = NoteValue.C_SHARP_SHARP; break;
		case NoteValue.D_SHARP_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Ebb: nv = NoteValue.Db; break;
		case NoteValue.Eb: nv = NoteValue.D; break;
		case NoteValue.E: nv = NoteValue.D_SHARP; break;
		case NoteValue.E_SHARP: nv = NoteValue.D_SHARP_SHARP; break;
		case NoteValue.E_SHARP_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Fbb: nv = NoteValue.Ebb; break;
		case NoteValue.Fb: nv = NoteValue.Eb; break;
		case NoteValue.F: nv = NoteValue.E; break;
		case NoteValue.F_SHARP: nv = NoteValue.E_SHARP; break;
		case NoteValue.F_SHARP_SHARP: nv = NoteValue.E_SHARP_SHARP; break;
		case NoteValue.Gbb: nv = NoteValue.Fb; break;
		case NoteValue.Gb: nv = NoteValue.F; break;
		case NoteValue.G: nv = NoteValue.F_SHARP; break;
		case NoteValue.G_SHARP: nv = NoteValue.F_SHARP_SHARP; break;
		case NoteValue.G_SHARP_SHARP: nv = NoteValue.NO_NOTE; break;
		}
	}

	public void plus_scale_tone ()
	{
		switch (nv){
		case NoteValue.NO_NOTE: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Abb: nv = NoteValue.Bbb; break;
		case NoteValue.Ab: nv = NoteValue.Bb; break;
		case NoteValue.A: nv = NoteValue.B; break;
		case NoteValue.A_SHARP: nv = NoteValue.B_SHARP; break;
		case NoteValue.A_SHARP_SHARP: nv = NoteValue.B_SHARP_SHARP; break;
		case NoteValue.Bbb: nv = NoteValue.Cb; break;
		case NoteValue.Bb: nv = NoteValue.C; break;
		case NoteValue.B: nv = NoteValue.C_SHARP; break;
		case NoteValue.B_SHARP: nv = NoteValue.C_SHARP_SHARP; break;
		case NoteValue.B_SHARP_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Cbb: nv = NoteValue.Dbb; break;
		case NoteValue.Cb: nv = NoteValue.Db; break;
		case NoteValue.C: nv = NoteValue.D; break;
		case NoteValue.C_SHARP: nv = NoteValue.D_SHARP; break;
		case NoteValue.C_SHARP_SHARP: nv = NoteValue.D_SHARP_SHARP; break;
		case NoteValue.Dbb: nv = NoteValue.Ebb; break;
		case NoteValue.Db: nv = NoteValue.Eb; break;
		case NoteValue.D: nv = NoteValue.E; break;
		case NoteValue.D_SHARP: nv = NoteValue.E_SHARP; break;
		case NoteValue.D_SHARP_SHARP: nv = NoteValue.E_SHARP_SHARP; break;
		case NoteValue.Ebb: nv = NoteValue.Fb; break;
		case NoteValue.Eb: nv = NoteValue.F; break;
		case NoteValue.E: nv = NoteValue.F_SHARP; break;
		case NoteValue.E_SHARP: nv = NoteValue.F_SHARP_SHARP; break;
		case NoteValue.E_SHARP_SHARP: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Fbb: nv = NoteValue.Gbb; break;
		case NoteValue.Fb: nv = NoteValue.Gb; break;
		case NoteValue.F: nv = NoteValue.G; break;
		case NoteValue.F_SHARP: nv = NoteValue.G_SHARP; break;
		case NoteValue.F_SHARP_SHARP: nv = NoteValue.G_SHARP_SHARP; break;
		case NoteValue.Gbb: nv = NoteValue.Abb; break;
		case NoteValue.Gb: nv = NoteValue.Ab; break;
		case NoteValue.G: nv = NoteValue.A; break;
		case NoteValue.G_SHARP: nv = NoteValue.A_SHARP; break;
		case NoteValue.G_SHARP_SHARP: nv = NoteValue.A_SHARP_SHARP; break;
		}
	}

	public void minus_scale_tone ()
	{
		switch (nv){
		case NoteValue.NO_NOTE: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Abb: nv = NoteValue.Gbb; break; 
		case NoteValue.Ab: nv = NoteValue.Gb; break;
		case NoteValue.A: nv = NoteValue.G; break;
		case NoteValue.A_SHARP: nv = NoteValue.G_SHARP; break;
		case NoteValue.A_SHARP_SHARP: nv = NoteValue.G_SHARP_SHARP; break;
		case NoteValue.Bbb: nv = NoteValue.Abb; break;
		case NoteValue.Bb: nv = NoteValue.Ab; break;
		case NoteValue.B: nv = NoteValue.A; break;
		case NoteValue.B_SHARP: nv = NoteValue.A_SHARP; break;
		case NoteValue.B_SHARP_SHARP: nv = NoteValue.A_SHARP_SHARP; break;
		case NoteValue.Cbb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Cb: nv = NoteValue.Bbb; break;
		case NoteValue.C: nv = NoteValue.Bb; break;
		case NoteValue.C_SHARP: nv = NoteValue.B; break;
		case NoteValue.C_SHARP_SHARP: nv = NoteValue.B_SHARP; break;
		case NoteValue.Dbb: nv = NoteValue.Cbb; break;
		case NoteValue.Db: nv = NoteValue.Cb; break;
		case NoteValue.D: nv = NoteValue.C; break;
		case NoteValue.D_SHARP: nv = NoteValue.C_SHARP; break;
		case NoteValue.D_SHARP_SHARP: nv = NoteValue.C_SHARP_SHARP; break;
		case NoteValue.Ebb: nv = NoteValue.Dbb; break;
		case NoteValue.Eb: nv = NoteValue.Db; break;
		case NoteValue.E: nv = NoteValue.D; break;
		case NoteValue.E_SHARP: nv = NoteValue.D_SHARP; break;
		case NoteValue.E_SHARP_SHARP: nv = NoteValue.D_SHARP_SHARP; break;
		case NoteValue.Fbb: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Fb: nv = NoteValue.Ebb; break;
		case NoteValue.F: nv = NoteValue.Eb; break;
		case NoteValue.F_SHARP: nv = NoteValue.E; break;
		case NoteValue.F_SHARP_SHARP: nv = NoteValue.E_SHARP; break;
		case NoteValue.Gbb: nv = NoteValue.Fbb; break;
		case NoteValue.Gb: nv = NoteValue.Fb; break;
		case NoteValue.G: nv = NoteValue.F; break;
		case NoteValue.G_SHARP: nv = NoteValue.F_SHARP; break;
		case NoteValue.G_SHARP_SHARP: nv = NoteValue.F_SHARP_SHARP; break;
		}	
	}

		public void minus_interval (Interval interval)
		{
			int noSemiTones;	
			int i;
	
			noSemiTones = interval.to_semiTones();

			for (i = 0; i < noSemiTones; i++){
				minus_semiTone();
			}
		}

	public void minus_semiTone ()
	{
		switch (nv){
		case NoteValue.NO_NOTE: nv = NoteValue.NO_NOTE; break;
		case NoteValue.Abb: nv = NoteValue.Gb; break; 
		case NoteValue.Ab: nv = NoteValue.G; break;
		case NoteValue.A: nv = NoteValue.Ab; break;
		case NoteValue.A_SHARP: nv = NoteValue.A; break;
		case NoteValue.A_SHARP_SHARP: nv = NoteValue.A_SHARP; break;
		case NoteValue.Bbb: nv = NoteValue.Ab; break;
		case NoteValue.Bb: nv = NoteValue.A; break;
		case NoteValue.B: nv = NoteValue.Bb; break;
		case NoteValue.B_SHARP: nv = NoteValue.B; break;
		case NoteValue.B_SHARP_SHARP: nv = NoteValue.B_SHARP; break;
		case NoteValue.Cbb: nv = NoteValue.Bbb; break;
		case NoteValue.Cb: nv = NoteValue.Bb; break;
		case NoteValue.C: nv = NoteValue.B; break;
		case NoteValue.C_SHARP: nv = NoteValue.C; break;
		case NoteValue.C_SHARP_SHARP: nv = NoteValue.C_SHARP; break;
		case NoteValue.Dbb: nv = NoteValue.Cb; break;
		case NoteValue.Db: nv = NoteValue.C; break;
		case NoteValue.D: nv = NoteValue.Db; break;
		case NoteValue.D_SHARP: nv = NoteValue.D; break;
		case NoteValue.D_SHARP_SHARP: nv = NoteValue.D_SHARP; break;
		case NoteValue.Ebb: nv = NoteValue.Db; break;
		case NoteValue.Eb: nv = NoteValue.D; break;
		case NoteValue.E: nv = NoteValue.Eb; break;
		case NoteValue.E_SHARP: nv = NoteValue.E; break;
		case NoteValue.E_SHARP_SHARP: nv = NoteValue.E_SHARP; break;
		case NoteValue.Fbb: nv = NoteValue.Ebb; break;
		case NoteValue.Fb: nv = NoteValue.Eb; break;
		case NoteValue.F: nv = NoteValue.E; break;
		case NoteValue.F_SHARP: nv = NoteValue.F; break;
		case NoteValue.F_SHARP_SHARP: nv = NoteValue.F_SHARP; break;
		case NoteValue.Gbb: nv = NoteValue.Fb; break;
		case NoteValue.Gb: nv = NoteValue.F; break;
		case NoteValue.G: nv = NoteValue.Gb; break;
		case NoteValue.G_SHARP: nv = NoteValue.G; break;
		case NoteValue.G_SHARP_SHARP: nv = NoteValue.G_SHARP; break;
		}
	}

	public bool is_any_sharp_flat()
	{
		if (is_sharp() || is_doubleSharp()
		    || is_flat() || is_doubleFlat() ){
			return true;
		} else {		
			return false;
		}	
	}

	public bool is_sharp()
	{
		bool isSharp;

		switch (nv){
		case NoteValue.A_SHARP: isSharp = true; break; 
		case NoteValue.B_SHARP: isSharp = true; break;
		case NoteValue.C_SHARP: isSharp = true; break;
		case NoteValue.D_SHARP: isSharp = true; break;
		case NoteValue.E_SHARP: isSharp = true; break;
		case NoteValue.F_SHARP: isSharp = true; break;
		case NoteValue.G_SHARP: isSharp = true; break;
		default : isSharp = false; break;
		}	
									
		return isSharp;
	}

	public bool is_doubleSharp()
	{
		bool isDoubleSharp;

		switch (nv){	     
		case NoteValue.A_SHARP_SHARP: isDoubleSharp = true; break;
		case NoteValue.B_SHARP_SHARP: isDoubleSharp = true; break;
		case NoteValue.C_SHARP_SHARP: isDoubleSharp = true; break; 
		case NoteValue.D_SHARP_SHARP: isDoubleSharp = true; break;
		case NoteValue.E_SHARP_SHARP: isDoubleSharp = true; break;
		case NoteValue.F_SHARP_SHARP: isDoubleSharp = true; break;
		case NoteValue.G_SHARP_SHARP: isDoubleSharp = true; break;
		default: isDoubleSharp = false; break;
		}
		
		return isDoubleSharp;
	}

	public bool is_flat()
	{	
		bool isFlat;

		switch (nv){
		case NoteValue.Ab: isFlat = true; break; 
		case NoteValue.Bb: isFlat = true; break;
		case NoteValue.Cb: isFlat = true; break;
		case NoteValue.Db: isFlat = true; break; 
		case NoteValue.Eb: isFlat = true; break; 
		case NoteValue.Fb: isFlat = true; break; 
		case NoteValue.Gb: isFlat = true; break;
		default: isFlat = false; break;
		}
		return isFlat;
	}

	public bool is_doubleFlat()
	{
		bool isDoubleFlat;
	
		switch (nv){
		case NoteValue.Abb: isDoubleFlat = true; break; 
		case NoteValue.Bbb: isDoubleFlat = true; break;
		case NoteValue.Cbb: isDoubleFlat = true; break;
		case NoteValue.Dbb: isDoubleFlat = true; break; 
		case NoteValue.Ebb: isDoubleFlat = true; break; 
		case NoteValue.Fbb: isDoubleFlat = true; break; 
		case NoteValue.Gbb: isDoubleFlat = true; break; 
		default: isDoubleFlat = false; break;
		}	
		return isDoubleFlat;
	}

	public bool is_natural()
	{
		bool isNatural;

		switch (nv){	
		case NoteValue.A: isNatural = true; break;
		case NoteValue.B: isNatural = true; break;
		case NoteValue.C: isNatural = true; break;
		case NoteValue.D: isNatural = true; break;
		case NoteValue.E: isNatural = true; break;
		case NoteValue.F: isNatural = true; break;
		case NoteValue.G: isNatural = true; break;
		default : isNatural = false; break;
		}
		return isNatural;
	}

	public void to_flat()
	{
	switch (nv){
		case NoteValue.A_SHARP: nv = NoteValue.Bb; break;
		case NoteValue.B: nv = NoteValue.Cb; break; 
		case NoteValue.B_SHARP_SHARP: nv = NoteValue.Db; break;
		case NoteValue.Cbb: nv = NoteValue.Bb; break;
		case NoteValue.C_SHARP: nv = NoteValue.Db; break;
		case NoteValue.D_SHARP: nv = NoteValue.Eb; break;
		case NoteValue.E: nv = NoteValue.Fb; break; 
		case NoteValue.Fbb: nv = NoteValue.Eb; break;
		case NoteValue.E_SHARP_SHARP: nv = NoteValue.Gb; break;
		case NoteValue.F_SHARP: nv = NoteValue.Gb; break;
		case NoteValue.G_SHARP: nv = NoteValue.Ab; break;
		default : break;
		}
	}

	public void to_sharp()
	{
		switch (nv){
		case NoteValue.Ab: nv = NoteValue.G_SHARP; break; 
		case NoteValue.Bb: nv = NoteValue.A_SHARP; break;
		case NoteValue.B_SHARP_SHARP: nv = NoteValue.C_SHARP; break;
		case NoteValue.Cbb: nv = NoteValue.A_SHARP; break;
		case NoteValue.C: nv = NoteValue.B_SHARP; break;
		case NoteValue.Db: nv = NoteValue.C_SHARP; break; 
		case NoteValue.Eb: nv = NoteValue.D_SHARP; break; 
		case NoteValue.E_SHARP_SHARP: nv= NoteValue.F_SHARP; break;
		case NoteValue.F: nv = NoteValue.E_SHARP; break;
		case NoteValue.Fbb: nv = NoteValue.D_SHARP; break;
		case NoteValue.Gb: nv = NoteValue.F_SHARP; break;
		default: break;
		}		
	}

	public void to_doubleFlat()
	{
		switch (nv){
		case NoteValue.A: nv = NoteValue.Bbb; break;
		case NoteValue.A_SHARP: nv = NoteValue.Cbb; break;
		case NoteValue.Bb: nv = NoteValue.Cbb; break;
		case NoteValue.B_SHARP: nv = NoteValue.Dbb; break;
		case NoteValue.C: nv = NoteValue.Dbb; break;
		case NoteValue.C_SHARP_SHARP: nv = NoteValue.Ebb; break;
		case NoteValue.D: nv = NoteValue.Ebb; break;
		case NoteValue.D_SHARP: nv = NoteValue.Fbb; break;
		case NoteValue.Eb: nv = NoteValue.Fbb; break;
		case NoteValue.E_SHARP: nv = NoteValue.Gbb; break;
		case NoteValue.F: nv = NoteValue.Gbb; break;
		case NoteValue.F_SHARP_SHARP: nv = NoteValue.Abb; break;
		case NoteValue.G: nv = NoteValue.Abb; break;
		case NoteValue.G_SHARP_SHARP: nv = NoteValue.Bbb; break;
		default: break;
		}
	}

	public void to_doubleSharp()
	{
		switch (nv){
		case NoteValue.A: nv = NoteValue.G_SHARP_SHARP; break;
		case NoteValue.Bbb: nv = NoteValue.G_SHARP_SHARP; break;
		case NoteValue.B: nv = NoteValue.A_SHARP_SHARP; break;
		case NoteValue.Cb: nv = NoteValue.A_SHARP_SHARP; break;
		case NoteValue.C_SHARP: nv = NoteValue.B_SHARP_SHARP; break;
		case NoteValue.Db: nv = NoteValue.B_SHARP_SHARP; break;
		case NoteValue.D: nv = NoteValue.C_SHARP_SHARP; break;
		case NoteValue.Ebb: nv = NoteValue.C_SHARP_SHARP; break;
		case NoteValue.E: nv = NoteValue.D_SHARP_SHARP; break;
		case NoteValue.Fb: nv = NoteValue.D_SHARP_SHARP; break;
		case NoteValue.F_SHARP: nv = NoteValue.E_SHARP_SHARP; break;
		case NoteValue.Gb: nv = NoteValue.E_SHARP_SHARP; break;
		case NoteValue.G: nv = NoteValue.F_SHARP_SHARP; break;
		case NoteValue.Abb: nv = NoteValue.F_SHARP_SHARP; break;
		default: break;
		}
	}

	public void to_natural()
	{
		switch (nv){
		case NoteValue.G_SHARP_SHARP: nv = NoteValue.A; break;
		case NoteValue.Bbb: nv = NoteValue.A; break;
		case NoteValue.A_SHARP_SHARP: nv = NoteValue.B; break;
		case NoteValue.Cb: nv = NoteValue.B; break;
		case NoteValue.B_SHARP: nv = NoteValue.C; break;
		case NoteValue.Dbb: nv = NoteValue.C; break;
		case NoteValue.C_SHARP_SHARP: nv = NoteValue.D; break;
		case NoteValue.Ebb: nv = NoteValue.D; break;
		case NoteValue.D_SHARP_SHARP: nv = NoteValue.E; break;
		case NoteValue.Fb: nv = NoteValue.E; break;
		case NoteValue.E_SHARP: nv = NoteValue.F; break;
		case NoteValue.Gbb: nv = NoteValue.F; break;
		case NoteValue.F_SHARP_SHARP: nv = NoteValue.G; break;
		case NoteValue.Abb: nv = NoteValue.G; break;
		default: break;
		}
	}
		
		public bool compare_enharmonic_notes(Note b)
		{
			bool same = false;

			switch (nv){
			case NoteValue.NO_NOTE: 
				if (b.nv == NoteValue.NO_NOTE){
					same = true;
				}
				break;
			case NoteValue.Abb: 
				switch (b.nv){
				case NoteValue.Abb: same = true; break;
				case NoteValue.G: same = true; break;
				case NoteValue.F_SHARP_SHARP: same = true; break;
				}
				break;
			case NoteValue.Ab: 
				switch (b.nv){
				case NoteValue.Ab: same = true; break;
				case NoteValue.G_SHARP: same = true; break;
				}
				break;
			case NoteValue.A: 
				switch (b.nv){
				case NoteValue.A: same = true; break;
				case NoteValue.G_SHARP_SHARP: same = true; break;
				case NoteValue.Bbb: same = true; break;
				}
				break;	
			case NoteValue.A_SHARP: 
				switch (b.nv){
				case NoteValue.A_SHARP: same = true; break;
				case NoteValue.Bb: same = true; break;
				case NoteValue.Cbb: same = true; break;
				}
				break;
			case NoteValue.A_SHARP_SHARP:
				switch (b.nv){
				case NoteValue.A_SHARP_SHARP: same = true; break;
				case NoteValue.B: same = true; break;
				case NoteValue.Cb: same = true; break;
				}
				break;
			case NoteValue.Bbb: 
				switch (b.nv){
				case NoteValue.Bbb: same = true; break;
				case NoteValue.A: same = true; break;
				case NoteValue.G_SHARP_SHARP: same = true; break;
				}
				break;
			case NoteValue.Bb: 
				switch (b.nv){
				case NoteValue.Bb: same = true; break;
				case NoteValue.A_SHARP: same = true; break;
				case NoteValue.Cbb: same = true; break;
				}
				break;
			case NoteValue.B: 
				switch (b.nv){
				case NoteValue.B: same = true; break;
				case NoteValue.A_SHARP_SHARP: same = true; break;
				case NoteValue.Cb: same = true; break; 
				}
				break;
			case NoteValue.B_SHARP:
				switch (b.nv){
				case NoteValue.B_SHARP: same = true; break;
				case NoteValue.C: same = true; break;
				case NoteValue.Dbb: same = true; break;
				}
				break;
			case NoteValue.B_SHARP_SHARP:
				switch (b.nv){
				case NoteValue.B_SHARP_SHARP: same = true; break;
				case NoteValue.C_SHARP: same = true; break;
				case NoteValue.Db: same = true; break;
				}
				break;
			case NoteValue.Cbb: 
				switch (b.nv){
				case NoteValue.Cbb: same = true; break;
				case NoteValue.Bb: same = true; break;
				case NoteValue.A_SHARP: same = true; break;
				}
				break;	
			case NoteValue.Cb:
				switch (b.nv){
				case NoteValue.Cb: same = true; break;
				case NoteValue.B: same = true; break;
				case NoteValue.A_SHARP_SHARP: same = true; break;
				}
				break;	
			case NoteValue.C: 
				switch (b.nv){
				case NoteValue.C: same = true; break;
				case NoteValue.B_SHARP: same = true; break;
				case NoteValue.Dbb: same = true; break;
				}
				break;
			case NoteValue.C_SHARP:
				switch (b.nv){
				case NoteValue.C_SHARP: same = true; break;
				case NoteValue.B_SHARP_SHARP: same = true; break;
				case NoteValue.Db: same = true; break;
				}
				break;
			case NoteValue.C_SHARP_SHARP:
				switch (b.nv){
				case NoteValue.C_SHARP_SHARP: same = true; break;
				case NoteValue.D: same = true; break;
				case NoteValue.Ebb: same = true; break;
				}
				break;
			case NoteValue.Dbb: 
				switch (b.nv){
				case NoteValue.Dbb: same = true; break;
				case NoteValue.C: same = true; break;
				case NoteValue.B_SHARP: same = true; break;
				}
				break;
			case NoteValue.Db: 
				switch (b.nv){
				case NoteValue.Db: same = true; break;
				case NoteValue.C_SHARP: same = true; break;
				case NoteValue.B_SHARP_SHARP: same = true; break;
				}
				break;
			case NoteValue.D: 
				switch (b.nv){
				case NoteValue.D: same = true; break;
				case NoteValue.C_SHARP_SHARP: same = true; break;
				case NoteValue.Ebb: same = true; break;
				}
				break;
			case NoteValue.D_SHARP: 
				switch (b.nv){	
				case NoteValue.D_SHARP: same = true; break;
				case NoteValue.Eb: same = true; break;
				case NoteValue.Fbb: same = true; break;
				}
				break;
			case NoteValue.D_SHARP_SHARP: 
				switch (b.nv){
				case NoteValue.D_SHARP_SHARP: same = true; break;
				case NoteValue.E: same = true; break;
				case NoteValue.Fb: same = true; break;
				}
				break;
			case NoteValue.Ebb: 
				switch (b.nv){
				case NoteValue.Ebb: same = true; break;
				case NoteValue.D: same = true; break;
				case NoteValue.C_SHARP_SHARP: same = true; break;
				}
				break;
			case NoteValue.Eb: 
				switch (b.nv){
				case NoteValue.Eb: same = true; break;
				case NoteValue.D_SHARP: same = true; break;
				case NoteValue.Fbb: same = true; break;
				}
				break;
			case NoteValue.E: 
				switch (b.nv){
				case NoteValue.E: same = true; break;
				case NoteValue.Fb: same = true; break;
				case NoteValue.D_SHARP_SHARP: same = true; break;
				}
				break;	
			case NoteValue.E_SHARP:
				switch (b.nv){
				case NoteValue.E_SHARP: same = true; break;
				case NoteValue.F: same = true; break;
				case NoteValue.Gbb: same = true; break;
				}
				break;
			case NoteValue.E_SHARP_SHARP:
				switch (b.nv){
				case NoteValue.E_SHARP_SHARP: same = true; break;
				case NoteValue.F_SHARP: same = true; break;
				case NoteValue.Gb: same = true; break;
				}
				break;
			case NoteValue.Fbb: 
				switch (b.nv){
				case NoteValue.Fbb: same = true; break;
				case NoteValue.Eb: same = true; break;
				case NoteValue.D_SHARP: same = true; break;
				}
				break;
			case NoteValue.Fb: 
				switch (b.nv){
				case NoteValue.Fb: same = true; break;
				case NoteValue.E: same = true; break;
				case NoteValue.D_SHARP_SHARP: same = true; break;
				}
				break;
			case NoteValue.F: 
				switch (b.nv){
				case NoteValue.F: same = true; break;
				case NoteValue.E_SHARP: same = true; break;
				case NoteValue.Gbb: same = true; break;
				}
				break;
			case NoteValue.F_SHARP: 
				switch (b.nv){
				case NoteValue.F_SHARP: same = true; break;
				case NoteValue.E_SHARP_SHARP: same = true; break;
				case NoteValue.Gb: same = true; break;
				}
				break;
			case NoteValue.F_SHARP_SHARP:
				switch (b.nv){
				case NoteValue.F_SHARP_SHARP: same = true; break;
				case NoteValue.G: same = true; break;
				case NoteValue.Abb: same = true; break;
				}
				break;
			case NoteValue.Gbb: 
				switch (b.nv){
				case NoteValue.Gbb: same = true; break;
				case NoteValue.F: same = true; break;
				case NoteValue.E_SHARP: same = true; break;
				}
				break;
			case NoteValue.Gb: 
				switch (b.nv){
				case NoteValue.Gb: same = true; break;
				case NoteValue.F_SHARP: same = true; break;
				case NoteValue.E_SHARP_SHARP: same = true; break;
				}
				break;
			case NoteValue.G: 
				switch (b.nv){
				case NoteValue.G: same = true; break;
				case NoteValue.F_SHARP_SHARP: same = true; break;
				case NoteValue.Abb: same = true; break;
				}
				break;
			case NoteValue.G_SHARP: 
				switch (b.nv){
				case NoteValue.G_SHARP: same = true; break;
				case NoteValue.Ab: same = true; break;
				}
				break;
			case NoteValue.G_SHARP_SHARP:
				switch (b.nv){
				case NoteValue.G_SHARP_SHARP: same = true; break;
				case NoteValue.A: same = true; break;
				case NoteValue.Bbb: same = true; break;
				}
				break;
			}
	
			return same;
		} 
		
		public int get_difference(Note b)
		{
			ushort difference = 0;
			Note a = new Note(nv);
			
			while (!a.compare_enharmonic_notes(b)){
				difference++;
				a.plus_semiTone();
			}
	
			return difference;
		}

		public short compare (Note b)
		{
			short comparison;
				
			if ((short)nv < (short)b.nv){	
				comparison = -1;
			} else if ((short)b.nv < (short)nv){
				comparison = 1;
			} else {
				comparison = 0;
			}

			return comparison;
		}
	//*********************private**************************
	
		private NoteValue text_to_noteValue(string text)
		{
			NoteValue note;
	
			if (text == null 
			    || text == ""	
			    || text[0] == 'X' 
			    || text == "None") {
				note = NoteValue.NO_NOTE;
			} else if (text == "Any") {
				note = NoteValue.ANY;
			} else if (text == "U") {
				note = NoteValue.UNKNOWN;
			} else if (text == "Abb") {
				note = NoteValue.Abb;
			} else if (text == "Ab") {
				note = NoteValue.Ab;
			} else if (text == "A") {
				note = NoteValue.A;
			} else if (text == "A#") {
				note = NoteValue.A_SHARP;
			} else if (text == "A##") {
				note = NoteValue.A_SHARP_SHARP;
			} else if (text == "Bbb") {
				note = NoteValue.Bbb;
			} else if (text == "Bb") {
				note = NoteValue.Bb;
			} else if (text == "B") {
				note = NoteValue.B;
			} else if (text == "B#") {
				note = NoteValue.B_SHARP;
			} else if (text == "B##") {
				note = NoteValue.B_SHARP_SHARP;
			} else if (text == "Cbb") {
				note = NoteValue.Cbb;	
			} else if (text == "Cb") {
				note = NoteValue.Cb;
			} else if (text == "C") {
				note = NoteValue.C;
			} else if (text == "C#") {
				note = NoteValue.C_SHARP;
			} else if (text == "C##") {
				note = NoteValue.C_SHARP_SHARP;
			} else if (text == "Dbb") {
				note = NoteValue.Dbb;
			} else if (text == "Db") {
				note = NoteValue.Db;
			} else if (text == "D") {
				note = NoteValue.D;
			} else if (text == "D#") {
				note = NoteValue.D_SHARP;
			} else if (text == "D##") {
				note = NoteValue.D_SHARP_SHARP;
			} else if (text == "Ebb") {
				note = NoteValue.Ebb;
			} else if (text == "Eb") {
				note = NoteValue.Eb;
			} else if (text == "E") {
				note = NoteValue.E;
			} else if (text == "E#") {
				note = NoteValue.E_SHARP;
			} else if (text == "E##") {
				note = NoteValue.E_SHARP_SHARP;
			} else if (text == "Fbb") {
				note = NoteValue.Fbb;
			} else if (text == "Fb") {
				note = NoteValue.Fb;
			} else if (text == "F") {
				note = NoteValue.F;
			} else if (text == "F#") {
				note = NoteValue.F_SHARP;
			} else if (text == "F##") {
				note = NoteValue.F_SHARP_SHARP;
			} else if (text == "Gbb") {
				note = NoteValue.Gbb;
			} else if (text == "Gb") {
				note = NoteValue.Gb;
			} else if (text == "G") {
				note = NoteValue.G;
			} else if (text == "G#") {
				note = NoteValue.G_SHARP;
			} else if (text == "G##") {
				note = NoteValue.G_SHARP_SHARP;
			} else {
				note = NoteValue.UNKNOWN;
			}
			return note;
		}	
		
	static string noteValue_to_text(NoteValue note)
		{
			string text = null;
	
			switch (note){
			case NoteValue.NO_NOTE: text = "X"; break;
			case NoteValue.UNKNOWN: text = "U"; break;
			case NoteValue.ANY: text = "Any"; break;
			case NoteValue.Abb: text = "Abb"; break;
			case NoteValue.Ab: text = "Ab"; break;
			case NoteValue.A: text = "A"; break;
			case NoteValue.A_SHARP: text = "A#"; break;
			case NoteValue.A_SHARP_SHARP: text = "A##"; break;
			case NoteValue.Bbb: text = "Bbb"; break;
			case NoteValue.Bb: text = "Bb"; break;
			case NoteValue.B: text = "B"; break;
			case NoteValue.B_SHARP: text = "B#"; break;
			case NoteValue.B_SHARP_SHARP: text = "B##"; break; 
			case NoteValue.Cbb: text = "Cbb"; break;
			case NoteValue.Cb: text = "Cb"; break;
			case NoteValue.C:	text = "C"; break;
			case NoteValue.C_SHARP: text = "C#"; break;
			case NoteValue.C_SHARP_SHARP: text = "C##"; break;
			case NoteValue.Dbb: text = "Dbb"; break;
			case NoteValue.Db: text = "Db"; break;
			case NoteValue.D: text = "D"; break;
			case NoteValue.D_SHARP: text = "D#"; break;
			case NoteValue.D_SHARP_SHARP: text = "D##"; break;
			case NoteValue.Ebb: text = "Ebb"; break;
			case NoteValue.Eb: text = "Eb"; break;
			case NoteValue.E:	text = "E"; break;
			case NoteValue.E_SHARP: text = "E#"; break;
			case NoteValue.E_SHARP_SHARP: text = "E##"; break;
			case NoteValue.Fbb: text = "Fbb"; break;
			case NoteValue.Fb: text = "Fb"; break;
			case NoteValue.F: text = "F"; break;
			case NoteValue.F_SHARP: text = "F#"; break;
			case NoteValue.F_SHARP_SHARP: text = "F##"; break;
			case NoteValue.Gbb: text = "Gbb"; break;
			case NoteValue.Gb: text = "Gb"; break;
			case NoteValue.G:	text = "G"; break;
			case NoteValue.G_SHARP: text = "G#"; break;
			case NoteValue.G_SHARP_SHARP: text = "G##"; break;
			default:	
				text = ""; break;
			}
			return text;
		}	

		static public bool text_is_note(string text)
			{
				bool isNote = false;
			switch (text){
			case "Abb": isNote = true; break;
			case "Ab": isNote = true; break;
			case "A": isNote = true; break;
			case "A#": isNote = true; break;
			case "A##": isNote = true; break;
			case "Bbb": isNote = true; break;
			case "Bb": isNote = true; break;
			case "B": isNote = true; break;
			case "B#": isNote = true; break;
			case "B##": isNote = true; break;
			case "Cbb": isNote = true; break;
			case "Cb": isNote = true; break;
			case "C": isNote = true; break;
			case "C#": isNote = true; break;
			case "C##": isNote = true; break;
			case "Dbb": isNote = true; break;
			case "Db": isNote = true; break;
			case "D": isNote = true; break;
			case "D#": isNote = true; break;
			case "D##": isNote = true; break;
			case "Ebb": isNote = true; break;
			case "Eb": isNote = true; break;
			case "E": isNote = true; break;
			case "E#": isNote = true; break;	    
			case "E##": isNote = true; break;
			case "Fbb": isNote = true; break;
			case "Fb": isNote = true; break;
			case "F": isNote = true; break;
			case "F#": isNote = true; break;
			case "F##": isNote = true; break;
			case "Gbb": isNote = true; break;
			case "Gb": isNote = true; break;
			case "G": isNote = true; break;
			case "G#": isNote = true; break;
			case "G##": isNote = true; break;
			}
		return isNote;
		}
		public Note clone()
		{
			return MemberwiseClone() as Note;
		}
	}	
}