namespace gnomeguitar_cs
{
	public enum ScaleTypeValue {
			MAJOR,
			MELODIC_MINOR,
			HARMONIC_MINOR,
			PENTATONIC,
			CHROMATIC,
			BLUES,
			DOUBLE_HARMONIC,
			WHOLE_TONE,
			AUGMENTED,
			DIMINISHED,
		NONE,
			UNKNOWN,
			ANY
		}

	public class ScaleType {
		
		public static ScaleTypeValue[] ScaleTypes = {ScaleTypeValue.ANY,
			ScaleTypeValue.MAJOR,
			ScaleTypeValue.MELODIC_MINOR,
			ScaleTypeValue.HARMONIC_MINOR,
			ScaleTypeValue.PENTATONIC,
			ScaleTypeValue.CHROMATIC,
			ScaleTypeValue.BLUES,
			ScaleTypeValue.DOUBLE_HARMONIC,
			ScaleTypeValue.WHOLE_TONE,
			ScaleTypeValue.AUGMENTED,
			ScaleTypeValue.DIMINISHED,
			ScaleTypeValue.NONE,
			ScaleTypeValue.UNKNOWN
			};
		
		ScaleTypeValue type = ScaleTypeValue.NONE;
		string[][] types = new string[10][];
	
		public ScaleType (){
		types[(int)ScaleTypeValue.MELODIC_MINOR] = new string[7] {"1: Melodic Minor",
			"2: Phrygian #6 (java)",	
			"3: Lydian augmented", 
			"4: Overtone",
			"5: Hindustan",
			"6: Locrian #2",
			"7: Superlocrian"};
		
		types[(int)ScaleTypeValue.MAJOR] = new string[7] {"1: Ionian (Major)", "2: Dorian",
			"3: Phrygian", "4: Lydian",
			"5: Mixolydian", "6: Aeolian (Minor)",
			"7: Locrian"};
		
		types[(int)ScaleTypeValue.HARMONIC_MINOR] = new string[7] {"1: Harmonic Minor",
			"2: Harmonic Minor",
			"3: Harmonic Minor",
			"4: Romainian",
			"5: Spanish gypsy",
			"6: Harmonic Minor",
			"7: Harmonic Minor"};
		
		types[(int)ScaleTypeValue.PENTATONIC] = new string[5] {"1: Pentatonic",
			"2: Egyptian",
			"3: Pentatonic",
			"4: Ritusen",
			"5: Minor Pentatonic"};
			
		types[(int)ScaleTypeValue.BLUES] = new string[6] {"1: Blues", "2: Blues",
			"3: Blues","4: Blues",
			"5: Blues","6: Minor Blues"};
			
		types[(int)ScaleTypeValue.DOUBLE_HARMONIC] = new string[7] {"1: Byzantine",
			"2: Double Harmonic",
			"3: Double Harmonic",
			"4: Hungarian Minor",
			"5: Oriental",
			"6: Double Harmonic",
			"7: Double Harmonic"};
			
		types[(int)ScaleTypeValue.CHROMATIC] = new string[1] {"1: Chromatic"};
		types[(int)ScaleTypeValue.WHOLE_TONE] = new string[1] {"1: Whole Tone"};
		types[(int)ScaleTypeValue.AUGMENTED] = new string[1] {"1: Augmented"};
		types[(int)ScaleTypeValue.DIMINISHED] = new string[1] {"1: Diminished"};
		}
		
		public int get_noModes()
		{
			return types[(int)type].Length;
		}

		public string get_modeName(int mode)
		{
			return types[(int)type][mode];
		
		}
		public ScaleType (ScaleTypeValue value) : this()
		{
			type= value;
		}
		
		public ScaleType (string text) : this()
		{
			switch (text){
			case "Any": type = ScaleTypeValue.ANY; break;
			case "Major": type = ScaleTypeValue.MAJOR; break;
			case "Melodic Minor": type = ScaleTypeValue.MELODIC_MINOR; break;	
			case "Harmonic Minor": type = ScaleTypeValue.HARMONIC_MINOR; break;
			case "Pentatonic": type = ScaleTypeValue.PENTATONIC; break;
			case "Double Harmonic": type = ScaleTypeValue.DOUBLE_HARMONIC; break;
			case "Chromatic": type = ScaleTypeValue.CHROMATIC; break;
			case "Whole Tone": type = ScaleTypeValue.WHOLE_TONE; break;
			case "Augmented": type = ScaleTypeValue.AUGMENTED; break;
			case "Diminished": type = ScaleTypeValue.DIMINISHED; break;
			case "Blues": type = ScaleTypeValue.BLUES; break;
			}
		}

		public string to_text()
		{
			string text = null;
			
			switch (type){
			case ScaleTypeValue.NONE:
				text = "None";
				break;
			case ScaleTypeValue.UNKNOWN:
				text = "Unknown";
				break;
			case ScaleTypeValue.ANY:
				text = "Any";
				break;
			case ScaleTypeValue.MAJOR:
				text = "Major";
				break;
			case ScaleTypeValue.MELODIC_MINOR:
				text = "Melodic Minor";
				break;
			case ScaleTypeValue.HARMONIC_MINOR:
				text = "Harmonic Minor";
				break;
			case ScaleTypeValue.PENTATONIC:
				text = "Pentatonic";
				break;
			case ScaleTypeValue.CHROMATIC:
				text = "Chromatic";
				break;
			case ScaleTypeValue.BLUES:
				text = "Blues";
				break;
			case ScaleTypeValue.DOUBLE_HARMONIC:
				text = "Double Harmonic";
				break;
			case ScaleTypeValue.WHOLE_TONE:
				text = "Whole Tone";
				break;
			case ScaleTypeValue.AUGMENTED:
				text = "Augmented";
				break;
			case ScaleTypeValue.DIMINISHED:
				text = "Diminished";
				break;
			}
			return text;
		}		
			
		public static bool operator == (ScaleType x, ScaleType y) {
			return x.type == y.type;
		}
		
		public static bool operator != (ScaleType x, ScaleType y) {
			return x.type != y.type;
		}
		
		public override bool Equals(object o) {
			if(!(o is ScaleType))
				return false;
			return this == (ScaleType)o;
		}
		
		public override int GetHashCode()
		{
			return (int)type;
		}
		
		public static implicit operator ScaleTypeValue(ScaleType x) {
			return x.type;
		}
	}
}	