using System;
using System.Text;

namespace gnomeguitar_cs
{
	
	
	public class Written
	{
		string text;
		
		public Written(){
		}
		
		public Written(string text){
			this.text = text;
		}
		
		public Written(GenericWritten written, Note root){
			this.text = root.to_text() + written.to_text();
		}
		
		public short compare(Written b)
		{	
			return (short)text.CompareTo(b.text);
		}

		public GenericWritten to_generic()
		{
			short end = 1;
			string genericWritten;
			
			//System.Console.WriteLine("Written.to_generic: Written to be genericfied = {0}", text);
			if(text.Length > end){ 
				if (text[end] == '#' || text[end] == 'b'){
					end++;
					if (text[end] == '#' || text[end] == 'b'){
						end++;
					}
				}
			}
			genericWritten = text.Substring(end, text.Length - end);
			//System.Console.WriteLine("Written.to_generic: Written to be genericfied to = {0}", genericWritten);
			return new GenericWritten(genericWritten);
		}
		
		public string to_xml()
		{
			StringBuilder xml = new StringBuilder ();
			
			xml.AppendFormat("<written>{0}</written>", text);
			return xml.ToString();
		}

		public static bool is_valid(string text)
		{
			return text.Length > 0;
		}
		
		public string to_text()
		{
			return text;
		}
	}
}