using System;
using Gtk;

namespace gnomeguitar_cs
{
	public class ChordFilter: Frame
	{		
	
		ChordGroup allChords;
		ChordGroup typeSubGroup;
		ChordGroup rootSubGroup;
		
		ShapesOM shapesOM;
		ChordTypesOM typesOM;
		NotesOM rootsOM;
		bool frozen = false;
		
		public delegate void ChangedHandler (object info, EventArgs args);

		public event ChangedHandler onChanged;
		public ChordFilter()
		{
			//Label = "Chord Filter";
			Shadow = ShadowType.None;
			build_widget();
		}
		
		public ChordFilter(ChordGroup chordGroup): this()
		{ 
			set_chords(chordGroup);
		}
			     
		public void set_chords(ChordGroup chordGroup)
		{
			allChords = chordGroup;
			allChords.onContentsChanged += new ObjGroup.ContentsChangedHandler(allChords_changed_cb);
			//frozen = true;
			set_typesOM(allChords);
			//frozen = false;
			//shapesOM_changed_cb (this, new EventArgs());
		}


		public ChordGroup get_subGroup()
		{
			return rootSubGroup.create_shape_sub_group(shapesOM.get_shape());
		}
		

/*********************************************************
 ********************PRIVATE STUFF************************
 ********************************************************/

		void build_widget()
		{
			HBox hBox;
			Label label;
			
			hBox = new HBox(false, 5);
			hBox.BorderWidth = 5;

			typesOM = new ChordTypesOM();
			label = new Label("Type:");
			hBox.PackStart(label, false, false, 0);
			hBox.PackStart(typesOM, true, true, 0);

			rootsOM = new NotesOM(true);
			label = new Label("Root:");
			hBox.PackStart(label, false, false, 0);
			hBox.PackStart(rootsOM, false, false, 0);

			label = new Label("Shape:");
			shapesOM = new ShapesOM();
			hBox.PackStart(label, false, false, 0);
			hBox.PackStart(shapesOM, true, true, 0);

			Add(hBox);

			typesOM.Changed += typesOM_changed_cb;
			rootsOM.Changed += rootsOM_changed_cb;
			shapesOM.Changed += shapesOM_changed_cb;
		}

		void set_typesOM(ChordGroup chordGroup)
		{
			ObjGroup chordTypes;

			chordTypes = chordGroup.get_chordTypes();
			chordTypes.add_by_index(new ChordType("Any"), 0);
			typesOM.set_chordTypes(chordTypes);
		}

		void set_shapesOM(ChordGroup chordGroup)
		{
			ObjGroup chordShapes;

			chordShapes = chordGroup.get_chordShapes();
			chordShapes.add_by_index(new ChordShape(ChordShapeValue.ANY), 0);
			shapesOM.set_shapes(chordShapes);
		}

		void set_rootsOM(ChordGroup chordGroup)
		{
			NoteGroup chordRoots;

			chordRoots = chordGroup.get_roots();
			chordRoots.add_by_index(new Note(NoteValue.ANY), 0);
			rootsOM.set_notes(chordRoots);
		}


/*****************************************************************
 ***********************CALLBACKS*********************************
 ****************************************************************/

		void typesOM_changed_cb (object o, EventArgs args)
		{
			//System.Console.WriteLine("ChordFilter.typesOM_changed_cb: typesOM changed");
			ChordType chordType;

			chordType  = typesOM.get_chordType();
			//System.Console.WriteLine("ChordFilter.typesOM_changed_cb: chordType = {0}", chordType.to_text());
			typeSubGroup = allChords.create_type_sub_group(chordType);
			set_rootsOM(typeSubGroup);
		}

		void rootsOM_changed_cb (object o, EventArgs args)
		{ 
			//System.Console.WriteLine("ChordFilter.rootsOM_changed_cb: rootsOM changed");
			Note root;

			root = rootsOM.get_note();
			rootSubGroup = typeSubGroup.create_root_sub_group(root);
			set_shapesOM(rootSubGroup);
		}
		
		void allChords_changed_cb (object o, EventArgs args)
		{
			//System.Console.WriteLine("ChordFilter.allChords_changed_cb: allChords changed");
			set_typesOM(allChords);
		}
		void shapesOM_changed_cb (object o, EventArgs args)
		{
			//System.Console.WriteLine("ChordFilter.shapesOM_changed_cb: shapesOMChanged");
			if(onChanged != null && !frozen){onChanged(this, new EventArgs());}
		}
	}
}