using System;
using Gtk;

namespace gnomeguitar_cs
{
	public class ChordScaleFilter: Frame
	{		
		ChordGroup allChords;
		ChordGroup subGroup;
		
		ScaleTypesOM typesOM;
		ScaleModesOM modesOM;
		NotesOM rootsOM;
		
		public delegate void ChangedHandler (object info, EventArgs args);
		public event ChangedHandler onChanged;
//		public delegate void AllChordsChangedHandler (object info, EventArgs args);
//		public event AllChordsChangedHandler onAllChordsChanged;
		
		public ChordScaleFilter ()
		{
			//Label = "Scale Filter";
			Shadow = ShadowType.None;
			build_widget();
//			onAllChordsChanged += new AllChordsChangedHandler(typesOM_changed_cb);
		}

		public ChordScaleFilter (ChordGroup chordGroup): this()
		{ 
			set_chords(chordGroup);
		}

		public void set_chords(ChordGroup chordGroup)
		{
			allChords = chordGroup;
			if(onChanged != null){onChanged(this, new EventArgs());}
		}

		public ChordGroup get_subGroup()
		{
			Scale scale;
			ScaleType scaleType;
			Note root; 
			int mode;

			scaleType = typesOM.get_scaleType();
			if(scaleType == ScaleTypeValue.ANY){
				subGroup = allChords;
			} else { 
				root = rootsOM.get_note();
				mode = modesOM.get_mode();
				//System.Console.WriteLine("ChordScaleFilter.get_subGroup: Begining ScaleType = {0}, root = {1}, mode = {2}", scaleType.to_text(), root.to_text(), mode.ToString());
				scale = new Scale(root, scaleType, mode);
				//System.Console.WriteLine("ChordScaleFilter.get_subGroup: End ScaleType = {0}, root = {1}, mode = {2}", scaleType.to_text(), root.to_text(), mode.ToString());
				//System.Console.WriteLine("ChordScaleFilter.get_subGroup: Scale = {0}", scale.to_text());
				subGroup = allChords.create_scale_sub_group(scale);
				//System.Console.WriteLine("ChordScaleFilter.get_subGroup: Subgroup = {0}", subGroup.to_xml());
				
			}

			return subGroup;
		}

/**************************************************************************
 *************************************PRIVATE STUFF************************
***************************************************************************/

		void build_widget()
		{
			HBox hbox;
			Label label;

			hbox = new HBox(false, 5);
			hbox.BorderWidth = 5;

			typesOM = new ScaleTypesOM(true);
			typesOM.Changed += new EventHandler(typesOM_changed_cb);
			label = new Label("Type:");
			hbox.PackStart(label, false, false, 0);
			hbox.PackStart(typesOM, true, true, 0);

			rootsOM = new NotesOM(false);
			rootsOM.Changed += rootsOM_changed_cb;
			rootsOM.set_na(true);
			label = new Label("Root:");
			hbox.PackStart(label, false, false, 0);
			hbox.PackStart(rootsOM, true, true, 0);	

			modesOM = new ScaleModesOM(false);
			modesOM.Changed += new EventHandler(modesOM_changed_cb);
			modesOM.set_na(true);
			label = new Label("Mode:");
			hbox.PackStart(label, false, false, 0);
			hbox.PackStart(modesOM, true, true, 0);	
			
			Add(hbox);
		}

		void set_modesOM()
		{
			ScaleType scaleType;

			scaleType = typesOM.get_scaleType();
			modesOM.set_scale(scaleType);
		}

		
/***************************************************************
 *************************CALLBACKS*****************************
 ***************************************************************/

		void typesOM_changed_cb(object o, EventArgs args)
		{

			if(typesOM.get_scaleType() == ScaleTypeValue.ANY){
				rootsOM.set_na(true);
				modesOM.set_na(true);
				if(onChanged != null){onChanged(this, new EventArgs());}
//				set_subGroup();
			} else {
				rootsOM.set_na(false);
//              calling set_modes does this for us
//				modesOM.na(false);
				set_modesOM();
			}
		}

		void  rootsOM_changed_cb(object o, EventArgs args)
		{
			if(onChanged != null){onChanged(this, new EventArgs());}
		}

		void modesOM_changed_cb(object o, EventArgs args)
		{
			if(onChanged != null){onChanged(this, new EventArgs());}
		}
	}
}