using GLib;
using System;
using Gtk;

namespace gnomeguitar_cs
{

	public class ChordTreeModel: ChordTreeRoot, TreeModel{
		
		int stamp;
		
		public delegate void ChangedHandler (object info, EventArgs args);
		public event ChangedHandler onChanged;
		
		public ChordTreeModel ()
		{
			Random random = new Random();
			stamp =	random.Next();
			onNodeInserted += nodeInserted_cb;
		}
		

		public TreeIter iter_new_from_node(ChordTreeNode node)
		{
			TreeIter iter;

			iter = new TreeIter();
			iter.Stamp = stamp;
			iter.UserData = node.GetEnumerator();
	
			return iter;
		}
	


/********************************************************
 ********* Fulfill the GtkTreeModel requirements ********
 ********************************************************/

		public TreeModelFlags Flags {
			get { return 0;}
		}

		public int NColumns { 
			get {return 1;}
		}
		
		public GType GetColumnType (int index)
		{
			return GType.String;
		}

		public bool GetIter (out TreeIter iter, TreePath  path)
		{
	
			int i = 0, j;
			ObjGroup treeNodeList;
			
			i = path.Indices[0];
			j = get_no();
			if (i >= j){
				return false;
			}

			iter.Stamp = stamp;
			treeNodeList = (ObjGroup)nth(path.Indices[0]);
			for(i = 1; i < depth; i++){
				treeNodeList = (ObjGroup)treeNodeList.nth(indices[i]);
			}

			iter.UserData = treeNodeList.GetEnumerator(i, treeNodeList.get_no() -i);
			return true;
		}
		
		public bool GetIterFirst (out TreeIter iter)
		{
			if (get_no() == 0){
				return false;
			}

			iter.Stamp = stamp;
			iter.UserData = GetEnumerator();

			return true;
		}
		
		public TreePath GetPath (TreeIter iter)
		{		
			ChordTreeNode chordTreeNode;
			int index;
			int depth;
			TreePath treePath;
			
			treePath = new TreePath ();

			chordTreeNode = (ChordTreeNode)((Enumerator)iter.UserData).Current;
			depth = chordTreeNode.depth;
	
			while (true){
				if(depth == 0){
					treePath.PrependIndex(chordTreeNode.treeID);
					break;
				}
				index = chordTreeNode.parent.position_same(chordTreeNode);
				treePath.PrependIndex(index);
				chordTreeNode = chordTreeNode.parent;
				depth--;
			}

			return retval;
		}

		public object GetValue (TreeIter iter, int column)
		{
		
			ChordTreeNode chordTreeNode;
			string gcharValue;
	
			chordTreeNode  = (ChordTreeNode)(((IEnumerator)iter.UserData).Current);
			gcharValue = chordTreeNode.get_string_rep();
	
			return gcharValue;
		}
		
			
		public void GetValue (TreeIter iter, int column, ref Value value)
		{
			ChordTreeNode chordTreeNode;
			
			chordTreeNode  = (ChordTreeNode)(((IEnumerator)iter.UserData).Current);
			value.Init (GType.String);
			value.Val = chordTreeNode.get_string_rep();
		}

		public void SetValue(TreeIter iter, int i, object obj)
		{return;}
		public void SetValue(TreeIter iter, int i, uint obj)
		{return;}
		public void SetValue(TreeIter iter, int i, float obj)
		{return;}		
		public void SetValue(TreeIter iter, int i, string obj)
		{return;}
		public void SetValue(TreeIter iter, int i, int obj)
		{return;}
		public void SetValue(TreeIter iter, int i, double obj)
		{return;}
		public void SetValue(TreeIter iter, int i, bool obj)
		{return;}
		public int IterNChildren()
		{
			return get_no();
		}

		public bool IterNext (ref TreeIter iter)
		{
			int row;

			row = iter.UserData;
			row++;
			iter.UserData = row;
			return ((IEnumerator)iter.UserData2).MoveNext();
		}
		
		public bool IterChildren (out TreeIter iter,
		                          TreeIter parent)
		{
			if(((ChordTreeNode)(((IEnumerator)iter.UserData).Current)).get_no() == 0)
			{
				iter = new TreeIter();
				return false;
			}
			iter.Stamp = stamp;
			iter.UserData = ((ChordTreeNode)(((IEnumerator)iter.UserData).Current)).GetEnumerator();
			return true;
		}
		
		public bool IterChildren (out TreeIter iter)
		{
			if (get_no() != 0)
			{
				iter.Stamp = stamp;
				iter.UserData = GetEnumerator();
				return true;
			} else {
				return false;
			}
		}
		
		public bool IterHasChild (TreeIter iter)
		{	
			return ((ChordTreeNode)(((IEnumerator)iter.UserData).Current)).get_no() == 0;
		}
				
		public int IterNChildren(TreeIter iter)
		{	
			return ((ChordTreeNode)(((IEnumerator)iter.UserData).Current)).get_no();
		}
		
		public bool IterNthChild (out TreeIter iter, TreeIter parent, int n)
		{
			iter.UserData = ((ChordTreeNode)(((IEnumerator)iter.UserData).Current)).nth(i).GetEnumerator();	
			return iter.UserData == null;
		}
		
		public bool IterNthChild (out TreeIter iter, int n)
		{
			iter.UserData = nth(i).GetEnumerator();
			return iter.UserData == null;
		}
		public bool GetIterFromString(out TreeIter iter, string text)
		{	
			iter = new TreeIter();
			return false;
		}
		public bool IterParent (out TreeIter iter,
		                        TreeIter child)
		{
	
			iter.stamp = stamp;
			iter.UserData = ((ChordTreeNode)(((IEnumerator)iter.UserData).Current)).parent.GetEnumerator();
			return iter.UserData == null;
		}
		
		public void Foreach (TreeModelForeachFunc func)
		{
			return;
		}
		
		public void RefNode(TreeIter iter)
		{
			return;
		}
		
		public string GetStringFromIter(TreeIter iter)
		{
			return "";
		}
		
		public void GetValist (TreeIter iter, System.IntPtr var_args)
		{
			return;
		}
		
		public void UnrefNode (TreeIter iter)
		{
			return;
		}	

/***************************************************************************
 **************************PRIVATE STUFF************************************
 **************************************************************************/

		void nodeInserted_cb(object o, ChordTreeRootEventArgs args)
		{
			TreeIter iter;
			TreePath path;
  
			iter.stamp = stamp;
			iter.userData = args.chordTreeNode.GetEnumerator();

			path = GetPath(iter);
	
			RowInserted(path, &iter);
			if(args.chordTreeNode.get_no() == 0){
				RowHasChildToggled(path, iter);
			}
		}
	}
}
	
