using System;
using System.Collections;
using Gtk;

namespace gnomeguitar_cs
{
	
	public class ChordTreeNode : ObjGroup, ITreeNode 
	{
		static Random random = new Random();
		
		ChordTreeRoot root;
		ChordTreeNode parent;
		ChordTreeNodeType type;
		ChordTreeNodeData  data;
		ChordTreeNodeType childrenType;
		int depth;
		int treeID;
		int nodeID;
		
//***************************************************		
//              ITREE INTERFACE STUFF
//***************************************************
		
		public int ChildCount {
			get { return get_no();}
		}
		
		public int ID {
			get { return nodeID;}
		}
		
		ITreeNode ITreeNode.this[int i]
		{
			get
			{
				return (ITreeNode)nth(i);
			}
		}
		
		public ITreeNode Parent {
			//This is so the root node doesn't show up in the tree.
			get {
				if (parent.type != ChordTreeNodeTypeValue.ROOT){
				    return parent;
				} else {
					return null;
				}
			}
		}
		
		int ITreeNode.IndexOf (object o){
			return position_equal(o);
		}
		
		public event System.EventHandler Changed;
		public event TreeNodeAddedHandler ChildAdded;
		public event TreeNodeRemovedHandler ChildRemoved;
		
//***************************************************		
//           END OF ITREE INTERFACE STUFF
//***************************************************
		
		public ChordTreeNode(){}
				      
		public ChordTreeNode(ChordTreeRoot root,
		                     ChordTreeNode parent,
		                     ChordTreeNodeType type,
		                     ChordTreeNodeData  data,
		                     ChordTreeNodeType childrenType,
		                     int depth,
		                     int treeID )
		{
		
			this.root = root;
			this.parent = parent;
			this.type = type;
			this.childrenType = childrenType;
			this.depth = depth;
			this.treeID = treeID;
			this.nodeID = random.Next();
	//		System.Console.WriteLine("ChordTreeNode: childrenType = {0} in Node constructor", childrenType.to_text());
			if(data != null){
				set_node_data(data);
			}
		}

		public ChordTreeNode(ChordTreeNode parent, ChordTreeNodeData nodeData, ChordTreeNodeType childrenType) :
			this(parent.root, parent, parent.childrenType, nodeData,
			     childrenType,
			     parent.depth +1, parent.treeID)
		{			
		}
		
		public ChordTreeNode(ChordTreeNode nodeParent, ChordTreeNodeData nodeData) :
			this (nodeParent.root,
			      nodeParent,
			      nodeParent.childrenType,
			      nodeData,
			      nodeParent.root.get_tree_node_grandchildren_type(nodeParent),
			      nodeParent.depth +1,
			      nodeParent.treeID)  
		{
		}
		
		public void set_node_data(ChordTreeNodeData nodeData)
		{
			data = nodeData;
			data.onChanged += onChanged_cb;
		}


		public ChordTreeRoot get_root()
		{
			return root;
		}
	
		public ChordTreeNode get_parent()
		{
			//The top most treeNode has null for it's parent
			return parent;
		}

		public ChordTreeNodeType get_node_type()
		{
			return type;
		}

		public ChordTreeNodeData get_node_data()
		{
			return data;
		}


		public ChordTreeNodeType get_children_type()
		{
			return childrenType;
		}

		public int get_depth()
		{
			return depth;
		}

		public int get_treeID()
		{
			return treeID;
		}

		public void append_chord(Chord chord)
		{
			//System.Console.WriteLine("ChordTreeNode.append_chord: This node type = {0}, ChildType = {1}", type.to_text(), childrenType.to_text()); 
			//If childType == CHORD then we add the chord to this node
			if(childrenType == ChordTreeNodeTypeValue.CHORD){
				if (!has_equal(chord)){
					ChordTreeNode chordTreeNode = new ChordTreeNode(root,
					                                                this,
					                                                new ChordTreeNodeType(ChordTreeNodeTypeValue.CHORD),
					                                                new ChordTreeNodeData(chord),
					                                                new ChordTreeNodeType(ChordTreeNodeTypeValue.NONE),
					                                                depth + 1,
					                                                treeID);
					append(chordTreeNode);
					return;
				}
			}

			//else we get the childTree of the correct type (creating it if it dose not exist) and add the chord to it
			ChordTreeNode childTree = get_childTree(chord, true);
			childTree.append_chord(chord);
		}

		public string get_string_rep()
		{
			string stringRep = null;

			switch((ChordTreeNodeTypeValue)type){
			case ChordTreeNodeTypeValue.ROOT:
				stringRep = "Root";
				break;
			case ChordTreeNodeTypeValue.LABEL:
				stringRep = data.get_label();
				break;
			case ChordTreeNodeTypeValue.TUNING:
				stringRep = data.get_tuning().to_text();
				break;
			case ChordTreeNodeTypeValue.CHORD_TYPE:
				stringRep = data.get_chordType().to_text();
				break;
			case ChordTreeNodeTypeValue.CHORD_SHAPE:
				stringRep = data.get_chordShape().to_text();
				break;
			case ChordTreeNodeTypeValue.CHORD_ROOT:
				stringRep = data.get_chordRoot().to_text();
				break;
			case ChordTreeNodeTypeValue.CHORD:
				stringRep = data.get_chord().get_name();
				break;
			}

			return stringRep;
		}

//don't know what this does
//GSList
//get_slist()
//{
//        GSList list = null;
//
//       	g_return_val_if_fail(self != null, null);
//	g_return_val_if_fail(IS_CHORD_TREE_NODE(self), null);
//
//	if(parent == null){
//		list = g_slist_find(GP_GROUP(chordTreeRoot)->gps, self);
//	} else {
//		list = g_slist_find(GP_GROUP(parent)->gps, self);
//	}
//
//	return list;
//}
// This looks messed up
		public void append_chords(ChordGroup chords)
		{
						
			if(type == ChordTreeNodeTypeValue.CHORD){
				chords.append(data.get_chord());
				return;
			}

			if(childrenType == ChordTreeNodeTypeValue.NONE)
				return;

			foreach (ChordTreeNode child in this){			
				if(childrenType == ChordTreeNodeTypeValue.CHORD){
					chords.append(child.data.get_chord());
				} else {
					child.append_chords(chords);
				}
			}
			
			return ;
		}

		public ChordGroup get_chords()
		{
			ChordGroup chords = new ChordGroup();
			
			if(type == ChordTreeNodeTypeValue.CHORD){
				chords.append(data.get_chord());
				return chords;
			}

			if(childrenType == ChordTreeNodeTypeValue.NONE)
				return chords;

			foreach (ChordTreeNode child in this){			
				if(childrenType == ChordTreeNodeTypeValue.CHORD){
					chords.append(child.data.get_chord());
				} else {
					child.append_chords(chords);
				}
			}
			
			return chords;
		}

		public void remove_chords()
		{

			if (childrenType == ChordTreeNodeTypeValue.CHORD){
				clear();
			} else {
				foreach(ChordTreeNode chordTreeNode in this){
					chordTreeNode.remove_chords();
				}
			}
		}
		
		public ChordTreeNode get_chord_node(Chord chord)
		{
			ChordTreeNode childTree = null;
			ChordTreeNode chordNode = null;
			
	//If childType == CHORD then we have the chord we need (get child checks it's the right one)
			if(childrenType == ChordTreeNodeTypeValue.CHORD){
				return this;
			}

	//else we get the childTree of the correct type and search that

			childTree = get_childTree(chord, false);
			if(childTree != null){
				chordNode = childTree.get_chord_node(chord);
			}
	
			return chordNode;
		}
	
//
// PRIVATE
//
		
		ChordTreeNode get_childTree(Chord chord, bool createTree)
		{
			bool haveChildTree = false;
//			Tuning tuning = null;
			ChordType chordType = null;
			ChordTreeNode ctn = null;
			
			if(childrenType == ChordTreeNodeTypeValue.CHORD){
				return null;
			}
	//		System.Console.WriteLine("ChordTreeNode.get_childTree: childrenType = {0}", childrenType.to_text());
			//first we see if a suitable child tree already exists
	
			foreach (ChordTreeNode childTree in this){
				switch((ChordTreeNodeTypeValue)childrenType){
				case ChordTreeNodeTypeValue.TUNING:
					//System.Console.WriteLine("ChordTreeNode.get_childTree: chord tuning = {0}, this tuning = {1}",chord.get_tuning().to_text(), childTree.data.get_tuning().to_text() );
					if(chord.get_tuning() == childTree.data.get_tuning()){
						haveChildTree = true;
					}
					break;
				case ChordTreeNodeTypeValue.CHORD_TYPE:
					chordType = chord.get_chordType();
					haveChildTree = chordType == childTree.data.get_chordType();
					break;
				case ChordTreeNodeTypeValue.CHORD_SHAPE:
					haveChildTree = chord.get_shape() == childTree.data.get_chordShape();
					break;
				case ChordTreeNodeTypeValue.CHORD_ROOT:
					haveChildTree = chord.get_root() == childTree.data.get_chordRoot();
					break;
					}
				if (haveChildTree){
					ctn = childTree;
					break;
				}
			}
			
			
			if(!haveChildTree && createTree){
				ChordTreeNodeData data = null;
				
				switch ((ChordTreeNodeTypeValue)childrenType){
				case ChordTreeNodeTypeValue.CHORD: break;
				case ChordTreeNodeTypeValue.TUNING: 
					data = new ChordTreeNodeData(chord.get_tuning());
					break;
				case ChordTreeNodeTypeValue.CHORD_TYPE:
					data = new ChordTreeNodeData(chord.get_chordType());
					break;
				case ChordTreeNodeTypeValue.CHORD_SHAPE:
					data = new ChordTreeNodeData(chord.get_shape());
				//	System.Console.WriteLine("ChordTreeNode.get_childTree: ChordShape = {0}", chord.get_shape().to_text());
					break;
				case ChordTreeNodeTypeValue.CHORD_ROOT:
					data = new ChordTreeNodeData(chord.get_root());						
					break;
					}
				
				//System.Console.WriteLine("ChordTreeNode.get_childTree: expectant parent = {0}, childs data = {1}, treeID = {2}", this.type.to_text(), data, this.treeID);
					ctn = new ChordTreeNode(this, data);
					append(ctn);
				}
			//System.Console.WriteLine("ChordTreeNode.get_childTree: CreatedChild = {0}, CreatedChild childsType = {1}, treeID = {2}", ctn.type.to_text(), ctn.childrenType.to_text(), ctn.treeID);
			return ctn;
		}
		
		void onChanged_cb(object o, EventArgs args)
		{
				if(Changed != null){Changed(this, args);}
		}
	}
}