using System;

namespace gnomeguitar_cs
{
	public class ChordTreeRoot : ChordTreeNode{

//These are indexed by treeID, whatever that means		
		ObjGroup chords;
		ObjGroup layouts;

		public class ChordTreeRootEventArgs : EventArgs
		{
			public ChordTreeNode chordTreeNode;
			
			public ChordTreeRootEventArgs(ChordTreeNode chordTreeNode)
			{
				this.chordTreeNode = chordTreeNode;
			}
		}
		
//		public delegate void ChordTreeRootInsertedHandler (object chordTreeRoot, 
//		                                                   ChordTreeRootEventArgs information);
//		
//		public event ChordTreeRootInsertedHandler onNodeInserted;
		
		public ChordTreeRoot (): base (null, null, new ChordTreeNodeType(ChordTreeNodeTypeValue.ROOT),
		                               null, new ChordTreeNodeType(ChordTreeNodeTypeValue.LABEL),0,1)
		{
			chords=new ObjGroup();
			layouts = new ObjGroup();
			//System.Console.WriteLine("ChordTreeRoot: childrenType = {0} in root constructor", get_children_type().to_text());
		}

		public ChordTreeNodeType get_tree_node_grandchildren_type(ChordTreeNode node)
		{
			ChordTreeNodeType nodeType;
			TreeLayout treeLayout = null;
			
			//System.Console.WriteLine("ChordTreeRoot.get_tree_node_grandchildren_type: treeID = {0}, depth = {1}", node.get_treeID(), node.get_depth());
			treeLayout = (TreeLayout)layouts.nth(node.get_treeID());
			//we add 2 because we want the grandchildType and minus two because the treeLayout doesen't include the root and label nodes
			nodeType = (ChordTreeNodeType)treeLayout.nth(node.get_depth());
			return nodeType;
		}

		public void add_tree(ChordGroup chords,
		                     TreeLayout treeLayout,
		                     int index)
		{
			if(index == -1){	
				index = this.chords.get_no();
			} 
			String label = "Chord Tree " + index.ToString() +2;
			add_tree(chords, treeLayout, index, label);
		}
		
		public void add_tree(ChordGroup chords,
		                     TreeLayout treeLayout,
		                     int index,
		                     string label)
		{
			ChordTreeNode ctn;
			ChordTreeNodeType grandchildType;
			
			//An index of minus one means append and 0 prepend

			if(index == -1){	
				index = this.chords.get_no();
			} 
			
			//System.Console.WriteLine("ChordTreeRoot.add_tree: index = {0}", index);
			this.chords.add_by_index(chords, index);
			this.layouts.add_by_index(treeLayout, index);
			
			grandchildType = treeLayout.nth(0) as ChordTreeNodeType;
			ctn = new ChordTreeNode(this, this, new ChordTreeNodeType(ChordTreeNodeTypeValue.LABEL),
			                        new ChordTreeNodeData(label), grandchildType, 1, index);
			add_by_index(ctn, index);
			
			foreach (Chord chord in chords){
				ctn.append_chord(chord);
			}
			
			//if(onNodeInserted != null && !frozen){onNodeInserted(this, new ChordTreeRootEventArgs(chordTreeNode));}
		}
		
		public void set_tree(ChordGroup chords,
		                     TreeLayout treeLayout)
		{	
			clear();
			add_tree(chords, treeLayout, 0);	
		}
		
		public override void clear()
		{
			this.chords.clear();
			this.layouts.clear();
			base.clear();
			
		}
//		ChordTreeNode get_chord_node(Chord chord)
//		{	
//	//		rootNode = (ChordTreeNode)nth(0);
//		//	chordNode = rootNode.get_chord_node(chord);
//			return ((ChordTreeNode)nth(0)).get_chord_node(chord);
//		}

	}
}