using Gtk;
using System;

namespace gnomeguitar_cs
{
	
	public class ChordTypesOM : ComboBox
	{
		ObjGroup chordTypes;
		ListStore listStore;
		bool frozen = false;
		
		public delegate void ChangedHandler (object obj, EventArgs args);		
		public new event ChangedHandler Changed;
	
		public ChordTypesOM()
		{
			base.Changed += baseOnChangedHandler;
			listStore = new ListStore(new GLib.GType[]{GLib.GType.String});
			Model = listStore;
			CellRendererText cell = new CellRendererText();
			PackStart(cell, true);
			AddAttribute(cell, "text", 0);
		}
		
		public ChordTypesOM(ObjGroup chordTypes):this()
		{
			set_chordTypes(chordTypes);
		}
		
		public void set_chordType(ChordType chordType)
		{
			//Do we still need to fire the changed event if the chordType is set to the currently selected chordType?
			
			if(chordType == ""){
				Active = 0;
			} else {
				Active = (chordTypes.position_equal(chordType));
			}		
		}

		public ChordType get_chordType()
		{
			return (ChordType)chordTypes.nth(Active);
		}

		public void set_chordTypes(ObjGroup chordTypes)
		{	
			frozen = true;
			listStore.Clear();
			foreach (ChordType chordType in chordTypes){
				listStore.AppendValues(chordType.to_text());
			}
			this.chordTypes = chordTypes;
			frozen = false;
			Active = 0;
		}	
		
		void baseOnChangedHandler(object obj, EventArgs args)
		{
			if(Changed != null && !frozen){Changed(this, new EventArgs());}
		}
	}
}