using System;
using Gtk;

namespace gnomeguitar_cs
{
	
	public class ConstructionView : HBox
	{
		Construction construction;
		Label label = new Label();
		
		public delegate void ChangedHandler (object info, 
		                                     EventArgs information);
		
		public event ChangedHandler onChanged;
		
		public ConstructionView() 
		{
			build_widget();
		}

		public void set_construction(Construction construction)
		{
			this.construction = construction;
			label.Text = construction.to_text();
		}

		public Construction get_construction()
		{
			return construction;
		}

/******************************************
 ***************PRIVATE STUFF**************
 ******************************************/

		void build_widget()
		{
			Button button = new Button("Edit Construction");
			button.Clicked += new System.EventHandler(button_cb);
			
			PackStart(label, true, true, 0);
			PackStart(button, false, false, 0);
		}

		void button_cb (object obj, EventArgs args)
		{
			new GetStringDialog((Window)((Widget)obj).Toplevel, "Enter new construction:", string_entered_cb, Construction.is_valid_construction);
		}

		void string_entered_cb(string text)
		{
			Construction construction;

			construction = new Construction(text);
			set_construction(construction);
			if(onChanged != null){onChanged(this, new EventArgs());}
		}
	
	
	}
}