using System;
using GConf;
using Gtk;

namespace gnomeguitar_cs
{
		
	public class GConfWorkaround
	{
		GConf.Client client = new GConf.Client();
		string chordPath = "/apps/gnome-guitar/libgnomeguitar/chordRenderer";
		string scalePath = "/apps/gnome-guitar/libgnomeguitar/scaleRenderer";
		
		public GConfWorkaround()
		{			
		}
			
		public bool fix(Window parent)
		{	
			set_defaults();
			bool ok = check();
			string error = ok? "An error occurred accessing the preferences. They have been reset to defaults which has fixed the problem.":
				               "An error occurred accessing the preferences. As a result they have been disabled.";
			MessageDialog md = new MessageDialog (parent, 
			                                      DialogFlags.DestroyWithParent,
			                                      MessageType.Error, 
			                                      ButtonsType.Ok, error);
			md.Run ();
			md.Destroy();
			return ok;
		}
		
		private void set_defaults()
		{
			client.Set(chordPath + "/chordRotation", (int)ChordRotation.Vertical);
			client.Set(chordPath + "/rightHanded", true);
			client.Set(chordPath + "/highStringFirst", false);
			client.Set(scalePath + "/rightHanded", true);
			client.Set(scalePath + "/highStringFirst", true);
		}
		
		private bool check()
		{
			bool ok = true;
			try{
				client.Get(chordPath + "/chordRotation");
				client.Get(chordPath + "/rightHanded");
				client.Get(chordPath + "/highStringFirst");
				client.Get(scalePath + "/rightHanded");
				client.Get(scalePath + "/highStringFirst");
			}
			catch (GConf.NoSuchKeyException){ok = false;}
			return ok;
		}
	}
}
