using System;
using Gtk;

namespace gnomeguitar_cs
{
	public class GetStringDialogArgs: EventArgs
	{
		public string text;
		
		public GetStringDialogArgs(String text)
		{
			this.text = text;
		}
	}
	
	public class GetStringDialog: Dialog
	{
		Entry answer;
		
		public delegate void StringEnteredFunc (string text);
		public delegate bool ResponseCheckerFunc (string text);
		StringEnteredFunc stringEnteredFunc;
		ResponseCheckerFunc responseCheckerFunc;
		
		public GetStringDialog (Window parent, string question,
		                        StringEnteredFunc stringEnteredFunc,
		                        ResponseCheckerFunc responsCheckerFunc): base ("", parent, DialogFlags.DestroyWithParent)
		{
			Modal = true;
			
			this.stringEnteredFunc = stringEnteredFunc;
			this.responseCheckerFunc = responsCheckerFunc;
			answer = new Entry();
			VBox.PackStart(new Label(question));
			VBox.PackStart(answer);
			
			AddButton ("OK", ResponseType.Ok); 
			AddButton ("Cancel", ResponseType.Cancel);
			
			Response += new ResponseHandler (on_dialog_response);
			Run ();
			Destroy ();	
		}
		
		void on_dialog_response(object obj, ResponseArgs args)
		{
			if (args.ResponseId == ResponseType.Cancel){return;}
			if(responseCheckerFunc(answer.Text)) {stringEnteredFunc(answer.Text); return;}
			else { 
				MessageDialog md = new MessageDialog ((Window)obj, 
				                                      DialogFlags.DestroyWithParent,
				                                      MessageType.Error, 
				                                      ButtonsType.Close,
				                                      "Invalid Answer",
				                                      null);
 
				md.Run ();
				md.Destroy(); 
				return;
			}
		}
	}
}