using System;
using Gtk;

namespace gnomeguitar_cs
{

	public class GuitarStringEditor : Frame{
		
		short stringNo;
		CheckButton is12plusCB;
		FingersOM fingersOM;
		NotesOM possibleNotesOM;
		
		public delegate void FingerChangedHandler (object info, EventArgs args);
		public event FingerChangedHandler onFingerChanged;
		public delegate void FrettedChangedHandler (object info, EventArgs args);
		public event FrettedChangedHandler onFrettedChanged;
		public delegate void Is12PlusHandler (object info, EventArgs args);
		public event Is12PlusHandler onIs12PlusChanged;

		public GuitarStringEditor ()
		{
			build_widget();
		}

		public GuitarStringEditor (GuitarString guitarString, 
		                           NoteGroup possibleNotes,
		                           short stringNo): this()
		{
			set_string(guitarString, possibleNotes, stringNo);
		}

		public void set_string(GuitarString guitarString,
		                       NoteGroup possibleNotes,
		                       short stringNo)
		{
		//	string tunedText;

			this.stringNo = stringNo;
	//		tunedText = guitarString.get_tuned().to_text();
	//		Label = tunedText;

			fingersOM.set_finger(guitarString.get_finger());
			possibleNotesOM.set_notes(possibleNotes);
			possibleNotesOM.set_note(guitarString.get_fretted());
			is12plusCB.Active = guitarString.is12plus();
		}


		public short get_string_no()
		{
			return stringNo;
		}

		public bool is12plus()
		{
			return is12plusCB.Active;
		}

		public Finger get_finger()
		{
			return fingersOM.get_finger();
		}

		public Note get_fretted()
		{
			return possibleNotesOM.get_note();
		}

/*********************************************************
 ********************PRIVATE STUFF************************
 ********************************************************/

		void build_widget()
		{
			HBox hbox;

			fingersOM = new FingersOM();
			possibleNotesOM = new NotesOM(true); 
			is12plusCB = new CheckButton("12+");
	
			fingersOM.Changed += new EventHandler(fingersOM_cb);
			possibleNotesOM.Changed += possibleNotesOM_cb;
			is12plusCB.Toggled += new EventHandler(is12plusCB_cb);

			hbox = new HBox(false, 5);
			hbox.BorderWidth = 5;

			hbox.PackStart(fingersOM, true, true, 0);
			hbox.PackStart(possibleNotesOM, true, true, 0);	
			hbox.PackStart(is12plusCB, false, false, 0);
			
			Add(hbox);
		}


/********************************************************
 *********************CALLBACKS**************************
 ********************************************************/

		void fingersOM_cb(object o, EventArgs args)
		{
			if(onFingerChanged != null){onFingerChanged(this, new EventArgs());}
		}

		void possibleNotesOM_cb(object o, EventArgs args)
		{
				if(onFrettedChanged != null){onFrettedChanged(this, new EventArgs());}
		}

		void is12plusCB_cb(object o, EventArgs args)
		{
			if(onIs12PlusChanged != null){onIs12PlusChanged(this, new EventArgs());}
		}
	}
}
