using Gtk;
using System;

namespace gnomeguitar_cs
{
	
	public class NotesOM : ComboBox
	{
		NoteGroup notes;
		ListStore realStore;
		ListStore naStore;
		bool frozen = false;
		
		public delegate void ChangedHandler (object obj, EventArgs args);		
		public new event ChangedHandler Changed;
		
		public NotesOM()
		{
			base.Changed += baseOnChangedHandler;
			realStore = new ListStore(new GLib.GType[]{GLib.GType.String});
			naStore = new ListStore(new GLib.GType[]{GLib.GType.String});
			Model = realStore;
			CellRendererText cell = new CellRendererText();
			PackStart(cell, true);
			AddAttribute(cell, "text", 0);
			naStore.AppendValues(new Note(NoteValue.NO_NOTE).to_text());
		}

		public NotesOM(NoteGroup notes) : this()
		{
			set_notes(notes);
		}
		
		public NotesOM(bool withAny) : this() 
		{
			NoteGroup notes;
			
			if (withAny){
				notes = new NoteGroup(NoteValue.ANY, NoteValue.Ab,NoteValue.A,NoteValue.A_SHARP,
				                                NoteValue.Bb,NoteValue.B,NoteValue.B_SHARP,
				                                NoteValue.Cb,NoteValue.C,NoteValue.C_SHARP,
				                                NoteValue.Db,NoteValue.D,NoteValue.D_SHARP,
				                                NoteValue.Eb,NoteValue.E,NoteValue.E_SHARP,
				                                NoteValue.Fb,NoteValue.F,NoteValue.F_SHARP,
				                                NoteValue.Gb,NoteValue.G,NoteValue.G_SHARP);
			} else {
				notes = new NoteGroup(NoteValue.Ab,NoteValue.A,NoteValue.A_SHARP,
			                                NoteValue.Bb,NoteValue.B,NoteValue.B_SHARP,
			                                NoteValue.Cb,NoteValue.C,NoteValue.C_SHARP,
			                                NoteValue.Db,NoteValue.D,NoteValue.D_SHARP,
			                                NoteValue.Eb,NoteValue.E,NoteValue.E_SHARP,
			                                NoteValue.Fb,NoteValue.F,NoteValue.F_SHARP,
			                                NoteValue.Gb,NoteValue.G,NoteValue.G_SHARP);
				
			}
			
			set_notes(notes);
		}

		public Note get_note()
		{
			return Active == -1? new Note(NoteValue.NO_NOTE):(Note)notes.nth(Active);
		}
		
		public void set_note(Note note)
		{
			Active = notes.position_equal(note);
		}

		public void set_notes(NoteGroup notes)
		{
			frozen = true;
			realStore.Clear();
			foreach (Note note in notes){
				realStore.AppendValues(note.to_text());
			}
			this.notes = notes;
			frozen = false;
			Active = 0;
			Sensitive = true;
		}
		
		public void set_na(bool na)
		{
			if (na){
				Model = naStore;
				Sensitive = false;
				Active = 0;
			} else {
				Model = realStore;
				Active = 0;
				Sensitive = true;
				
			}		
		}
	
		void baseOnChangedHandler(object obj, EventArgs args)
		{
			if(Changed != null && !frozen){Changed(this, new EventArgs());}
		}
	}
}