using System.Text;
using System;
using Gtk;

namespace gnomeguitar_cs
{
	
	public class RendererContainer: VBox
	{
		Label info = new Label();
		Button previousButton = new Button ("<< Previous");
		Button nextButton = new Button("Next >>");
		Frame realWidgetContainer = new Frame();
		ChordRendererUI renderer;
		int chordsPerPage, noChords = 0, chordsStartNo = -1, chordsEndNo = -1;
		ChordGroup chords;
		ZoomOM zoomOM;
		
		public RendererContainer ()
		{
			realWidgetContainer.ShadowType = ShadowType.None;
			Spacing = 5;
			Homogeneous = false;
			BorderWidth = 10;
			info.Justify = Justification.Center;
			
			build_widget();
		}

		public RendererContainer(ChordRendererUI chordRenderer): this()
		{
			set_renderer(chordRenderer);
		}
		
		public void set_renderer(ChordRendererUI renderer)
		{
			this.renderer = renderer;
			set_up_real_widget();
		}


		public void clear ()
		{
			this.chords = null;
			zoomOM.Sensitive = false;
			chordsStartNo = -1;
			noChords = 0;
			chordsEndNo = -1;
			renderer.clear();
			set_info();
		}

		public void render_default()
		{
			renderer.render_default();
		}

		public void render (ChordGroup chords)
		{
			this.chords = chords;
			if(!zoomOM.Sensitive){
				zoomOM.Sensitive = true;
			}
			zoomOM.set_max_no(chords.get_no());
			chordsStartNo = 0;
			render();
		}
		

/***********************************************************
 ***********************PRIVATE*****************************
 ***********************************************************/

		void render()
		{			
			noChords = chords.get_no();
			chordsEndNo = chordsPerPage + chordsStartNo > noChords -1? noChords - 1: chordsPerPage + chordsStartNo -1;

			ChordGroup chordsToRender = chords.create_numbered_sub_group(chordsStartNo, chordsEndNo);
		
			renderer.render(chordsToRender);
			set_info();
			//System.Console.WriteLine("FIX ME! RendererContainer.render: we should be using iterators not subgroups for the next and previous buttons");
			//System.Console.WriteLine("RendererContainer.render: noChords = {0}, chordsEndNo = {1}, chordsPerPage = {2}, chordsStartNo = {3}", noChords, chordsEndNo, chordsPerPage, chordsStartNo);
	}
		
		void build_widget()
		{
			zoomOM = new ZoomOM();
			zoomOM.set_zoom(1);
			chordsPerPage = 1;
			zoomOM.onChanged += zoomOM_cb;
			PackStart(zoomOM,false,false,0);
				       
			PackStart(realWidgetContainer, true, true, 0);
			
			set_info();
			
			HBox hBox = new HBox(true, 5);
			hBox.BorderWidth = 5;
			hBox.PackStart(previousButton, true, true, 0);
			previousButton.Clicked += new EventHandler (previous_button_cb);
		
			Frame frame = new Frame();
			frame.ShadowType = ShadowType.Out;
			frame.Add(info);
			hBox.PackStart(frame, true, true,0);
			hBox.PackStart(nextButton, true, true, 0);
			nextButton.Clicked += new EventHandler (next_button_cb);
			PackStart(hBox, false, false, 0);
		}

		void set_up_real_widget()
		{
			Widget realWidget;

			realWidget = renderer.get_widget();
			realWidgetContainer.Add(realWidget);
		}

		void set_info()
		{
			StringBuilder text;

			//We add 1 to make it look as if chords start at 1 rather than 0
			text = new StringBuilder();
			text.AppendFormat("{0} to {1}\n of {2}" , 
			                  chordsStartNo +1,
			                  chordsEndNo +1,
			                  noChords);
			info.Text = text.ToString();
		//	System.Console.WriteLine("RendererContainer.set_info: Info = {0}",text.ToString());
			
			previousButton.Sensitive = chordsStartNo > 0;
			nextButton.Sensitive = chordsEndNo +1 < noChords;
		}
		
/****************************************************************
 ***********************CALLBACKS********************************
 ***************************************************************/

	 	void zoomOM_cb(object obj, EventArgs args)
		{
			chordsPerPage = zoomOM.get_zoom();
			if(chordsStartNo + chordsPerPage > chords.get_no() -1){
				chordsStartNo = chordsEndNo - chordsPerPage;
				if (chordsStartNo < 0){
					chordsStartNo = 0;
				}
			}
			render();
		}
		
		void next_button_cb(object obj, EventArgs args)
		{
			chordsStartNo += chordsPerPage;
			render();
		}

		void previous_button_cb(object obj, EventArgs args)
		{
			chordsStartNo -= chordsPerPage;
			if (chordsStartNo < 0){
				chordsStartNo = 0;
			}
			render();
		}
	}
}