using Gtk;

namespace gnomeguitar_cs
{
	
	public class TuningsOM : ComboBox
	{
		ObjGroup tunings;
		ListStore listStore;
		
		public TuningsOM()
		{
			listStore = new ListStore(new GLib.GType[]{GLib.GType.String});
			Model = listStore;
			CellRendererText cell = new CellRendererText();
			PackStart(cell, true);
			AddAttribute(cell, "text", 0);
		}

		public TuningsOM(ObjGroup tunings): this()
		{
			set_tunings(tunings);
		}
		
		public void set_tuning(Tuning tuning)
		{
			//Do we still need to fire the changed event if the tuning is set to the currently selected tuning?
			if(tuning == ""){
				Active = 0;
			} else {
				Active = tunings.position_equal(tuning);
			}		
		}

		public Tuning get_tuning()
		{
			return (Tuning)tunings.nth(Active);
		}

		public void set_tunings(ObjGroup tunings)
		{
			listStore.Clear();
			foreach (Tuning tuning in tunings){
				listStore.AppendValues(tuning.to_text());
			}
			this.tunings = tunings;
			Active = 0;
		}	
	}
}