//This is used by chordCreator so uses generic writtens

using System;
using Gtk;

namespace gnomeguitar_cs
{
	public class WrittenEditedArgs : EventArgs
		{
			public GenericWritten written;
			public string newText; 
			
			public WrittenEditedArgs(GenericWritten written, string newText)
			{
				this.written = written;
				this.newText = newText;
			}
		}		
		
		public class WrittenAddedArgs : EventArgs
		{
			public GenericWritten written;
			
			public WrittenAddedArgs(GenericWritten written)
			{
				this.written = written;
				//this.newText = newText;
			}
		}		
			
		public class WrittenRemovedArgs : EventArgs
		{
			public GenericWritten written;
			
			public WrittenRemovedArgs(GenericWritten written)
			{
				this.written = written;
			}
		}
		
	public class WrittensList : HBox
	{
		TreeView treeView;
		ListStore store;
		GenericWrittenGroup writtens;
		
		public WrittensList ()
		{	
			Homogeneous = false;
			Spacing = 5;
			BorderWidth = 5;
			build_widget();
			
			ShowAll ();
		}
		
		public WrittensList (GenericWrittenGroup writtens): this()
		{
			set_writtens(writtens);
		}
		
		public void set_writtens (GenericWrittenGroup writtens)
		{
			this.writtens = writtens;
			// create model
			store = CreateModel ();
			treeView.Model = store;
		}

		public delegate void WrittenRemovedHandler (object info, WrittenRemovedArgs args);
		public delegate void WrittenAddedHandler (object info, WrittenAddedArgs args);
		public delegate void WrittenEditedHandler (object info, WrittenEditedArgs args);

		public event WrittenRemovedHandler onWrittenRemoved;
		public event WrittenAddedHandler onWrittenAdded;						
		public event WrittenEditedHandler onWrittenEdited;

/*********************************************************
 ********************PRIVATE STUFF************************
 ********************************************************/

		private void build_widget()
		{
			VBox vBox;
			Button addButton;
			Button removeButton;
 			ScrolledWindow scrolledWindow;
			
			vBox = new VBox(false,5);
		
			scrolledWindow = new ScrolledWindow ();
			scrolledWindow.ShadowType = ShadowType.EtchedIn;
			scrolledWindow.SetPolicy (PolicyType.Automatic, PolicyType.Automatic);
			//PackStart (scrolledWindow, true, true, 0);

			// create tree view
			treeView = new TreeView ();
			treeView.HeadersVisible = false;
			treeView.RulesHint = true;
//			treeView.SearchColumn = (int) Column.Description;
			scrolledWindow.Add (treeView);

			AddColumns (treeView);

			addButton = new Button("Add Written");
			addButton.Clicked += new EventHandler(addButton_cb);
			removeButton = new Button("Remove Written");
			removeButton.Clicked += new EventHandler(removeButton_cb);

			PackStart(scrolledWindow, true, true, 0);
	
			vBox.PackStart(addButton, false, false, 0);
			vBox.PackStart(removeButton, false, false, 0);
	
			PackStart(vBox, false, false, 0);
		}

		private void AddColumns (TreeView treeView)
		{
			CellRendererText rendererText = new CellRendererText ();
			treeView.AppendColumn(new TreeViewColumn ("Written", rendererText, "text", 0));
			rendererText.Edited += new EditedHandler(cell_edited_cb);
		}

		private ListStore CreateModel ()
		{
			ListStore store = new ListStore (typeof(string));

			foreach (GenericWritten written in writtens) {
				store.AppendValues (written.to_text());
				//System.Console.WriteLine("WrittensList.CreateModel: written in listStore = {0}", written.to_text());
			}

			return store;
		}

		GenericWritten get_selected()
		{
	
			TreePath path;
			GenericWritten selectedWritten;

			path = treeView.Selection.GetSelectedRows()[0];
			selectedWritten = writtens[path.Indices[path.Depth]] as GenericWritten;

			return selectedWritten;
		}

/***************************************************************
 ***********************CALLBACKS*******************************
 **************************************************************/

		void cell_edited_cb (object obj, EditedArgs args)
		{
			GenericWritten selectedWritten;

			selectedWritten = get_selected();
			if(onWrittenEdited != null){onWrittenEdited(this, new WrittenEditedArgs(selectedWritten, args.NewText));}
		}

		void addButton_cb (object o,EventArgs args)
		{
			new GetStringDialog((Window)Toplevel, "Tuning Name:", writtenEntered_cb, Written.is_valid);
		}

		void removeButton_cb (object o, EventArgs args)
		{
			GenericWritten selectedWritten;

			selectedWritten = get_selected();
			if(onWrittenRemoved != null){onWrittenRemoved(this, new WrittenRemovedArgs(selectedWritten));}
		}

		void writtenEntered_cb(string newText)
		{
			if(onWrittenAdded != null){onWrittenAdded(this, new WrittenAddedArgs(new GenericWritten(newText)));}
		}
	}
}


