using System;
using Gtk;

namespace gnomeguitar_cs
{
	
	public class ZoomOM : Frame
	{
		int max = 10;
		SpinButton spinner;
		CheckButton zoomAllChords;
	
		public delegate void ChangedHandler (object zoomOM, EventArgs args);		
		public event ChangedHandler onChanged;
		
		public ZoomOM()
		{
			ShadowType = Gtk.ShadowType.Out;
			Frame padding = new Frame();
			padding.ShadowType = Gtk.ShadowType.None;
			padding.BorderWidth = 5;
			HBox hbox = new HBox(false,0);
			hbox.PackStart(new Label("Zoom:"));
			spinner = new SpinButton(0, 10, 1);
			spinner.ValueChanged += spinner_cb;
			hbox.PackStart(spinner);
			hbox.PackStart(new Label("/"));
			zoomAllChords = new CheckButton("All");
			zoomAllChords.Toggled += zoomAllChords_cb;
			hbox.PackStart(zoomAllChords);
			padding.Add(hbox);
			Add(padding);
		}
		
		public void set_zoom(int zoomValue)
		{
			zoomAllChords.Active = zoomValue == 0?true:false;
			spinner.Value = zoomValue;
		}

		public void set_max_no(int maxNo)
		{
			spinner.SetRange(0, maxNo);
			max = maxNo;
		}
		
		public int get_zoom()
		{
			return zoomAllChords.Active? max: spinner.ValueAsInt;
		}
		
//******************************************************************
//**********************CALLBACKS***********************************
//******************************************************************

		void zoomAllChords_cb(object o, EventArgs args)
		{
			spinner.Sensitive = !zoomAllChords.Active;
			if(onChanged != null){onChanged(this, new EventArgs());}
		}
		
		void spinner_cb(object o, EventArgs args)
		{
			zoomAllChords.Active = spinner.ValueAsInt == 0;
			if(onChanged != null){onChanged(this, new EventArgs());}
		}
	}
}