/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define GNOME_SCAN_TYPE_ACQUISITION_WIDGET (gnome_scan_acquisition_widget_get_type ())
#define GNOME_SCAN_ACQUISITION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_ACQUISITION_WIDGET, GnomeScanAcquisitionWidget))
#define GNOME_SCAN_ACQUISITION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_ACQUISITION_WIDGET, GnomeScanAcquisitionWidgetClass))
#define GNOME_SCAN_IS_ACQUISITION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_ACQUISITION_WIDGET))
#define GNOME_SCAN_IS_ACQUISITION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_ACQUISITION_WIDGET))
#define GNOME_SCAN_ACQUISITION_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_ACQUISITION_WIDGET, GnomeScanAcquisitionWidgetClass))

typedef struct _GnomeScanAcquisitionWidget GnomeScanAcquisitionWidget;
typedef struct _GnomeScanAcquisitionWidgetClass GnomeScanAcquisitionWidgetClass;
typedef struct _GnomeScanAcquisitionWidgetPrivate GnomeScanAcquisitionWidgetPrivate;

#define GNOME_SCAN_TYPE_JOB (gnome_scan_job_get_type ())
#define GNOME_SCAN_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_JOB, GnomeScanJob))
#define GNOME_SCAN_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_JOB, GnomeScanJobClass))
#define GNOME_SCAN_IS_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_JOB))
#define GNOME_SCAN_IS_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_JOB))
#define GNOME_SCAN_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_JOB, GnomeScanJobClass))

typedef struct _GnomeScanJob GnomeScanJob;
typedef struct _GnomeScanJobClass GnomeScanJobClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GnomeScanAcquisitionWidget {
	GtkAlignment parent_instance;
	GnomeScanAcquisitionWidgetPrivate * priv;
};

struct _GnomeScanAcquisitionWidgetClass {
	GtkAlignmentClass parent_class;
};

struct _GnomeScanAcquisitionWidgetPrivate {
	GtkProgressBar* progressbar;
	GtkLabel* status_label;
	GnomeScanJob* _job;
	char* _primary;
	char* _secondary;
	char* _icon_name;
};


static gpointer gnome_scan_acquisition_widget_parent_class = NULL;

GType gnome_scan_acquisition_widget_get_type (void);
GType gnome_scan_job_get_type (void);
#define GNOME_SCAN_ACQUISITION_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_ACQUISITION_WIDGET, GnomeScanAcquisitionWidgetPrivate))
enum  {
	GNOME_SCAN_ACQUISITION_WIDGET_DUMMY_PROPERTY,
	GNOME_SCAN_ACQUISITION_WIDGET_JOB,
	GNOME_SCAN_ACQUISITION_WIDGET_PRIMARY,
	GNOME_SCAN_ACQUISITION_WIDGET_SECONDARY,
	GNOME_SCAN_ACQUISITION_WIDGET_ICON_NAME
};
void gnome_scan_acquisition_widget_set_job (GnomeScanAcquisitionWidget* self, GnomeScanJob* value);
void gnome_scan_acquisition_widget_set_primary (GnomeScanAcquisitionWidget* self, const char* value);
void gnome_scan_acquisition_widget_set_secondary (GnomeScanAcquisitionWidget* self, const char* value);
void gnome_scan_acquisition_widget_set_icon_name (GnomeScanAcquisitionWidget* self, const char* value);
GnomeScanAcquisitionWidget* gnome_scan_acquisition_widget_new (GnomeScanJob* job, const char* primary, const char* secondary, const char* icon_name);
GnomeScanAcquisitionWidget* gnome_scan_acquisition_widget_construct (GType object_type, GnomeScanJob* job, const char* primary, const char* secondary, const char* icon_name);
GnomeScanJob* gnome_scan_acquisition_widget_get_job (GnomeScanAcquisitionWidget* self);
double gnome_scan_job_get_progress (GnomeScanJob* self);
gboolean gnome_scan_job_is_running (GnomeScanJob* self);
gboolean gnome_scan_acquisition_widget_monitor_job (GnomeScanAcquisitionWidget* self);
const char* gnome_scan_acquisition_widget_get_primary (GnomeScanAcquisitionWidget* self);
const char* gnome_scan_acquisition_widget_get_secondary (GnomeScanAcquisitionWidget* self);
const char* gnome_scan_acquisition_widget_get_icon_name (GnomeScanAcquisitionWidget* self);
static GObject * gnome_scan_acquisition_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gnome_scan_acquisition_widget_finalize (GObject* obj);
static void gnome_scan_acquisition_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gnome_scan_acquisition_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



GnomeScanAcquisitionWidget* gnome_scan_acquisition_widget_construct (GType object_type, GnomeScanJob* job, const char* primary, const char* secondary, const char* icon_name) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanAcquisitionWidget * self;
	g_return_val_if_fail (job != NULL, NULL);
	g_return_val_if_fail (primary != NULL, NULL);
	g_return_val_if_fail (secondary != NULL, NULL);
	__params = g_new0 (GParameter, 4);
	__params_it = __params;
	if (icon_name == NULL) {
		icon_name = "scanner";
	}
	__params_it->name = "job";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_JOB);
	g_value_set_object (&__params_it->value, job);
	__params_it++;
	__params_it->name = "primary";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, primary);
	__params_it++;
	__params_it->name = "secondary";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, secondary);
	__params_it++;
	__params_it->name = "icon-name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, icon_name);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanAcquisitionWidget* gnome_scan_acquisition_widget_new (GnomeScanJob* job, const char* primary, const char* secondary, const char* icon_name) {
	return gnome_scan_acquisition_widget_construct (GNOME_SCAN_TYPE_ACQUISITION_WIDGET, job, primary, secondary, icon_name);
}


gboolean gnome_scan_acquisition_widget_monitor_job (GnomeScanAcquisitionWidget* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_progress_bar_set_fraction (self->priv->progressbar, MIN (gnome_scan_job_get_progress (self->priv->_job), 1.0));
	result = gnome_scan_job_is_running (self->priv->_job);
	return result;
}


GnomeScanJob* gnome_scan_acquisition_widget_get_job (GnomeScanAcquisitionWidget* self) {
	GnomeScanJob* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_job;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void gnome_scan_acquisition_widget_set_job (GnomeScanAcquisitionWidget* self, GnomeScanJob* value) {
	GnomeScanJob* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_job = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_job), _tmp0_);
	g_object_notify ((GObject *) self, "job");
}


const char* gnome_scan_acquisition_widget_get_primary (GnomeScanAcquisitionWidget* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_primary;
	return result;
}


void gnome_scan_acquisition_widget_set_primary (GnomeScanAcquisitionWidget* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_primary = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_primary), _tmp0_);
	g_object_notify ((GObject *) self, "primary");
}


const char* gnome_scan_acquisition_widget_get_secondary (GnomeScanAcquisitionWidget* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_secondary;
	return result;
}


void gnome_scan_acquisition_widget_set_secondary (GnomeScanAcquisitionWidget* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_secondary = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_secondary), _tmp0_);
	g_object_notify ((GObject *) self, "secondary");
}


const char* gnome_scan_acquisition_widget_get_icon_name (GnomeScanAcquisitionWidget* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_icon_name;
	return result;
}


void gnome_scan_acquisition_widget_set_icon_name (GnomeScanAcquisitionWidget* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_icon_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_icon_name), _tmp0_);
	g_object_notify ((GObject *) self, "icon-name");
}


static GObject * gnome_scan_acquisition_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanAcquisitionWidgetClass * klass;
	GObjectClass * parent_class;
	GnomeScanAcquisitionWidget * self;
	klass = GNOME_SCAN_ACQUISITION_WIDGET_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_ACQUISITION_WIDGET));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_ACQUISITION_WIDGET (obj);
	{
		GtkVBox* box;
		GtkHBox* head_box;
		GtkImage* image;
		GtkVBox* message_box;
		GtkLabel* primary_label;
		char* _tmp0_;
		GtkLabel* secondary_label;
		GtkProgressBar* _tmp1_;
		GtkLabel* _tmp2_;
		g_object_set ((GtkAlignment*) self, "xscale", (float) 0, NULL);
		g_object_set ((GtkAlignment*) self, "yscale", (float) 0, NULL);
		gtk_container_set_border_width ((GtkContainer*) self, (guint) 6);
		box = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) box);
		head_box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) head_box, FALSE, TRUE, (guint) 0);
		image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name (self->priv->_icon_name, GTK_ICON_SIZE_DIALOG));
		gtk_misc_set_alignment ((GtkMisc*) image, (float) 0, (float) 0);
		gtk_misc_set_padding ((GtkMisc*) image, 6, 6);
		gtk_box_pack_start ((GtkBox*) head_box, (GtkWidget*) image, FALSE, TRUE, (guint) 0);
		message_box = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 4));
		gtk_box_pack_start ((GtkBox*) head_box, (GtkWidget*) message_box, FALSE, TRUE, (guint) 0);
		primary_label = g_object_ref_sink ((GtkLabel*) gtk_label_new (NULL));
		gtk_label_set_markup (primary_label, _tmp0_ = g_strdup_printf ("<b><big>%s</big></b>", self->priv->_primary));
		_g_free0 (_tmp0_);
		gtk_misc_set_alignment ((GtkMisc*) primary_label, (float) 0, (float) 0);
		gtk_box_pack_start ((GtkBox*) message_box, (GtkWidget*) primary_label, FALSE, TRUE, (guint) 0);
		secondary_label = g_object_ref_sink ((GtkLabel*) gtk_label_new (self->priv->_secondary));
		gtk_misc_set_alignment ((GtkMisc*) secondary_label, (float) 0, (float) 0);
		gtk_label_set_line_wrap (secondary_label, TRUE);
		gtk_box_pack_start ((GtkBox*) message_box, (GtkWidget*) secondary_label, TRUE, TRUE, (guint) 0);
		self->priv->progressbar = (_tmp1_ = g_object_ref_sink ((GtkProgressBar*) gtk_progress_bar_new ()), _g_object_unref0 (self->priv->progressbar), _tmp1_);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) self->priv->progressbar, FALSE, TRUE, (guint) 0);
		self->priv->status_label = (_tmp2_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (NULL)), _g_object_unref0 (self->priv->status_label), _tmp2_);
		gtk_misc_set_alignment ((GtkMisc*) self->priv->status_label, (float) 0, (float) 0);
		gtk_label_set_line_wrap (self->priv->status_label, TRUE);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) self->priv->status_label, FALSE, TRUE, (guint) 0);
		_g_object_unref0 (box);
		_g_object_unref0 (head_box);
		_g_object_unref0 (image);
		_g_object_unref0 (message_box);
		_g_object_unref0 (primary_label);
		_g_object_unref0 (secondary_label);
	}
	return obj;
}


static void gnome_scan_acquisition_widget_class_init (GnomeScanAcquisitionWidgetClass * klass) {
	gnome_scan_acquisition_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanAcquisitionWidgetPrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_acquisition_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_acquisition_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_acquisition_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_acquisition_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_ACQUISITION_WIDGET_JOB, g_param_spec_object ("job", "job", "job", GNOME_SCAN_TYPE_JOB, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_ACQUISITION_WIDGET_PRIMARY, g_param_spec_string ("primary", "primary", "primary", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_ACQUISITION_WIDGET_SECONDARY, g_param_spec_string ("secondary", "secondary", "secondary", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_ACQUISITION_WIDGET_ICON_NAME, g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void gnome_scan_acquisition_widget_instance_init (GnomeScanAcquisitionWidget * self) {
	self->priv = GNOME_SCAN_ACQUISITION_WIDGET_GET_PRIVATE (self);
}


static void gnome_scan_acquisition_widget_finalize (GObject* obj) {
	GnomeScanAcquisitionWidget * self;
	self = GNOME_SCAN_ACQUISITION_WIDGET (obj);
	_g_object_unref0 (self->priv->progressbar);
	_g_object_unref0 (self->priv->status_label);
	_g_object_unref0 (self->priv->_job);
	_g_free0 (self->priv->_primary);
	_g_free0 (self->priv->_secondary);
	_g_free0 (self->priv->_icon_name);
	G_OBJECT_CLASS (gnome_scan_acquisition_widget_parent_class)->finalize (obj);
}


GType gnome_scan_acquisition_widget_get_type (void) {
	static GType gnome_scan_acquisition_widget_type_id = 0;
	if (gnome_scan_acquisition_widget_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanAcquisitionWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_acquisition_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanAcquisitionWidget), 0, (GInstanceInitFunc) gnome_scan_acquisition_widget_instance_init, NULL };
		gnome_scan_acquisition_widget_type_id = g_type_register_static (GTK_TYPE_ALIGNMENT, "GnomeScanAcquisitionWidget", &g_define_type_info, 0);
	}
	return gnome_scan_acquisition_widget_type_id;
}


static void gnome_scan_acquisition_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanAcquisitionWidget * self;
	self = GNOME_SCAN_ACQUISITION_WIDGET (object);
	switch (property_id) {
		case GNOME_SCAN_ACQUISITION_WIDGET_JOB:
		g_value_set_object (value, gnome_scan_acquisition_widget_get_job (self));
		break;
		case GNOME_SCAN_ACQUISITION_WIDGET_PRIMARY:
		g_value_set_string (value, gnome_scan_acquisition_widget_get_primary (self));
		break;
		case GNOME_SCAN_ACQUISITION_WIDGET_SECONDARY:
		g_value_set_string (value, gnome_scan_acquisition_widget_get_secondary (self));
		break;
		case GNOME_SCAN_ACQUISITION_WIDGET_ICON_NAME:
		g_value_set_string (value, gnome_scan_acquisition_widget_get_icon_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_acquisition_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanAcquisitionWidget * self;
	self = GNOME_SCAN_ACQUISITION_WIDGET (object);
	switch (property_id) {
		case GNOME_SCAN_ACQUISITION_WIDGET_JOB:
		gnome_scan_acquisition_widget_set_job (self, g_value_get_object (value));
		break;
		case GNOME_SCAN_ACQUISITION_WIDGET_PRIMARY:
		gnome_scan_acquisition_widget_set_primary (self, g_value_get_string (value));
		break;
		case GNOME_SCAN_ACQUISITION_WIDGET_SECONDARY:
		gnome_scan_acquisition_widget_set_secondary (self, g_value_get_string (value));
		break;
		case GNOME_SCAN_ACQUISITION_WIDGET_ICON_NAME:
		gnome_scan_acquisition_widget_set_icon_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




