/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>


#define GNOME_SCAN_TYPE_OPTION_BOX (gnome_scan_option_box_get_type ())
#define GNOME_SCAN_OPTION_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_BOX, GnomeScanOptionBox))
#define GNOME_SCAN_OPTION_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_BOX, GnomeScanOptionBoxClass))
#define GNOME_SCAN_IS_OPTION_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_BOX))
#define GNOME_SCAN_IS_OPTION_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_BOX))
#define GNOME_SCAN_OPTION_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_BOX, GnomeScanOptionBoxClass))

typedef struct _GnomeScanOptionBox GnomeScanOptionBox;
typedef struct _GnomeScanOptionBoxClass GnomeScanOptionBoxClass;
typedef struct _GnomeScanOptionBoxPrivate GnomeScanOptionBoxPrivate;

#define GNOME_SCAN_TYPE_OPTION (gnome_scan_option_get_type ())
#define GNOME_SCAN_OPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOption))
#define GNOME_SCAN_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))
#define GNOME_SCAN_IS_OPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_IS_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_OPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))

typedef struct _GnomeScanOption GnomeScanOption;
typedef struct _GnomeScanOptionClass GnomeScanOptionClass;

#define GNOME_SCAN_TYPE_OPTION_WIDGET (gnome_scan_option_widget_get_type ())
#define GNOME_SCAN_OPTION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidget))
#define GNOME_SCAN_OPTION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetClass))
#define GNOME_SCAN_IS_OPTION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET))
#define GNOME_SCAN_IS_OPTION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_WIDGET))
#define GNOME_SCAN_OPTION_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetClass))

typedef struct _GnomeScanOptionWidget GnomeScanOptionWidget;
typedef struct _GnomeScanOptionWidgetClass GnomeScanOptionWidgetClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define GNOME_SCAN_TYPE_OPTION_MANAGER (gnome_scan_option_manager_get_type ())
#define GNOME_SCAN_OPTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_MANAGER, GnomeScanOptionManager))
#define GNOME_SCAN_OPTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_MANAGER, GnomeScanOptionManagerClass))
#define GNOME_SCAN_IS_OPTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_MANAGER))
#define GNOME_SCAN_IS_OPTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_MANAGER))
#define GNOME_SCAN_OPTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_MANAGER, GnomeScanOptionManagerClass))

typedef struct _GnomeScanOptionManager GnomeScanOptionManager;
typedef struct _GnomeScanOptionManagerClass GnomeScanOptionManagerClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _GnomeScanOptionBox {
	GtkVBox parent_instance;
	GnomeScanOptionBoxPrivate * priv;
};

struct _GnomeScanOptionBoxClass {
	GtkVBoxClass parent_class;
};

struct _GnomeScanOptionBoxPrivate {
	char* _label;
	gboolean _expand;
	GtkTable* table;
	gint child_count;
	gint child_visible_count;
	gint child_expanding_count;
	GHashTable* children;
	GHashTable* labels;
};


extern GnomeScanOptionManager* gnome_scan_option_manager;
static gpointer gnome_scan_option_box_parent_class = NULL;

GType gnome_scan_option_box_get_type (void);
GType gnome_scan_option_get_type (void);
GType gnome_scan_option_widget_get_type (void);
#define GNOME_SCAN_OPTION_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION_BOX, GnomeScanOptionBoxPrivate))
enum  {
	GNOME_SCAN_OPTION_BOX_DUMMY_PROPERTY,
	GNOME_SCAN_OPTION_BOX_LABEL,
	GNOME_SCAN_OPTION_BOX_EXPAND
};
void gnome_scan_option_box_set_label (GnomeScanOptionBox* self, const char* value);
GnomeScanOptionBox* gnome_scan_option_box_new (const char* label);
GnomeScanOptionBox* gnome_scan_option_box_construct (GType object_type, const char* label);
GType gnome_scan_option_manager_get_type (void);
GType gnome_scan_option_manager_get_widget_type_for (GnomeScanOptionManager* self, GnomeScanOption* option);
const char* gnome_scan_option_get_name (GnomeScanOption* self);
static void gnome_scan_option_box_on_option_widget_visibility_changed (GnomeScanOptionBox* self, GnomeScanOptionWidget* widget);
static void _gnome_scan_option_box_on_option_widget_visibility_changed_gtk_widget_hide (GnomeScanOptionWidget* _sender, gpointer self);
static void _gnome_scan_option_box_on_option_widget_visibility_changed_gtk_widget_show (GnomeScanOptionWidget* _sender, gpointer self);
gboolean gnome_scan_option_widget_get_expand (GnomeScanOptionWidget* self);
gboolean gnome_scan_option_widget_get_no_label (GnomeScanOptionWidget* self);
const char* gnome_scan_option_get_title (GnomeScanOption* self);
const char* gnome_scan_option_get_desc (GnomeScanOption* self);
gboolean gnome_scan_option_get_active (GnomeScanOption* self);
void gnome_scan_option_box_pack_option (GnomeScanOptionBox* self, GnomeScanOption* option);
gboolean gnome_scan_option_box_unpack_option (GnomeScanOptionBox* self, GnomeScanOption* option);
void gnome_scan_option_box_set_expand (GnomeScanOptionBox* self, gboolean value);
gboolean gnome_scan_option_box_get_expand (GnomeScanOptionBox* self);
const char* gnome_scan_option_box_get_label (GnomeScanOptionBox* self);
static GObject * gnome_scan_option_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gnome_scan_option_box_finalize (GObject* obj);
static void gnome_scan_option_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gnome_scan_option_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



GnomeScanOptionBox* gnome_scan_option_box_construct (GType object_type, const char* label) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanOptionBox * self;
	g_return_val_if_fail (label != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "label";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, label);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanOptionBox* gnome_scan_option_box_new (const char* label) {
	return gnome_scan_option_box_construct (GNOME_SCAN_TYPE_OPTION_BOX, label);
}


static void _gnome_scan_option_box_on_option_widget_visibility_changed_gtk_widget_hide (GnomeScanOptionWidget* _sender, gpointer self) {
	gnome_scan_option_box_on_option_widget_visibility_changed (self, _sender);
}


static void _gnome_scan_option_box_on_option_widget_visibility_changed_gtk_widget_show (GnomeScanOptionWidget* _sender, gpointer self) {
	gnome_scan_option_box_on_option_widget_visibility_changed (self, _sender);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void gnome_scan_option_box_pack_option (GnomeScanOptionBox* self, GnomeScanOption* option) {
	GType wtype;
	GnomeScanOptionWidget* widget;
	GtkAttachOptions opts;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	wtype = gnome_scan_option_manager_get_widget_type_for (gnome_scan_option_manager, option);
	if (!g_type_is_a (wtype, GTK_TYPE_WIDGET)) {
		g_warning ("gnome-scan-option-box.vala:63: No widget for option %s", gnome_scan_option_get_name (option));
		return;
	}
	widget = GNOME_SCAN_OPTION_WIDGET (g_object_ref_sink (gtk_widget_new (wtype, "option", option, NULL)));
	g_signal_connect_object ((GtkWidget*) widget, "hide", (GCallback) _gnome_scan_option_box_on_option_widget_visibility_changed_gtk_widget_hide, self, 0);
	g_signal_connect_object ((GtkWidget*) widget, "show", (GCallback) _gnome_scan_option_box_on_option_widget_visibility_changed_gtk_widget_show, self, 0);
	self->priv->child_count++;
	opts = GTK_FILL;
	if (gnome_scan_option_widget_get_expand (widget)) {
		opts = opts | GTK_EXPAND;
	}
	if (gnome_scan_option_widget_get_no_label (widget)) {
		gtk_table_attach (self->priv->table, (GtkWidget*) widget, (guint) 0, (guint) 2, (guint) (self->priv->child_count - 1), (guint) self->priv->child_count, opts, opts, (guint) 0, (guint) 0);
	} else {
		char* _tmp0_;
		GtkLabel* _tmp1_;
		GtkLabel* label;
		label = (_tmp1_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp0_ = g_strdup_printf (_ ("%s:"), gnome_scan_option_get_title (option)))), _g_free0 (_tmp0_), _tmp1_);
		gtk_widget_set_tooltip_text ((GtkWidget*) label, gnome_scan_option_get_desc (option));
		gtk_misc_set_alignment ((GtkMisc*) label, (float) 0, (float) 0.5);
		gtk_widget_set_no_show_all ((GtkWidget*) label, gtk_widget_get_no_show_all ((GtkWidget*) widget));
		g_hash_table_insert (self->priv->labels, _g_object_ref0 (widget), _g_object_ref0 (label));
		gtk_table_attach (self->priv->table, (GtkWidget*) label, (guint) 0, (guint) 1, (guint) (self->priv->child_count - 1), (guint) self->priv->child_count, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
		gtk_table_attach (self->priv->table, (GtkWidget*) widget, (guint) 1, (guint) 2, (guint) (self->priv->child_count - 1), (guint) self->priv->child_count, GTK_FILL | GTK_EXPAND, opts, (guint) 0, (guint) 0);
		_g_object_unref0 (label);
	}
	g_hash_table_insert (self->priv->children, _g_object_ref0 (option), _g_object_ref0 (widget));
	if (!gnome_scan_option_get_active (option)) {
		self->priv->child_visible_count++;
	}
	gnome_scan_option_box_on_option_widget_visibility_changed (self, widget);
	_g_object_unref0 (widget);
}


gboolean gnome_scan_option_box_unpack_option (GnomeScanOptionBox* self, GnomeScanOption* option) {
	gboolean result;
	GnomeScanOptionWidget* widget;
	GtkLabel* label;
	GList* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (option != NULL, FALSE);
	widget = (GnomeScanOptionWidget*) g_hash_table_lookup (self->priv->children, option);
	if (widget == NULL) {
		result = FALSE;
		return result;
	}
	gtk_widget_set_no_show_all ((GtkWidget*) widget, TRUE);
	gtk_widget_hide ((GtkWidget*) widget);
	label = (GtkLabel*) g_hash_table_lookup (self->priv->labels, widget);
	if (label != NULL) {
		gtk_container_remove ((GtkContainer*) self->priv->table, (GtkWidget*) label);
		g_hash_table_remove (self->priv->labels, widget);
	}
	gtk_container_remove ((GtkContainer*) self->priv->table, (GtkWidget*) widget);
	g_hash_table_remove (self->priv->children, option);
	result = (_tmp1_ = g_list_length (_tmp0_ = gtk_container_get_children ((GtkContainer*) self->priv->table)) == 0, _g_list_free0 (_tmp0_), _tmp1_);
	return result;
}


static void gnome_scan_option_box_on_option_widget_visibility_changed (GnomeScanOptionBox* self, GnomeScanOptionWidget* widget) {
	GtkLabel* label;
	gint _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	if (gtk_widget_get_no_show_all ((GtkWidget*) widget)) {
		return;
	}
	label = _g_object_ref0 ((GtkLabel*) g_hash_table_lookup (self->priv->labels, widget));
	if (label != NULL) {
		gboolean _tmp0_;
		gtk_widget_set_no_show_all ((GtkWidget*) label, gtk_widget_get_no_show_all ((GtkWidget*) widget));
		if ((g_object_get ((GtkWidget*) widget, "visible", &_tmp0_, NULL), _tmp0_)) {
			gtk_widget_show ((GtkWidget*) label);
		} else {
			gtk_widget_hide ((GtkWidget*) label);
		}
	}
	if (gnome_scan_option_widget_get_expand (widget)) {
		gint _tmp1_;
		gboolean _tmp2_;
		GtkContainer* parent;
		_tmp1_ = 0;
		if ((g_object_get ((GtkWidget*) widget, "visible", &_tmp2_, NULL), _tmp2_)) {
			_tmp1_ = +1;
		} else {
			_tmp1_ = -1;
		}
		self->priv->child_expanding_count = self->priv->child_expanding_count + _tmp1_;
		parent = _g_object_ref0 (GTK_CONTAINER (gtk_widget_get_parent ((GtkWidget*) self)));
		gnome_scan_option_box_set_expand (self, self->priv->child_expanding_count > 0);
		gtk_container_child_set (parent, (GtkWidget*) self, "expand", self->priv->_expand, NULL);
		_g_object_unref0 (parent);
	}
	_tmp3_ = 0;
	if ((g_object_get ((GtkWidget*) widget, "visible", &_tmp4_, NULL), _tmp4_)) {
		_tmp3_ = +1;
	} else {
		_tmp3_ = -1;
	}
	self->priv->child_visible_count = self->priv->child_visible_count + _tmp3_;
	if (self->priv->child_visible_count == 0) {
		gtk_widget_set_no_show_all ((GtkWidget*) self, TRUE);
		gtk_widget_hide ((GtkWidget*) self);
	} else {
		gtk_widget_set_no_show_all ((GtkWidget*) self, FALSE);
		gtk_widget_show_all ((GtkWidget*) self);
	}
	_g_object_unref0 (label);
}


const char* gnome_scan_option_box_get_label (GnomeScanOptionBox* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_label;
	return result;
}


void gnome_scan_option_box_set_label (GnomeScanOptionBox* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_label = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_label), _tmp0_);
	g_object_notify ((GObject *) self, "label");
}


gboolean gnome_scan_option_box_get_expand (GnomeScanOptionBox* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_expand;
	return result;
}


void gnome_scan_option_box_set_expand (GnomeScanOptionBox* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_expand = value;
	g_object_notify ((GObject *) self, "expand");
}


static GObject * gnome_scan_option_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanOptionBoxClass * klass;
	GObjectClass * parent_class;
	GnomeScanOptionBox * self;
	klass = GNOME_SCAN_OPTION_BOX_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_OPTION_BOX));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_OPTION_BOX (obj);
	{
		GtkLabel* label;
		char* _tmp0_;
		GtkAlignment* alignment;
		GtkTable* _tmp1_;
		GHashTable* _tmp2_;
		GHashTable* _tmp3_;
		gtk_box_set_spacing ((GtkBox*) self, 6);
		gtk_widget_set_no_show_all ((GtkWidget*) self, TRUE);
		label = g_object_ref_sink ((GtkLabel*) gtk_label_new (NULL));
		gtk_label_set_markup (label, _tmp0_ = g_strdup_printf ("<b>%s</b>", self->priv->_label));
		_g_free0 (_tmp0_);
		gtk_misc_set_alignment ((GtkMisc*) label, (float) 0, (float) 0.5);
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
		alignment = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new ((float) 0, (float) 0, (float) 1, (float) 1));
		gtk_alignment_set_padding (alignment, (guint) 0, (guint) 0, (guint) 24, (guint) 0);
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) alignment, TRUE, TRUE, (guint) 0);
		self->priv->table = (_tmp1_ = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) 0, (guint) 2, FALSE)), _g_object_unref0 (self->priv->table), _tmp1_);
		gtk_container_add ((GtkContainer*) alignment, (GtkWidget*) self->priv->table);
		self->priv->children = (_tmp2_ = g_hash_table_new (g_direct_hash, g_direct_equal), _g_hash_table_unref0 (self->priv->children), _tmp2_);
		self->priv->labels = (_tmp3_ = g_hash_table_new (g_direct_hash, g_direct_equal), _g_hash_table_unref0 (self->priv->labels), _tmp3_);
		_g_object_unref0 (label);
		_g_object_unref0 (alignment);
	}
	return obj;
}


static void gnome_scan_option_box_class_init (GnomeScanOptionBoxClass * klass) {
	gnome_scan_option_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionBoxPrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_option_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_option_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_option_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_BOX_LABEL, g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_BOX_EXPAND, g_param_spec_boolean ("expand", "expand", "expand", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gnome_scan_option_box_instance_init (GnomeScanOptionBox * self) {
	self->priv = GNOME_SCAN_OPTION_BOX_GET_PRIVATE (self);
	self->priv->_expand = FALSE;
	self->priv->child_count = 0;
	self->priv->child_visible_count = 0;
	self->priv->child_expanding_count = 0;
}


static void gnome_scan_option_box_finalize (GObject* obj) {
	GnomeScanOptionBox * self;
	self = GNOME_SCAN_OPTION_BOX (obj);
	_g_free0 (self->priv->_label);
	_g_object_unref0 (self->priv->table);
	_g_hash_table_unref0 (self->priv->children);
	_g_hash_table_unref0 (self->priv->labels);
	G_OBJECT_CLASS (gnome_scan_option_box_parent_class)->finalize (obj);
}


GType gnome_scan_option_box_get_type (void) {
	static GType gnome_scan_option_box_type_id = 0;
	if (gnome_scan_option_box_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionBox), 0, (GInstanceInitFunc) gnome_scan_option_box_instance_init, NULL };
		gnome_scan_option_box_type_id = g_type_register_static (GTK_TYPE_VBOX, "GnomeScanOptionBox", &g_define_type_info, 0);
	}
	return gnome_scan_option_box_type_id;
}


static void gnome_scan_option_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanOptionBox * self;
	self = GNOME_SCAN_OPTION_BOX (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_BOX_LABEL:
		g_value_set_string (value, gnome_scan_option_box_get_label (self));
		break;
		case GNOME_SCAN_OPTION_BOX_EXPAND:
		g_value_set_boolean (value, gnome_scan_option_box_get_expand (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanOptionBox * self;
	self = GNOME_SCAN_OPTION_BOX (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_BOX_LABEL:
		gnome_scan_option_box_set_label (self, g_value_get_string (value));
		break;
		case GNOME_SCAN_OPTION_BOX_EXPAND:
		gnome_scan_option_box_set_expand (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




