#ifndef GAME_H
#define GAME_H

#include <gnome.h>

/* Number of blocks that fit on the screen horizontally*/
#define BLOCKS_WIDTH 20
/* Number of blocks fit on the screen vertically */
#define BLOCKS_HEIGHT 20

/* Number of milliseconds between each tic in-game */
#define BULLET_TIC_INTERVAL 40
/*#define BULLET_TIC_INTERVAL 4*/

/* Number of milliseconds between each tic in-game */
#define BULLET_TIC_INTERVAL_FAST 2
/* Number of times a bullet moves for each ship movement */
#define BULLET_TICS_PER_SHIP_TIC 3

/* Number of milliseconds between each tic */
#define TITLE_TIC_INTERVAL 5000

/* Max number of blocks a building will be reduced by by a bullet */
#define MAX_HEIGHT_REDUCTION 2

/* Various possible statuses we can be in */
#define STATUS_IN_GAME 1
#define STATUS_DIED 2
#define STATUS_LEVEL_COMPLETE 3
#define STATUS_TITLE_SCREEN 4
#define STATUS_HISCORE_SCREEN 5
#define STATUS_INSTRUCTIONS_SCREEN 6
#define STATUS_PAUSED 7 

// ----

gint no_bullet_tics;                /* Counts how many bullet tics we've had
                                       without a ship tic */
gint ship_x;                        /* The ship x position */
gint ship_y;                        /* The ship y position */
gint bullet_x;                      /* The bullet x position */
gint bullet_y;                      /* The bullet y position */
gint bullet_exists;                 /* Does the bullet exist? */

gint building_heights[BLOCKS_WIDTH];/* The heights of the buildings */

gint status;         /* Are we currently playing, in titles, etc? */

gint current_score;					/* The player's score */

gint level;		/* What level we are on. */

guint bullet_timeout;	/* The timeout */
guint titles_timeout;	/* handler ids */

gboolean redraw_pausing;

// ----

void game_setup();

/* Handle menu events */
void game_pause_event();
void game_restart_event();
void game_end_event();

/* The user has pressed a key in a given state */
gboolean game_key_press();
gboolean game_inlevel_key_press();
gboolean game_died_key_press();
gboolean game_level_complete_key_press();
gboolean game_titles_key_press();

/* Reset for game and set the bullet timer going */
void game_restart();

/* Get the titles timer going */
void game_restart_titles();

/* Called on exit */
void game_quit();

/* ---------------------------- */

/* Change the status message */
void _set_status_message( gchar* format, ... );

/* Set up a new level */
void _level_setup();

/* Called every time the bullet must move */
gint _bullet_tic( gpointer data );

/* Called every time the titles change */
gint _titles_tic( gpointer data );

/* Called every time the ship must move */
gint _ship_tic();

/* Write the score in the status bar of the app */
void _update_score();

/* We've finished this level */
void _level_complete();

/* We've died */
void _level_failed();

void _restart_titles_on_screen( int the_status );

/* Have all the buildings been destroyed? */
gboolean _all_buildings_gone();

#endif


