#! /usr/bin/ruby

#==============================================================================#
# $Id: bar1.rb,v 1.10 2004/01/23 04:36:30 yuya Exp $
# $Source: /cvsroot/gruby/gruby/example/chart/bar1.rb,v $
#==============================================================================#

require 'grb/chart/bar/facade'

#==============================================================================#

data = [
  {
    :name  => 'Field 1',
    :line  => GRb::Color.purple(128),
    :fill  => GRb::Color.purple(192),
    :value => [20, 40, 50, 80, 15],
  },
  {
    :name  => 'Field 2',
    :line  => GRb::Color.yellow(128),
    :fill  => GRb::Color.yellow(192),
    :value => [15, 25, 45, 90, 45],
  },
  {
    :name  => 'Field 3',
    :line  => GRb::Color.skyblue(128),
    :fill  => GRb::Color.skyblue(192),
    :value => [-10, 5, 25, 70, 65],
  },
]

#==============================================================================#

facade = GRb::Chart::BarChartFacade.create(500, 400)
facade.title.text                    = 'Bar Chart Sample 1'
facade.chart.scale1.maximum          = 100
facade.chart.scale1.minimum          = -20
facade.chart.scale1.interval.major   = 20
facade.chart.scale1.interval.minor   = 5
facade.chart.scale1.label.format     = Proc.new { |value| '%i%%' % value }
facade.chart.axis.grid.minor.visible = false
facade.chart.axis.tics.minor.visible = false
facade.chart.axis.label.text         = ['2003/11', '2003/12', '2004/01', '2004/02', '2004/03']
facade.chart.bar_width               = 15
facade.chart.bar_spacing             = 5
facade.chart.column_spacing          = 10
facade.data                          = data
facade.write_png_file(__FILE__.sub(/\.rb/, '.png'))

#==============================================================================#
#==============================================================================#
