
#==============================================================================#
# $Id: star.rb,v 1.2 2004/01/23 23:02:00 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/marker/star.rb,v $
#==============================================================================#

require 'grb/chart/base/marker/base'
require 'grb/math_ex'

#==============================================================================#

module GRb

  module Chart

    class StarMarker < MarkerBase

      def point(poly, x, y, deg, size)
        xx = x + MathEx.sin(180 - deg) * size
        yy = y + MathEx.cos(180 - deg) * size
        poly.add(xx, yy)
      end

      def drawing(image, x, y, color)
        full = @size
        half = @size / 2.5

        poly = Polygon.new
        point(poly, x, y,   0, full)
        point(poly, x, y,  36, half)
        point(poly, x, y,  72, full)
        point(poly, x, y, 108, half)
        point(poly, x, y, 144, full)
        point(poly, x, y, 180, half)
        point(poly, x, y, 216, full)
        point(poly, x, y, 252, half)
        point(poly, x, y, 288, full)
        point(poly, x, y, 324, half)
        image.polygon(poly, color)
      end

    end # StarMarker

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
