
#==============================================================================#
# $Id: scale_tics.rb,v 1.2 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/xy_base/decorator/scale_tics.rb,v $
#==============================================================================#

require 'grb/chart/base/decorator/no_child_base'

#==============================================================================#

module GRb

  module Chart

    class ScaleTicsDecorator < NoChildDecoratorBase

      def initialize
        @scale   = nil
        @size    = nil
        @color   = nil
        @inside  = nil
        @outside = nil
      end

      attr_accessor :scale, :size, :color, :inside, :outside

      def draw(image, box)
        interval = @scale.interval
        raito    = @scale.raito(box.dy - 1)
        origin   = @scale.delta + @scale.minimum

        if @scale.maximum > 0
          base   = [@scale.minimum, 0].max
          delta  = @scale.maximum - base
          number = (delta.to_f / interval.to_f).floor + 1
          number.times { |i|
            y = box.y + (origin - base - interval * i) * raito
            draw_tics(image, box, y, @color)
          }
        end

        if @scale.minimum < 0
          base   = [@scale.maximum, 0].min
          delta  = (@scale.minimum - base).abs
          number = (delta.to_f / interval.to_f).floor + 1
          number.times { |i|
            y = box.y + (origin - base + interval * i) * raito
            draw_tics(image, box, y, @color)
          }
        end

        image.line(box.x, box.y, box.x, box.y2, color)
      end

      def draw_tics(image, box, y, color)
        image.line(box.x, y, box.x + @size, y, color) if @inside
        image.line(box.x, y, box.x - @size, y, color) if @outside
      end

    end # ScaleTicsDecorator

  end # Chart

end # GRb

#==============================================================================#

if $0 == __FILE__
  require 'grb/image'
  require 'grb/chart/scale'

  GRb::Image.create_and_write_png_file(200, 200, false, __FILE__.sub(/\.rb/, '.png')) { |image|
    GRb::Chart::Decorator::ScaleTics.new.instance_eval {
      self.scale   = GRb::Chart::Scale.new(100, -20, 10)
      self.size    = 5
      self.color   = GRb::Color.red(128)
      self.inside  = true
      self.outside = true
      self.draw(image, GRb::Chart::Box.new(10, 10, 180, 180))
    }
  }
end

#==============================================================================#
#==============================================================================#
