/* drawing-panel.c generated by valac 0.14.0, the Vala compiler
 * generated from drawing-panel.vala, do not modify */

/*
 * Copyright (C) 2011  Daiki Ueno
 * Copyright (C) 2011  Red Hat, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <string.h>
#include <ibus.h>
#include <gobject/gvaluecollector.h>


#define IBUS_DRAWING_TYPE_POINT (ibus_drawing_point_get_type ())
#define IBUS_DRAWING_POINT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_DRAWING_TYPE_POINT, IBusDrawingPoint))
#define IBUS_DRAWING_POINT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_DRAWING_TYPE_POINT, IBusDrawingPointClass))
#define IBUS_DRAWING_IS_POINT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_DRAWING_TYPE_POINT))
#define IBUS_DRAWING_IS_POINT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_DRAWING_TYPE_POINT))
#define IBUS_DRAWING_POINT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_DRAWING_TYPE_POINT, IBusDrawingPointClass))

typedef struct _IBusDrawingPoint IBusDrawingPoint;
typedef struct _IBusDrawingPointClass IBusDrawingPointClass;
typedef struct _IBusDrawingPointPrivate IBusDrawingPointPrivate;
typedef struct _IBusDrawingParamSpecPoint IBusDrawingParamSpecPoint;

#define IBUS_DRAWING_TYPE_PATH (ibus_drawing_path_get_type ())
#define IBUS_DRAWING_PATH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_DRAWING_TYPE_PATH, IBusDrawingPath))
#define IBUS_DRAWING_PATH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_DRAWING_TYPE_PATH, IBusDrawingPathClass))
#define IBUS_DRAWING_IS_PATH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_DRAWING_TYPE_PATH))
#define IBUS_DRAWING_IS_PATH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_DRAWING_TYPE_PATH))
#define IBUS_DRAWING_PATH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_DRAWING_TYPE_PATH, IBusDrawingPathClass))

typedef struct _IBusDrawingPath IBusDrawingPath;
typedef struct _IBusDrawingPathClass IBusDrawingPathClass;
typedef struct _IBusDrawingPathPrivate IBusDrawingPathPrivate;
#define __g_list_free__ibus_drawing_point_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__ibus_drawing_point_unref0_ (var), NULL)))
typedef struct _IBusDrawingParamSpecPath IBusDrawingParamSpecPath;

#define IBUS_DRAWING_TYPE_DRAWING_AREA (ibus_drawing_drawing_area_get_type ())
#define IBUS_DRAWING_DRAWING_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_DRAWING_TYPE_DRAWING_AREA, IBusDrawingDrawingArea))
#define IBUS_DRAWING_DRAWING_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_DRAWING_TYPE_DRAWING_AREA, IBusDrawingDrawingAreaClass))
#define IBUS_DRAWING_IS_DRAWING_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_DRAWING_TYPE_DRAWING_AREA))
#define IBUS_DRAWING_IS_DRAWING_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_DRAWING_TYPE_DRAWING_AREA))
#define IBUS_DRAWING_DRAWING_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_DRAWING_TYPE_DRAWING_AREA, IBusDrawingDrawingAreaClass))

typedef struct _IBusDrawingDrawingArea IBusDrawingDrawingArea;
typedef struct _IBusDrawingDrawingAreaClass IBusDrawingDrawingAreaClass;
typedef struct _IBusDrawingDrawingAreaPrivate IBusDrawingDrawingAreaPrivate;
#define __g_list_free__ibus_drawing_path_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__ibus_drawing_path_unref0_ (var), NULL)))
#define _ibus_drawing_path_unref0(var) ((var == NULL) ? NULL : (var = (ibus_drawing_path_unref (var), NULL)))
#define _ibus_drawing_point_unref0(var) ((var == NULL) ? NULL : (var = (ibus_drawing_point_unref (var), NULL)))

#define IBUS_DRAWING_TYPE_DRAWING_PANEL (ibus_drawing_drawing_panel_get_type ())
#define IBUS_DRAWING_DRAWING_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_DRAWING_TYPE_DRAWING_PANEL, IBusDrawingDrawingPanel))
#define IBUS_DRAWING_DRAWING_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_DRAWING_TYPE_DRAWING_PANEL, IBusDrawingDrawingPanelClass))
#define IBUS_DRAWING_IS_DRAWING_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_DRAWING_TYPE_DRAWING_PANEL))
#define IBUS_DRAWING_IS_DRAWING_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_DRAWING_TYPE_DRAWING_PANEL))
#define IBUS_DRAWING_DRAWING_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_DRAWING_TYPE_DRAWING_PANEL, IBusDrawingDrawingPanelClass))

typedef struct _IBusDrawingDrawingPanel IBusDrawingDrawingPanel;
typedef struct _IBusDrawingDrawingPanelClass IBusDrawingDrawingPanelClass;
typedef struct _IBusDrawingDrawingPanelPrivate IBusDrawingDrawingPanelPrivate;
typedef struct _Block1Data Block1Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _IBusDrawingPoint {
	GTypeInstance parent_instance;
	volatile int ref_count;
	IBusDrawingPointPrivate * priv;
	gdouble x;
	gdouble y;
};

struct _IBusDrawingPointClass {
	GTypeClass parent_class;
	void (*finalize) (IBusDrawingPoint *self);
};

struct _IBusDrawingParamSpecPoint {
	GParamSpec parent_instance;
};

struct _IBusDrawingPath {
	GTypeInstance parent_instance;
	volatile int ref_count;
	IBusDrawingPathPrivate * priv;
	GList* points;
};

struct _IBusDrawingPathClass {
	GTypeClass parent_class;
	void (*finalize) (IBusDrawingPath *self);
};

struct _IBusDrawingParamSpecPath {
	GParamSpec parent_instance;
};

struct _IBusDrawingDrawingArea {
	GtkDrawingArea parent_instance;
	IBusDrawingDrawingAreaPrivate * priv;
};

struct _IBusDrawingDrawingAreaClass {
	GtkDrawingAreaClass parent_class;
};

struct _IBusDrawingDrawingAreaPrivate {
	GList* paths;
	IBusDrawingPath* current_path;
};

struct _IBusDrawingDrawingPanel {
	GtkBox parent_instance;
	IBusDrawingDrawingPanelPrivate * priv;
};

struct _IBusDrawingDrawingPanelClass {
	GtkBoxClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	IBusDrawingDrawingPanel * self;
	IBusDrawingDrawingArea* area;
};


static gpointer ibus_drawing_point_parent_class = NULL;
static gpointer ibus_drawing_path_parent_class = NULL;
static gpointer ibus_drawing_drawing_area_parent_class = NULL;
static gpointer ibus_drawing_drawing_panel_parent_class = NULL;

gpointer ibus_drawing_point_ref (gpointer instance);
void ibus_drawing_point_unref (gpointer instance);
GParamSpec* ibus_drawing_param_spec_point (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void ibus_drawing_value_set_point (GValue* value, gpointer v_object);
void ibus_drawing_value_take_point (GValue* value, gpointer v_object);
gpointer ibus_drawing_value_get_point (const GValue* value);
GType ibus_drawing_point_get_type (void) G_GNUC_CONST;
enum  {
	IBUS_DRAWING_POINT_DUMMY_PROPERTY
};
IBusDrawingPoint* ibus_drawing_point_new (gdouble x, gdouble y);
IBusDrawingPoint* ibus_drawing_point_construct (GType object_type, gdouble x, gdouble y);
static void ibus_drawing_point_finalize (IBusDrawingPoint* obj);
gpointer ibus_drawing_path_ref (gpointer instance);
void ibus_drawing_path_unref (gpointer instance);
GParamSpec* ibus_drawing_param_spec_path (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void ibus_drawing_value_set_path (GValue* value, gpointer v_object);
void ibus_drawing_value_take_path (GValue* value, gpointer v_object);
gpointer ibus_drawing_value_get_path (const GValue* value);
GType ibus_drawing_path_get_type (void) G_GNUC_CONST;
enum  {
	IBUS_DRAWING_PATH_DUMMY_PROPERTY
};
static void _ibus_drawing_point_unref0_ (gpointer var);
static void _g_list_free__ibus_drawing_point_unref0_ (GList* self);
IBusDrawingPath* ibus_drawing_path_new (void);
IBusDrawingPath* ibus_drawing_path_construct (GType object_type);
static void ibus_drawing_path_finalize (IBusDrawingPath* obj);
GType ibus_drawing_drawing_area_get_type (void) G_GNUC_CONST;
#define IBUS_DRAWING_DRAWING_AREA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), IBUS_DRAWING_TYPE_DRAWING_AREA, IBusDrawingDrawingAreaPrivate))
enum  {
	IBUS_DRAWING_DRAWING_AREA_DUMMY_PROPERTY
};
static void _ibus_drawing_path_unref0_ (gpointer var);
static void _g_list_free__ibus_drawing_path_unref0_ (GList* self);
IBusDrawingDrawingArea* ibus_drawing_drawing_area_new (void);
IBusDrawingDrawingArea* ibus_drawing_drawing_area_construct (GType object_type);
static gboolean ibus_drawing_drawing_area_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static gboolean ibus_drawing_drawing_area_real_button_release_event (GtkWidget* base, GdkEventButton* event);
static gboolean ibus_drawing_drawing_area_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event);
static gboolean ibus_drawing_drawing_area_real_draw (GtkWidget* base, cairo_t* cr);
void ibus_drawing_drawing_area_clear (IBusDrawingDrawingArea* self);
void ibus_drawing_drawing_area_undo (IBusDrawingDrawingArea* self);
static void g_cclosure_user_marshal_VOID__POINTER_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void ibus_drawing_drawing_area_finalize (GObject* obj);
GType ibus_drawing_drawing_panel_get_type (void) G_GNUC_CONST;
enum  {
	IBUS_DRAWING_DRAWING_PANEL_DUMMY_PROPERTY
};
IBusDrawingDrawingPanel* ibus_drawing_drawing_panel_new (IBusConfig* config);
IBusDrawingDrawingPanel* ibus_drawing_drawing_panel_construct (GType object_type, IBusConfig* config);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void __lambda0_ (Block1Data* _data1_);
static void ___lambda0__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda1_ (Block1Data* _data1_);
static void ___lambda1__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda2_ (IBusDrawingDrawingPanel* self, gdouble* coordinates, int coordinates_length1);
static void ___lambda2__ibus_drawing_drawing_area_stroke_added (IBusDrawingDrawingArea* _sender, gdouble* coordinates, int coordinates_length1, gpointer self);
static void __lambda3_ (IBusDrawingDrawingPanel* self, guint n_strokes);
static void ___lambda3__ibus_drawing_drawing_area_stroke_removed (IBusDrawingDrawingArea* _sender, guint n_strokes, gpointer self);


IBusDrawingPoint* ibus_drawing_point_construct (GType object_type, gdouble x, gdouble y) {
	IBusDrawingPoint* self = NULL;
	gdouble _tmp0_;
	gdouble _tmp1_;
	self = (IBusDrawingPoint*) g_type_create_instance (object_type);
	_tmp0_ = x;
	self->x = _tmp0_;
	_tmp1_ = y;
	self->y = _tmp1_;
	return self;
}


IBusDrawingPoint* ibus_drawing_point_new (gdouble x, gdouble y) {
	return ibus_drawing_point_construct (IBUS_DRAWING_TYPE_POINT, x, y);
}


static void ibus_drawing_value_point_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void ibus_drawing_value_point_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		ibus_drawing_point_unref (value->data[0].v_pointer);
	}
}


static void ibus_drawing_value_point_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ibus_drawing_point_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer ibus_drawing_value_point_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* ibus_drawing_value_point_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		IBusDrawingPoint* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ibus_drawing_point_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* ibus_drawing_value_point_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	IBusDrawingPoint** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ibus_drawing_point_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* ibus_drawing_param_spec_point (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	IBusDrawingParamSpecPoint* spec;
	g_return_val_if_fail (g_type_is_a (object_type, IBUS_DRAWING_TYPE_POINT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer ibus_drawing_value_get_point (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IBUS_DRAWING_TYPE_POINT), NULL);
	return value->data[0].v_pointer;
}


void ibus_drawing_value_set_point (GValue* value, gpointer v_object) {
	IBusDrawingPoint* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IBUS_DRAWING_TYPE_POINT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, IBUS_DRAWING_TYPE_POINT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ibus_drawing_point_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ibus_drawing_point_unref (old);
	}
}


void ibus_drawing_value_take_point (GValue* value, gpointer v_object) {
	IBusDrawingPoint* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IBUS_DRAWING_TYPE_POINT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, IBUS_DRAWING_TYPE_POINT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ibus_drawing_point_unref (old);
	}
}


static void ibus_drawing_point_class_init (IBusDrawingPointClass * klass) {
	ibus_drawing_point_parent_class = g_type_class_peek_parent (klass);
	IBUS_DRAWING_POINT_CLASS (klass)->finalize = ibus_drawing_point_finalize;
}


static void ibus_drawing_point_instance_init (IBusDrawingPoint * self) {
	self->ref_count = 1;
}


static void ibus_drawing_point_finalize (IBusDrawingPoint* obj) {
	IBusDrawingPoint * self;
	self = IBUS_DRAWING_POINT (obj);
}


GType ibus_drawing_point_get_type (void) {
	static volatile gsize ibus_drawing_point_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_drawing_point_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { ibus_drawing_value_point_init, ibus_drawing_value_point_free_value, ibus_drawing_value_point_copy_value, ibus_drawing_value_point_peek_pointer, "p", ibus_drawing_value_point_collect_value, "p", ibus_drawing_value_point_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (IBusDrawingPointClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ibus_drawing_point_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IBusDrawingPoint), 0, (GInstanceInitFunc) ibus_drawing_point_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType ibus_drawing_point_type_id;
		ibus_drawing_point_type_id = g_type_register_fundamental (g_type_fundamental_next (), "IBusDrawingPoint", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&ibus_drawing_point_type_id__volatile, ibus_drawing_point_type_id);
	}
	return ibus_drawing_point_type_id__volatile;
}


gpointer ibus_drawing_point_ref (gpointer instance) {
	IBusDrawingPoint* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void ibus_drawing_point_unref (gpointer instance) {
	IBusDrawingPoint* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		IBUS_DRAWING_POINT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _ibus_drawing_point_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (ibus_drawing_point_unref (var), NULL));
}


static void _g_list_free__ibus_drawing_point_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _ibus_drawing_point_unref0_, NULL);
	g_list_free (self);
}


IBusDrawingPath* ibus_drawing_path_construct (GType object_type) {
	IBusDrawingPath* self = NULL;
	self = (IBusDrawingPath*) g_type_create_instance (object_type);
	return self;
}


IBusDrawingPath* ibus_drawing_path_new (void) {
	return ibus_drawing_path_construct (IBUS_DRAWING_TYPE_PATH);
}


static void ibus_drawing_value_path_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void ibus_drawing_value_path_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		ibus_drawing_path_unref (value->data[0].v_pointer);
	}
}


static void ibus_drawing_value_path_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ibus_drawing_path_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer ibus_drawing_value_path_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* ibus_drawing_value_path_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		IBusDrawingPath* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ibus_drawing_path_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* ibus_drawing_value_path_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	IBusDrawingPath** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ibus_drawing_path_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* ibus_drawing_param_spec_path (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	IBusDrawingParamSpecPath* spec;
	g_return_val_if_fail (g_type_is_a (object_type, IBUS_DRAWING_TYPE_PATH), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer ibus_drawing_value_get_path (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IBUS_DRAWING_TYPE_PATH), NULL);
	return value->data[0].v_pointer;
}


void ibus_drawing_value_set_path (GValue* value, gpointer v_object) {
	IBusDrawingPath* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IBUS_DRAWING_TYPE_PATH));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, IBUS_DRAWING_TYPE_PATH));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ibus_drawing_path_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ibus_drawing_path_unref (old);
	}
}


void ibus_drawing_value_take_path (GValue* value, gpointer v_object) {
	IBusDrawingPath* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IBUS_DRAWING_TYPE_PATH));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, IBUS_DRAWING_TYPE_PATH));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ibus_drawing_path_unref (old);
	}
}


static void ibus_drawing_path_class_init (IBusDrawingPathClass * klass) {
	ibus_drawing_path_parent_class = g_type_class_peek_parent (klass);
	IBUS_DRAWING_PATH_CLASS (klass)->finalize = ibus_drawing_path_finalize;
}


static void ibus_drawing_path_instance_init (IBusDrawingPath * self) {
	self->points = NULL;
	self->ref_count = 1;
}


static void ibus_drawing_path_finalize (IBusDrawingPath* obj) {
	IBusDrawingPath * self;
	self = IBUS_DRAWING_PATH (obj);
	__g_list_free__ibus_drawing_point_unref0_0 (self->points);
}


GType ibus_drawing_path_get_type (void) {
	static volatile gsize ibus_drawing_path_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_drawing_path_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { ibus_drawing_value_path_init, ibus_drawing_value_path_free_value, ibus_drawing_value_path_copy_value, ibus_drawing_value_path_peek_pointer, "p", ibus_drawing_value_path_collect_value, "p", ibus_drawing_value_path_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (IBusDrawingPathClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ibus_drawing_path_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IBusDrawingPath), 0, (GInstanceInitFunc) ibus_drawing_path_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType ibus_drawing_path_type_id;
		ibus_drawing_path_type_id = g_type_register_fundamental (g_type_fundamental_next (), "IBusDrawingPath", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&ibus_drawing_path_type_id__volatile, ibus_drawing_path_type_id);
	}
	return ibus_drawing_path_type_id__volatile;
}


gpointer ibus_drawing_path_ref (gpointer instance) {
	IBusDrawingPath* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void ibus_drawing_path_unref (gpointer instance) {
	IBusDrawingPath* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		IBUS_DRAWING_PATH_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _ibus_drawing_path_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (ibus_drawing_path_unref (var), NULL));
}


static void _g_list_free__ibus_drawing_path_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _ibus_drawing_path_unref0_, NULL);
	g_list_free (self);
}


IBusDrawingDrawingArea* ibus_drawing_drawing_area_construct (GType object_type) {
	IBusDrawingDrawingArea * self = NULL;
	self = (IBusDrawingDrawingArea*) g_object_new (object_type, NULL);
	gtk_widget_add_events ((GtkWidget*) self, (gint) ((GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK) | GDK_BUTTON_MOTION_MASK));
	return self;
}


IBusDrawingDrawingArea* ibus_drawing_drawing_area_new (void) {
	return ibus_drawing_drawing_area_construct (IBUS_DRAWING_TYPE_DRAWING_AREA);
}


static gpointer _ibus_drawing_path_ref0 (gpointer self) {
	return self ? ibus_drawing_path_ref (self) : NULL;
}


static gboolean ibus_drawing_drawing_area_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	IBusDrawingDrawingArea * self;
	gboolean result = FALSE;
	IBusDrawingPath* _tmp0_;
	IBusDrawingPath* _tmp1_;
	GdkEventButton _tmp2_;
	gdouble _tmp3_;
	GdkEventButton _tmp4_;
	gdouble _tmp5_;
	IBusDrawingPoint* _tmp6_;
	IBusDrawingPath* _tmp7_;
	IBusDrawingPath* _tmp8_;
	self = (IBusDrawingDrawingArea*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = ibus_drawing_path_new ();
	_ibus_drawing_path_unref0 (self->priv->current_path);
	self->priv->current_path = _tmp0_;
	_tmp1_ = self->priv->current_path;
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.x;
	_tmp4_ = *event;
	_tmp5_ = _tmp4_.y;
	_tmp6_ = ibus_drawing_point_new (_tmp3_, _tmp5_);
	_tmp1_->points = g_list_append (_tmp1_->points, _tmp6_);
	_tmp7_ = self->priv->current_path;
	_tmp8_ = _ibus_drawing_path_ref0 (_tmp7_);
	self->priv->paths = g_list_append (self->priv->paths, _tmp8_);
	result = FALSE;
	return result;
}


static gpointer _ibus_drawing_point_ref0 (gpointer self) {
	return self ? ibus_drawing_point_ref (self) : NULL;
}


static gboolean ibus_drawing_drawing_area_real_button_release_event (GtkWidget* base, GdkEventButton* event) {
	IBusDrawingDrawingArea * self;
	gboolean result = FALSE;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	IBusDrawingPath* _tmp1_;
	GList* _tmp2_;
	guint _tmp3_ = 0U;
	gdouble* _tmp4_ = NULL;
	gdouble* coordinates;
	gint coordinates_length1;
	gint _coordinates_size_;
	gint i;
	IBusDrawingPath* _tmp5_;
	GList* _tmp6_;
	gdouble* _tmp22_;
	gint _tmp22__length1;
	self = (IBusDrawingDrawingArea*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	allocation = _tmp0_;
	_tmp1_ = self->priv->current_path;
	_tmp2_ = _tmp1_->points;
	_tmp3_ = g_list_length (_tmp2_);
	_tmp4_ = g_new0 (gdouble, _tmp3_ * 2);
	coordinates = _tmp4_;
	coordinates_length1 = _tmp3_ * 2;
	_coordinates_size_ = coordinates_length1;
	i = 0;
	_tmp5_ = self->priv->current_path;
	_tmp6_ = _tmp5_->points;
	{
		GList* point_collection = NULL;
		GList* point_it = NULL;
		point_collection = _tmp6_;
		for (point_it = point_collection; point_it != NULL; point_it = point_it->next) {
			IBusDrawingPoint* _tmp7_;
			IBusDrawingPoint* point = NULL;
			_tmp7_ = _ibus_drawing_point_ref0 ((IBusDrawingPoint*) point_it->data);
			point = _tmp7_;
			{
				gdouble* _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				IBusDrawingPoint* _tmp10_;
				gdouble _tmp11_;
				GtkAllocation _tmp12_;
				gint _tmp13_;
				gdouble _tmp14_;
				gdouble* _tmp15_;
				gint _tmp15__length1;
				gint _tmp16_;
				IBusDrawingPoint* _tmp17_;
				gdouble _tmp18_;
				GtkAllocation _tmp19_;
				gint _tmp20_;
				gdouble _tmp21_;
				_tmp8_ = coordinates;
				_tmp8__length1 = coordinates_length1;
				_tmp9_ = i;
				_tmp10_ = point;
				_tmp11_ = _tmp10_->x;
				_tmp12_ = allocation;
				_tmp13_ = _tmp12_.width;
				_tmp8_[_tmp9_] = _tmp11_ / ((gdouble) _tmp13_);
				_tmp14_ = _tmp8_[_tmp9_];
				_tmp15_ = coordinates;
				_tmp15__length1 = coordinates_length1;
				_tmp16_ = i;
				_tmp17_ = point;
				_tmp18_ = _tmp17_->y;
				_tmp19_ = allocation;
				_tmp20_ = _tmp19_.height;
				_tmp15_[_tmp16_ + 1] = _tmp18_ / ((gdouble) _tmp20_);
				_tmp21_ = _tmp15_[_tmp16_ + 1];
				_ibus_drawing_point_unref0 (point);
			}
		}
	}
	_tmp22_ = coordinates;
	_tmp22__length1 = coordinates_length1;
	g_signal_emit_by_name (self, "stroke-added", _tmp22_, _tmp22__length1);
	_ibus_drawing_path_unref0 (self->priv->current_path);
	self->priv->current_path = NULL;
	result = FALSE;
	coordinates = (g_free (coordinates), NULL);
	return result;
}


static gboolean ibus_drawing_drawing_area_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event) {
	IBusDrawingDrawingArea * self;
	gboolean result = FALSE;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GdkEventMotion _tmp1_;
	gdouble _tmp2_;
	GtkAllocation _tmp3_;
	gint _tmp4_;
	GtkAllocation _tmp5_;
	gint _tmp6_;
	GtkAllocation _tmp7_;
	gint _tmp8_;
	gdouble _tmp9_ = 0.0;
	gdouble x;
	GdkEventMotion _tmp10_;
	gdouble _tmp11_;
	GtkAllocation _tmp12_;
	gint _tmp13_;
	GtkAllocation _tmp14_;
	gint _tmp15_;
	GtkAllocation _tmp16_;
	gint _tmp17_;
	gdouble _tmp18_ = 0.0;
	gdouble y;
	IBusDrawingPath* _tmp19_;
	GList* _tmp20_;
	GList* _tmp21_ = NULL;
	gconstpointer _tmp22_;
	IBusDrawingPoint* _tmp23_;
	IBusDrawingPoint* last;
	gdouble _tmp24_;
	IBusDrawingPoint* _tmp25_;
	gdouble _tmp26_;
	gdouble dx;
	gdouble _tmp27_;
	IBusDrawingPoint* _tmp28_;
	gdouble _tmp29_;
	gdouble dy;
	gdouble _tmp30_;
	gdouble _tmp31_;
	gdouble _tmp32_;
	gdouble _tmp33_;
	gdouble _tmp34_ = 0.0;
	self = (IBusDrawingDrawingArea*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	allocation = _tmp0_;
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.x;
	_tmp3_ = allocation;
	_tmp4_ = _tmp3_.x;
	_tmp5_ = allocation;
	_tmp6_ = _tmp5_.x;
	_tmp7_ = allocation;
	_tmp8_ = _tmp7_.width;
	_tmp9_ = CLAMP (_tmp2_, (gdouble) _tmp4_, (gdouble) (_tmp6_ + _tmp8_));
	x = _tmp9_;
	_tmp10_ = *event;
	_tmp11_ = _tmp10_.y;
	_tmp12_ = allocation;
	_tmp13_ = _tmp12_.y;
	_tmp14_ = allocation;
	_tmp15_ = _tmp14_.y;
	_tmp16_ = allocation;
	_tmp17_ = _tmp16_.height;
	_tmp18_ = CLAMP (_tmp11_, (gdouble) _tmp13_, (gdouble) (_tmp15_ + _tmp17_));
	y = _tmp18_;
	_tmp19_ = self->priv->current_path;
	_tmp20_ = _tmp19_->points;
	_tmp21_ = g_list_last (_tmp20_);
	_tmp22_ = _tmp21_->data;
	_tmp23_ = _ibus_drawing_point_ref0 ((IBusDrawingPoint*) _tmp22_);
	last = _tmp23_;
	_tmp24_ = x;
	_tmp25_ = last;
	_tmp26_ = _tmp25_->x;
	dx = _tmp24_ - _tmp26_;
	_tmp27_ = y;
	_tmp28_ = last;
	_tmp29_ = _tmp28_->y;
	dy = _tmp27_ - _tmp29_;
	_tmp30_ = dx;
	_tmp31_ = dx;
	_tmp32_ = dy;
	_tmp33_ = dy;
	_tmp34_ = sqrt ((_tmp30_ * _tmp31_) + (_tmp32_ * _tmp33_));
	if (_tmp34_ > 10.0) {
		IBusDrawingPath* _tmp35_;
		gdouble _tmp36_;
		gdouble _tmp37_;
		IBusDrawingPoint* _tmp38_;
		_tmp35_ = self->priv->current_path;
		_tmp36_ = x;
		_tmp37_ = y;
		_tmp38_ = ibus_drawing_point_new (_tmp36_, _tmp37_);
		_tmp35_->points = g_list_append (_tmp35_->points, _tmp38_);
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	result = FALSE;
	_ibus_drawing_point_unref0 (last);
	return result;
}


static gboolean ibus_drawing_drawing_area_real_draw (GtkWidget* base, cairo_t* cr) {
	IBusDrawingDrawingArea * self;
	gboolean result = FALSE;
	GdkRGBA _tmp0_ = {0};
	GdkRGBA background;
	cairo_t* _tmp1_;
	GdkRGBA _tmp2_;
	cairo_t* _tmp3_;
	GdkRGBA _tmp4_ = {0};
	GdkRGBA foreground;
	cairo_t* _tmp5_;
	GdkRGBA _tmp6_;
	GList* _tmp7_;
	self = (IBusDrawingDrawingArea*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	memset (&_tmp0_, 0, sizeof (GdkRGBA));
	_tmp0_.red = 1.0;
	_tmp0_.green = 1.0;
	_tmp0_.blue = 1.0;
	_tmp0_.alpha = 1.0;
	background = _tmp0_;
	_tmp1_ = cr;
	_tmp2_ = background;
	gdk_cairo_set_source_rgba (_tmp1_, &_tmp2_);
	_tmp3_ = cr;
	cairo_paint (_tmp3_);
	memset (&_tmp4_, 0, sizeof (GdkRGBA));
	_tmp4_.red = 0.0;
	_tmp4_.green = 0.0;
	_tmp4_.blue = 0.0;
	_tmp4_.alpha = 1.0;
	foreground = _tmp4_;
	_tmp5_ = cr;
	_tmp6_ = foreground;
	gdk_cairo_set_source_rgba (_tmp5_, &_tmp6_);
	_tmp7_ = self->priv->paths;
	{
		GList* path_collection = NULL;
		GList* path_it = NULL;
		path_collection = _tmp7_;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			IBusDrawingPath* _tmp8_;
			IBusDrawingPath* path = NULL;
			_tmp8_ = _ibus_drawing_path_ref0 ((IBusDrawingPath*) path_it->data);
			path = _tmp8_;
			{
				IBusDrawingPath* _tmp9_;
				GList* _tmp10_;
				GList* _tmp11_ = NULL;
				gconstpointer _tmp12_;
				IBusDrawingPoint* _tmp13_;
				IBusDrawingPoint* first;
				cairo_t* _tmp14_;
				IBusDrawingPoint* _tmp15_;
				gdouble _tmp16_;
				IBusDrawingPoint* _tmp17_;
				gdouble _tmp18_;
				IBusDrawingPath* _tmp19_;
				GList* _tmp20_;
				GList* _tmp21_;
				cairo_t* _tmp28_;
				_tmp9_ = path;
				_tmp10_ = _tmp9_->points;
				_tmp11_ = g_list_first (_tmp10_);
				_tmp12_ = _tmp11_->data;
				_tmp13_ = _ibus_drawing_point_ref0 ((IBusDrawingPoint*) _tmp12_);
				first = _tmp13_;
				_tmp14_ = cr;
				_tmp15_ = first;
				_tmp16_ = _tmp15_->x;
				_tmp17_ = first;
				_tmp18_ = _tmp17_->y;
				cairo_move_to (_tmp14_, _tmp16_, _tmp18_);
				_tmp19_ = path;
				_tmp20_ = _tmp19_->points;
				_tmp21_ = _tmp20_->next;
				{
					GList* point_collection = NULL;
					GList* point_it = NULL;
					point_collection = _tmp21_;
					for (point_it = point_collection; point_it != NULL; point_it = point_it->next) {
						IBusDrawingPoint* _tmp22_;
						IBusDrawingPoint* point = NULL;
						_tmp22_ = _ibus_drawing_point_ref0 ((IBusDrawingPoint*) point_it->data);
						point = _tmp22_;
						{
							cairo_t* _tmp23_;
							IBusDrawingPoint* _tmp24_;
							gdouble _tmp25_;
							IBusDrawingPoint* _tmp26_;
							gdouble _tmp27_;
							_tmp23_ = cr;
							_tmp24_ = point;
							_tmp25_ = _tmp24_->x;
							_tmp26_ = point;
							_tmp27_ = _tmp26_->y;
							cairo_line_to (_tmp23_, _tmp25_, _tmp27_);
							_ibus_drawing_point_unref0 (point);
						}
					}
				}
				_tmp28_ = cr;
				cairo_stroke (_tmp28_);
				_ibus_drawing_point_unref0 (first);
				_ibus_drawing_path_unref0 (path);
			}
		}
	}
	result = FALSE;
	return result;
}


void ibus_drawing_drawing_area_clear (IBusDrawingDrawingArea* self) {
	g_return_if_fail (self != NULL);
	__g_list_free__ibus_drawing_path_unref0_0 (self->priv->paths);
	self->priv->paths = NULL;
	_ibus_drawing_path_unref0 (self->priv->current_path);
	self->priv->current_path = NULL;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_signal_emit_by_name (self, "stroke-removed", (guint) 0);
}


void ibus_drawing_drawing_area_undo (IBusDrawingDrawingArea* self) {
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->paths;
	if (_tmp0_ != NULL) {
		GList* _tmp1_;
		GList* _tmp2_ = NULL;
		GList* last;
		GList* _tmp3_;
		GList* _tmp4_;
		GList* prev;
		GList* _tmp5_;
		IBusDrawingPath* _tmp6_;
		_tmp1_ = self->priv->paths;
		_tmp2_ = g_list_last (_tmp1_);
		last = _tmp2_;
		_tmp3_ = last;
		_tmp4_ = _tmp3_->prev;
		prev = _tmp4_;
		_tmp5_ = last;
		self->priv->paths = g_list_delete_link (self->priv->paths, _tmp5_);
		_tmp6_ = self->priv->current_path;
		if (_tmp6_ != NULL) {
			GList* _tmp7_;
			_tmp7_ = prev;
			if (_tmp7_ != NULL) {
				GList* _tmp8_;
				gconstpointer _tmp9_;
				IBusDrawingPath* _tmp10_;
				_tmp8_ = prev;
				_tmp9_ = _tmp8_->data;
				_tmp10_ = _ibus_drawing_path_ref0 ((IBusDrawingPath*) _tmp9_);
				_ibus_drawing_path_unref0 (self->priv->current_path);
				self->priv->current_path = _tmp10_;
			} else {
				_ibus_drawing_path_unref0 (self->priv->current_path);
				self->priv->current_path = NULL;
			}
		}
		gtk_widget_queue_draw ((GtkWidget*) self);
		g_signal_emit_by_name (self, "stroke-removed", (guint) 1);
	}
}


static void g_cclosure_user_marshal_VOID__POINTER_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_INT) (gpointer data1, gpointer arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__POINTER_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void ibus_drawing_drawing_area_class_init (IBusDrawingDrawingAreaClass * klass) {
	ibus_drawing_drawing_area_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IBusDrawingDrawingAreaPrivate));
	GTK_WIDGET_CLASS (klass)->button_press_event = ibus_drawing_drawing_area_real_button_press_event;
	GTK_WIDGET_CLASS (klass)->button_release_event = ibus_drawing_drawing_area_real_button_release_event;
	GTK_WIDGET_CLASS (klass)->motion_notify_event = ibus_drawing_drawing_area_real_motion_notify_event;
	GTK_WIDGET_CLASS (klass)->draw = ibus_drawing_drawing_area_real_draw;
	G_OBJECT_CLASS (klass)->finalize = ibus_drawing_drawing_area_finalize;
	g_signal_new ("stroke_added", IBUS_DRAWING_TYPE_DRAWING_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT, G_TYPE_NONE, 2, G_TYPE_POINTER, G_TYPE_INT);
	g_signal_new ("stroke_removed", IBUS_DRAWING_TYPE_DRAWING_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
}


static void ibus_drawing_drawing_area_instance_init (IBusDrawingDrawingArea * self) {
	self->priv = IBUS_DRAWING_DRAWING_AREA_GET_PRIVATE (self);
	self->priv->paths = NULL;
	self->priv->current_path = NULL;
}


static void ibus_drawing_drawing_area_finalize (GObject* obj) {
	IBusDrawingDrawingArea * self;
	self = IBUS_DRAWING_DRAWING_AREA (obj);
	__g_list_free__ibus_drawing_path_unref0_0 (self->priv->paths);
	_ibus_drawing_path_unref0 (self->priv->current_path);
	G_OBJECT_CLASS (ibus_drawing_drawing_area_parent_class)->finalize (obj);
}


GType ibus_drawing_drawing_area_get_type (void) {
	static volatile gsize ibus_drawing_drawing_area_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_drawing_drawing_area_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IBusDrawingDrawingAreaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ibus_drawing_drawing_area_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IBusDrawingDrawingArea), 0, (GInstanceInitFunc) ibus_drawing_drawing_area_instance_init, NULL };
		GType ibus_drawing_drawing_area_type_id;
		ibus_drawing_drawing_area_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "IBusDrawingDrawingArea", &g_define_type_info, 0);
		g_once_init_leave (&ibus_drawing_drawing_area_type_id__volatile, ibus_drawing_drawing_area_type_id);
	}
	return ibus_drawing_drawing_area_type_id__volatile;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->area);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda0_ (Block1Data* _data1_) {
	IBusDrawingDrawingPanel * self;
	self = _data1_->self;
	ibus_drawing_drawing_area_undo (_data1_->area);
}


static void ___lambda0__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda0_ (self);
}


static void __lambda1_ (Block1Data* _data1_) {
	IBusDrawingDrawingPanel * self;
	self = _data1_->self;
	ibus_drawing_drawing_area_clear (_data1_->area);
}


static void ___lambda1__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda1_ (self);
}


static void __lambda2_ (IBusDrawingDrawingPanel* self, gdouble* coordinates, int coordinates_length1) {
	gdouble* _tmp0_;
	gint _tmp0__length1;
	_tmp0_ = coordinates;
	_tmp0__length1 = coordinates_length1;
	g_signal_emit_by_name (self, "stroke-added", _tmp0_, _tmp0__length1);
}


static void ___lambda2__ibus_drawing_drawing_area_stroke_added (IBusDrawingDrawingArea* _sender, gdouble* coordinates, int coordinates_length1, gpointer self) {
	__lambda2_ (self, coordinates, coordinates_length1);
}


static void __lambda3_ (IBusDrawingDrawingPanel* self, guint n_strokes) {
	guint _tmp0_;
	_tmp0_ = n_strokes;
	g_signal_emit_by_name (self, "stroke-removed", _tmp0_);
}


static void ___lambda3__ibus_drawing_drawing_area_stroke_removed (IBusDrawingDrawingArea* _sender, guint n_strokes, gpointer self) {
	__lambda3_ (self, n_strokes);
}


IBusDrawingDrawingPanel* ibus_drawing_drawing_panel_construct (GType object_type, IBusConfig* config) {
	IBusDrawingDrawingPanel * self = NULL;
	Block1Data* _data1_;
	GtkVBox* _tmp0_;
	GtkVBox* _tmp1_;
	GtkVBox* paned;
	IBusDrawingDrawingArea* _tmp2_;
	IBusDrawingDrawingArea* _tmp3_;
	GtkHButtonBox* _tmp4_;
	GtkHButtonBox* _tmp5_;
	GtkHButtonBox* bbox;
	GtkToolButton* _tmp6_;
	GtkToolButton* _tmp7_;
	GtkToolButton* undo_button;
	GtkToolButton* _tmp8_;
	GtkToolButton* _tmp9_;
	GtkToolButton* clear_button;
	g_return_val_if_fail (config != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	self = (IBusDrawingDrawingPanel*) g_object_new (object_type, NULL);
	_data1_->self = g_object_ref (self);
	_tmp0_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	_tmp1_ = g_object_ref_sink (_tmp0_);
	paned = _tmp1_;
	_tmp2_ = ibus_drawing_drawing_area_new ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_data1_->area = _tmp3_;
	gtk_box_pack_start ((GtkBox*) paned, (GtkWidget*) _data1_->area, TRUE, TRUE, (guint) 0);
	_tmp4_ = (GtkHButtonBox*) gtk_hbutton_box_new ();
	_tmp5_ = g_object_ref_sink (_tmp4_);
	bbox = _tmp5_;
	gtk_box_set_homogeneous ((GtkBox*) bbox, FALSE);
	_tmp6_ = (GtkToolButton*) gtk_tool_button_new_from_stock (GTK_STOCK_UNDO);
	_tmp7_ = g_object_ref_sink (_tmp6_);
	undo_button = _tmp7_;
	g_signal_connect_data (undo_button, "clicked", (GCallback) ___lambda0__gtk_tool_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	gtk_box_pack_end ((GtkBox*) bbox, (GtkWidget*) undo_button, FALSE, FALSE, (guint) 0);
	_tmp8_ = (GtkToolButton*) gtk_tool_button_new_from_stock (GTK_STOCK_CLEAR);
	_tmp9_ = g_object_ref_sink (_tmp8_);
	clear_button = _tmp9_;
	g_signal_connect_data (clear_button, "clicked", (GCallback) ___lambda1__gtk_tool_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	gtk_box_pack_end ((GtkBox*) bbox, (GtkWidget*) clear_button, FALSE, FALSE, (guint) 0);
	gtk_box_pack_end ((GtkBox*) paned, (GtkWidget*) bbox, FALSE, FALSE, (guint) 0);
	g_signal_connect_object (_data1_->area, "stroke-added", (GCallback) ___lambda2__ibus_drawing_drawing_area_stroke_added, self, 0);
	g_signal_connect_object (_data1_->area, "stroke-removed", (GCallback) ___lambda3__ibus_drawing_drawing_area_stroke_removed, self, 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) paned, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (clear_button);
	_g_object_unref0 (undo_button);
	_g_object_unref0 (bbox);
	_g_object_unref0 (paned);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return self;
}


IBusDrawingDrawingPanel* ibus_drawing_drawing_panel_new (IBusConfig* config) {
	return ibus_drawing_drawing_panel_construct (IBUS_DRAWING_TYPE_DRAWING_PANEL, config);
}


static void ibus_drawing_drawing_panel_class_init (IBusDrawingDrawingPanelClass * klass) {
	ibus_drawing_drawing_panel_parent_class = g_type_class_peek_parent (klass);
	g_signal_new ("stroke_added", IBUS_DRAWING_TYPE_DRAWING_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT, G_TYPE_NONE, 2, G_TYPE_POINTER, G_TYPE_INT);
	g_signal_new ("stroke_removed", IBUS_DRAWING_TYPE_DRAWING_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
}


static void ibus_drawing_drawing_panel_instance_init (IBusDrawingDrawingPanel * self) {
}


GType ibus_drawing_drawing_panel_get_type (void) {
	static volatile gsize ibus_drawing_drawing_panel_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_drawing_drawing_panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IBusDrawingDrawingPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ibus_drawing_drawing_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IBusDrawingDrawingPanel), 0, (GInstanceInitFunc) ibus_drawing_drawing_panel_instance_init, NULL };
		GType ibus_drawing_drawing_panel_type_id;
		ibus_drawing_drawing_panel_type_id = g_type_register_static (GTK_TYPE_BOX, "IBusDrawingDrawingPanel", &g_define_type_info, 0);
		g_once_init_leave (&ibus_drawing_drawing_panel_type_id__volatile, ibus_drawing_drawing_panel_type_id);
	}
	return ibus_drawing_drawing_panel_type_id__volatile;
}



