/* ibusvirtkbd.c generated by valac 0.14.0, the Vala compiler
 * generated from ibusvirtkbd.vala, do not modify */

/* 
 * Copyright (C) 2011 Daiki Ueno <ueno@unixuser.org>
 * Copyright (C) 2011 Red Hat, Inc.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <ibus/ibuspanelextensions.h>


#define IBUS_TYPE_IVIRTKBD (ibus_ivirtkbd_get_type ())
#define IBUS_IVIRTKBD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_TYPE_IVIRTKBD, IBusIVirtkbd))
#define IBUS_IS_IVIRTKBD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_TYPE_IVIRTKBD))
#define IBUS_IVIRTKBD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IBUS_TYPE_IVIRTKBD, IBusIVirtkbdIface))

typedef struct _IBusIVirtkbd IBusIVirtkbd;
typedef struct _IBusIVirtkbdIface IBusIVirtkbdIface;

#define IBUS_TYPE_IVIRTKBD_PROXY (ibus_ivirtkbd_proxy_get_type ())
typedef GDBusProxy IBusIVirtkbdProxy;
typedef GDBusProxyClass IBusIVirtkbdProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define IBUS_TYPE_VIRTKBD (ibus_virtkbd_get_type ())
#define IBUS_VIRTKBD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_TYPE_VIRTKBD, IBusVirtkbd))
#define IBUS_VIRTKBD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_TYPE_VIRTKBD, IBusVirtkbdClass))
#define IBUS_IS_VIRTKBD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_TYPE_VIRTKBD))
#define IBUS_IS_VIRTKBD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_TYPE_VIRTKBD))
#define IBUS_VIRTKBD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_TYPE_VIRTKBD, IBusVirtkbdClass))

typedef struct _IBusVirtkbd IBusVirtkbd;
typedef struct _IBusVirtkbdClass IBusVirtkbdClass;
typedef struct _IBusVirtkbdPrivate IBusVirtkbdPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _IBusIVirtkbdIface {
	GTypeInterface parent_iface;
	void (*show) (IBusIVirtkbd* self, GError** error);
	void (*hide) (IBusIVirtkbd* self, GError** error);
	void (*set_cursor_location) (IBusIVirtkbd* self, gint x, gint y, gint w, gint h, GError** error);
	void (*set_keyboard) (IBusIVirtkbd* self, const gchar* keyboard, GError** error);
};

struct _IBusVirtkbd {
	IBusPanelExtension parent_instance;
	IBusVirtkbdPrivate * priv;
};

struct _IBusVirtkbdClass {
	IBusPanelExtensionClass parent_class;
};

struct _IBusVirtkbdPrivate {
	gchar* _keyboard_type;
	IBusIVirtkbd* proxy;
};


static gpointer ibus_virtkbd_parent_class = NULL;

GType ibus_ivirtkbd_proxy_get_type (void) G_GNUC_CONST;
guint ibus_ivirtkbd_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType ibus_ivirtkbd_get_type (void) G_GNUC_CONST;
void ibus_ivirtkbd_show (IBusIVirtkbd* self, GError** error);
void ibus_ivirtkbd_hide (IBusIVirtkbd* self, GError** error);
void ibus_ivirtkbd_set_cursor_location (IBusIVirtkbd* self, gint x, gint y, gint w, gint h, GError** error);
void ibus_ivirtkbd_set_keyboard (IBusIVirtkbd* self, const gchar* keyboard, GError** error);
static void ibus_ivirtkbd_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_ibus_ivirtkbd_text_activated (IBusIVirtkbd* self, GVariant* parameters);
static void ibus_ivirtkbd_proxy_show (IBusIVirtkbd* self, GError** error);
static void ibus_ivirtkbd_proxy_hide (IBusIVirtkbd* self, GError** error);
static void ibus_ivirtkbd_proxy_set_cursor_location (IBusIVirtkbd* self, gint x, gint y, gint w, gint h, GError** error);
static void ibus_ivirtkbd_proxy_set_keyboard (IBusIVirtkbd* self, const gchar* keyboard, GError** error);
static void ibus_ivirtkbd_proxy_ibus_ivirtkbd_interface_init (IBusIVirtkbdIface* iface);
static void _dbus_ibus_ivirtkbd_show (IBusIVirtkbd* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_ibus_ivirtkbd_hide (IBusIVirtkbd* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_ibus_ivirtkbd_set_cursor_location (IBusIVirtkbd* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_ibus_ivirtkbd_set_keyboard (IBusIVirtkbd* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void ibus_ivirtkbd_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* ibus_ivirtkbd_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean ibus_ivirtkbd_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_ibus_ivirtkbd_text_activated (GObject* _sender, const gchar* text, gpointer* _data);
static void _ibus_ivirtkbd_unregister_object (gpointer user_data);
GType ibus_virtkbd_get_type (void) G_GNUC_CONST;
#define IBUS_VIRTKBD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), IBUS_TYPE_VIRTKBD, IBusVirtkbdPrivate))
enum  {
	IBUS_VIRTKBD_DUMMY_PROPERTY,
	IBUS_VIRTKBD_KEYBOARD_TYPE
};
IBusVirtkbd* ibus_virtkbd_new (GDBusConnection* conn, GError** error);
IBusVirtkbd* ibus_virtkbd_construct (GType object_type, GDBusConnection* conn, GError** error);
static void __lambda0_ (IBusVirtkbd* self, const gchar* text);
static void ___lambda0__ibus_ivirtkbd_text_activated (IBusIVirtkbd* _sender, const gchar* text, gpointer self);
static void __lambda1_ (IBusVirtkbd* self, GVariant* c, gchar** i, int i_length1);
static void ___lambda1__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self);
static void ibus_virtkbd_real_show (IBusPanelExtension* base);
static void ibus_virtkbd_real_hide (IBusPanelExtension* base);
static void ibus_virtkbd_real_set_cursor_location (IBusPanelExtension* base, gint x, gint y, gint w, gint h);
void ibus_virtkbd_set_keyboard (IBusVirtkbd* self, const gchar* keyboard);
const gchar* ibus_virtkbd_get_keyboard_type (IBusVirtkbd* self);
void ibus_virtkbd_set_keyboard_type (IBusVirtkbd* self, const gchar* value);
static void ibus_virtkbd_finalize (GObject* obj);
static void _vala_ibus_virtkbd_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_ibus_virtkbd_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo * const _ibus_ivirtkbd_dbus_arg_info_show_in[] = {NULL};
static const GDBusArgInfo * const _ibus_ivirtkbd_dbus_arg_info_show_out[] = {NULL};
static const GDBusMethodInfo _ibus_ivirtkbd_dbus_method_info_show = {-1, "Show", (GDBusArgInfo **) (&_ibus_ivirtkbd_dbus_arg_info_show_in), (GDBusArgInfo **) (&_ibus_ivirtkbd_dbus_arg_info_show_out)};
static const GDBusArgInfo * const _ibus_ivirtkbd_dbus_arg_info_hide_in[] = {NULL};
static const GDBusArgInfo * const _ibus_ivirtkbd_dbus_arg_info_hide_out[] = {NULL};
static const GDBusMethodInfo _ibus_ivirtkbd_dbus_method_info_hide = {-1, "Hide", (GDBusArgInfo **) (&_ibus_ivirtkbd_dbus_arg_info_hide_in), (GDBusArgInfo **) (&_ibus_ivirtkbd_dbus_arg_info_hide_out)};
static const GDBusArgInfo _ibus_ivirtkbd_dbus_arg_info_set_cursor_location_x = {-1, "x", "i"};
static const GDBusArgInfo _ibus_ivirtkbd_dbus_arg_info_set_cursor_location_y = {-1, "y", "i"};
static const GDBusArgInfo _ibus_ivirtkbd_dbus_arg_info_set_cursor_location_w = {-1, "w", "i"};
static const GDBusArgInfo _ibus_ivirtkbd_dbus_arg_info_set_cursor_location_h = {-1, "h", "i"};
static const GDBusArgInfo * const _ibus_ivirtkbd_dbus_arg_info_set_cursor_location_in[] = {&_ibus_ivirtkbd_dbus_arg_info_set_cursor_location_x, &_ibus_ivirtkbd_dbus_arg_info_set_cursor_location_y, &_ibus_ivirtkbd_dbus_arg_info_set_cursor_location_w, &_ibus_ivirtkbd_dbus_arg_info_set_cursor_location_h, NULL};
static const GDBusArgInfo * const _ibus_ivirtkbd_dbus_arg_info_set_cursor_location_out[] = {NULL};
static const GDBusMethodInfo _ibus_ivirtkbd_dbus_method_info_set_cursor_location = {-1, "SetCursorLocation", (GDBusArgInfo **) (&_ibus_ivirtkbd_dbus_arg_info_set_cursor_location_in), (GDBusArgInfo **) (&_ibus_ivirtkbd_dbus_arg_info_set_cursor_location_out)};
static const GDBusArgInfo _ibus_ivirtkbd_dbus_arg_info_set_keyboard_keyboard = {-1, "keyboard", "s"};
static const GDBusArgInfo * const _ibus_ivirtkbd_dbus_arg_info_set_keyboard_in[] = {&_ibus_ivirtkbd_dbus_arg_info_set_keyboard_keyboard, NULL};
static const GDBusArgInfo * const _ibus_ivirtkbd_dbus_arg_info_set_keyboard_out[] = {NULL};
static const GDBusMethodInfo _ibus_ivirtkbd_dbus_method_info_set_keyboard = {-1, "SetKeyboard", (GDBusArgInfo **) (&_ibus_ivirtkbd_dbus_arg_info_set_keyboard_in), (GDBusArgInfo **) (&_ibus_ivirtkbd_dbus_arg_info_set_keyboard_out)};
static const GDBusMethodInfo * const _ibus_ivirtkbd_dbus_method_info[] = {&_ibus_ivirtkbd_dbus_method_info_show, &_ibus_ivirtkbd_dbus_method_info_hide, &_ibus_ivirtkbd_dbus_method_info_set_cursor_location, &_ibus_ivirtkbd_dbus_method_info_set_keyboard, NULL};
static const GDBusArgInfo _ibus_ivirtkbd_dbus_arg_info_text_activated_text = {-1, "text", "s"};
static const GDBusArgInfo * const _ibus_ivirtkbd_dbus_arg_info_text_activated[] = {&_ibus_ivirtkbd_dbus_arg_info_text_activated_text, NULL};
static const GDBusSignalInfo _ibus_ivirtkbd_dbus_signal_info_text_activated = {-1, "TextActivated", (GDBusArgInfo **) (&_ibus_ivirtkbd_dbus_arg_info_text_activated)};
static const GDBusSignalInfo * const _ibus_ivirtkbd_dbus_signal_info[] = {&_ibus_ivirtkbd_dbus_signal_info_text_activated, NULL};
static const GDBusPropertyInfo * const _ibus_ivirtkbd_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _ibus_ivirtkbd_dbus_interface_info = {-1, "org.freedesktop.IBus.Virtkbd", (GDBusMethodInfo **) (&_ibus_ivirtkbd_dbus_method_info), (GDBusSignalInfo **) (&_ibus_ivirtkbd_dbus_signal_info), (GDBusPropertyInfo **) (&_ibus_ivirtkbd_dbus_property_info)};
static const GDBusInterfaceVTable _ibus_ivirtkbd_dbus_interface_vtable = {ibus_ivirtkbd_dbus_interface_method_call, ibus_ivirtkbd_dbus_interface_get_property, ibus_ivirtkbd_dbus_interface_set_property};

void ibus_ivirtkbd_show (IBusIVirtkbd* self, GError** error) {
	g_return_if_fail (self != NULL);
	IBUS_IVIRTKBD_GET_INTERFACE (self)->show (self, error);
}


void ibus_ivirtkbd_hide (IBusIVirtkbd* self, GError** error) {
	g_return_if_fail (self != NULL);
	IBUS_IVIRTKBD_GET_INTERFACE (self)->hide (self, error);
}


void ibus_ivirtkbd_set_cursor_location (IBusIVirtkbd* self, gint x, gint y, gint w, gint h, GError** error) {
	g_return_if_fail (self != NULL);
	IBUS_IVIRTKBD_GET_INTERFACE (self)->set_cursor_location (self, x, y, w, h, error);
}


void ibus_ivirtkbd_set_keyboard (IBusIVirtkbd* self, const gchar* keyboard, GError** error) {
	g_return_if_fail (self != NULL);
	IBUS_IVIRTKBD_GET_INTERFACE (self)->set_keyboard (self, keyboard, error);
}


static void ibus_ivirtkbd_base_init (IBusIVirtkbdIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("text_activated", IBUS_TYPE_IVIRTKBD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	}
}


GType ibus_ivirtkbd_get_type (void) {
	static volatile gsize ibus_ivirtkbd_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_ivirtkbd_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IBusIVirtkbdIface), (GBaseInitFunc) ibus_ivirtkbd_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType ibus_ivirtkbd_type_id;
		ibus_ivirtkbd_type_id = g_type_register_static (G_TYPE_INTERFACE, "IBusIVirtkbd", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (ibus_ivirtkbd_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (ibus_ivirtkbd_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) ibus_ivirtkbd_proxy_get_type);
		g_type_set_qdata (ibus_ivirtkbd_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.IBus.Virtkbd");
		g_type_set_qdata (ibus_ivirtkbd_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) ibus_ivirtkbd_register_object);
		g_once_init_leave (&ibus_ivirtkbd_type_id__volatile, ibus_ivirtkbd_type_id);
	}
	return ibus_ivirtkbd_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (IBusIVirtkbdProxy, ibus_ivirtkbd_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (IBUS_TYPE_IVIRTKBD, ibus_ivirtkbd_proxy_ibus_ivirtkbd_interface_init) )
static void ibus_ivirtkbd_proxy_class_init (IBusIVirtkbdProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = ibus_ivirtkbd_proxy_g_signal;
}


static void _dbus_handle_ibus_ivirtkbd_text_activated (IBusIVirtkbd* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* text = NULL;
	GVariant* _tmp0_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	text = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	g_signal_emit_by_name (self, "text-activated", text);
	_g_free0 (text);
}


static void ibus_ivirtkbd_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "TextActivated") == 0) {
		_dbus_handle_ibus_ivirtkbd_text_activated ((IBusIVirtkbd*) proxy, parameters);
	}
}


static void ibus_ivirtkbd_proxy_init (IBusIVirtkbdProxy* self) {
}


static void ibus_ivirtkbd_proxy_show (IBusIVirtkbd* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.IBus.Virtkbd", "Show");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void ibus_ivirtkbd_proxy_hide (IBusIVirtkbd* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.IBus.Virtkbd", "Hide");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void ibus_ivirtkbd_proxy_set_cursor_location (IBusIVirtkbd* self, gint x, gint y, gint w, gint h, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.IBus.Virtkbd", "SetCursorLocation");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (x));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (y));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (w));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (h));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void ibus_ivirtkbd_proxy_set_keyboard (IBusIVirtkbd* self, const gchar* keyboard, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.IBus.Virtkbd", "SetKeyboard");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (keyboard));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void ibus_ivirtkbd_proxy_ibus_ivirtkbd_interface_init (IBusIVirtkbdIface* iface) {
	iface->show = ibus_ivirtkbd_proxy_show;
	iface->hide = ibus_ivirtkbd_proxy_hide;
	iface->set_cursor_location = ibus_ivirtkbd_proxy_set_cursor_location;
	iface->set_keyboard = ibus_ivirtkbd_proxy_set_keyboard;
}


static void _dbus_ibus_ivirtkbd_show (IBusIVirtkbd* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	ibus_ivirtkbd_show (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_ibus_ivirtkbd_hide (IBusIVirtkbd* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	ibus_ivirtkbd_hide (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_ibus_ivirtkbd_set_cursor_location (IBusIVirtkbd* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint x = 0;
	GVariant* _tmp1_;
	gint y = 0;
	GVariant* _tmp2_;
	gint w = 0;
	GVariant* _tmp3_;
	gint h = 0;
	GVariant* _tmp4_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	x = g_variant_get_int32 (_tmp1_);
	g_variant_unref (_tmp1_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	y = g_variant_get_int32 (_tmp2_);
	g_variant_unref (_tmp2_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	w = g_variant_get_int32 (_tmp3_);
	g_variant_unref (_tmp3_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	h = g_variant_get_int32 (_tmp4_);
	g_variant_unref (_tmp4_);
	ibus_ivirtkbd_set_cursor_location (self, x, y, w, h, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_ibus_ivirtkbd_set_keyboard (IBusIVirtkbd* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* keyboard = NULL;
	GVariant* _tmp5_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	keyboard = g_variant_dup_string (_tmp5_, NULL);
	g_variant_unref (_tmp5_);
	ibus_ivirtkbd_set_keyboard (self, keyboard, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (keyboard);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void ibus_ivirtkbd_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Show") == 0) {
		_dbus_ibus_ivirtkbd_show (object, parameters, invocation);
	} else if (strcmp (method_name, "Hide") == 0) {
		_dbus_ibus_ivirtkbd_hide (object, parameters, invocation);
	} else if (strcmp (method_name, "SetCursorLocation") == 0) {
		_dbus_ibus_ivirtkbd_set_cursor_location (object, parameters, invocation);
	} else if (strcmp (method_name, "SetKeyboard") == 0) {
		_dbus_ibus_ivirtkbd_set_keyboard (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* ibus_ivirtkbd_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean ibus_ivirtkbd_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_ibus_ivirtkbd_text_activated (GObject* _sender, const gchar* text, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (text));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.IBus.Virtkbd", "TextActivated", _arguments, NULL);
}


guint ibus_ivirtkbd_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_ibus_ivirtkbd_dbus_interface_info), &_ibus_ivirtkbd_dbus_interface_vtable, data, _ibus_ivirtkbd_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "text-activated", (GCallback) _dbus_ibus_ivirtkbd_text_activated, data);
	return result;
}


static void _ibus_ivirtkbd_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_ibus_ivirtkbd_text_activated, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


/**
         * Create a virtkbd instance.
         *
         * @param conn a DBusConnection
         *
         * @return a new Virtkbd
         */
static void __lambda0_ (IBusVirtkbd* self, const gchar* text) {
	const gchar* _tmp0_;
	g_return_if_fail (text != NULL);
	_tmp0_ = text;
	g_signal_emit_by_name (self, "text-activated", _tmp0_);
}


static void ___lambda0__ibus_ivirtkbd_text_activated (IBusIVirtkbd* _sender, const gchar* text, gpointer self) {
	__lambda0_ (self, text);
}


static void __lambda1_ (IBusVirtkbd* self, GVariant* c, gchar** i, int i_length1) {
	GVariant* _tmp0_;
	const GVariantType* _tmp1_;
	GVariant* _tmp2_ = NULL;
	GVariant* v;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	_tmp1_ = G_VARIANT_TYPE_BOOLEAN;
	_tmp2_ = g_variant_lookup_value (_tmp0_, "visible", _tmp1_);
	v = _tmp2_;
	_tmp3_ = g_variant_get_boolean (v);
	ibus_panel_extension_set_visible ((IBusPanelExtension*) self, _tmp3_);
	_g_variant_unref0 (v);
}


static void ___lambda1__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self) {
	__lambda1_ (self, changed_properties, invalidated_properties, _vala_array_length (invalidated_properties));
}


IBusVirtkbd* ibus_virtkbd_construct (GType object_type, GDBusConnection* conn, GError** error) {
	IBusVirtkbd * self = NULL;
	GDBusConnection* _tmp0_;
	IBusIVirtkbd* _tmp1_ = NULL;
	IBusIVirtkbd* _tmp2_;
	IBusIVirtkbd* _tmp3_;
	IBusIVirtkbd* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (conn != NULL, NULL);
	self = (IBusVirtkbd*) ibus_panel_extension_construct (object_type);
	_tmp0_ = conn;
	_tmp1_ = g_initable_new (IBUS_TYPE_IVIRTKBD_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.freedesktop.IBus.Virtkbd", "g-connection", _tmp0_, "g-object-path", "/org/freedesktop/IBus/Virtkbd", "g-interface-name", "org.freedesktop.IBus.Virtkbd", NULL);
	_tmp2_ = (IBusIVirtkbd*) _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (self->priv->proxy);
	self->priv->proxy = _tmp2_;
	_tmp3_ = self->priv->proxy;
	g_signal_connect_object (_tmp3_, "text-activated", (GCallback) ___lambda0__ibus_ivirtkbd_text_activated, self, 0);
	_tmp4_ = self->priv->proxy;
	g_signal_connect_object (G_DBUS_PROXY (_tmp4_), "g-properties-changed", (GCallback) ___lambda1__g_dbus_proxy_g_properties_changed, self, 0);
	return self;
}


IBusVirtkbd* ibus_virtkbd_new (GDBusConnection* conn, GError** error) {
	return ibus_virtkbd_construct (IBUS_TYPE_VIRTKBD, conn, error);
}


/**
         * {@inheritDoc}
         */
static void ibus_virtkbd_real_show (IBusPanelExtension* base) {
	IBusVirtkbd * self;
	GError * _inner_error_ = NULL;
	self = (IBusVirtkbd*) base;
	{
		IBusIVirtkbd* _tmp0_;
		_tmp0_ = self->priv->proxy;
		ibus_ivirtkbd_show (_tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("ibusvirtkbd.vala:71: Error: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
         * {@inheritDoc}
         */
static void ibus_virtkbd_real_hide (IBusPanelExtension* base) {
	IBusVirtkbd * self;
	GError * _inner_error_ = NULL;
	self = (IBusVirtkbd*) base;
	{
		IBusIVirtkbd* _tmp0_;
		_tmp0_ = self->priv->proxy;
		ibus_ivirtkbd_hide (_tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch1_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally1;
	__catch1_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("ibusvirtkbd.vala:82: Error: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
         * {@inheritDoc}
         */
static void ibus_virtkbd_real_set_cursor_location (IBusPanelExtension* base, gint x, gint y, gint w, gint h) {
	IBusVirtkbd * self;
	GError * _inner_error_ = NULL;
	self = (IBusVirtkbd*) base;
	{
		IBusIVirtkbd* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp0_ = self->priv->proxy;
		_tmp1_ = x;
		_tmp2_ = y;
		_tmp3_ = w;
		_tmp4_ = h;
		ibus_ivirtkbd_set_cursor_location (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch2_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally2;
	__catch2_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("ibusvirtkbd.vala:93: Error: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
         * Set the keyboard type.
         *
         * @param keyboard name of keyboard
         */
void ibus_virtkbd_set_keyboard (IBusVirtkbd* self, const gchar* keyboard) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (keyboard != NULL);
	{
		IBusIVirtkbd* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = self->priv->proxy;
		_tmp1_ = keyboard;
		ibus_ivirtkbd_set_keyboard (_tmp0_, _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch3_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally3;
	__catch3_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("ibusvirtkbd.vala:106: Error: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


const gchar* ibus_virtkbd_get_keyboard_type (IBusVirtkbd* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_keyboard_type;
	result = _tmp0_;
	return result;
}


void ibus_virtkbd_set_keyboard_type (IBusVirtkbd* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_keyboard_type);
	self->priv->_keyboard_type = _tmp1_;
	g_object_notify ((GObject *) self, "keyboard-type");
}


static void ibus_virtkbd_class_init (IBusVirtkbdClass * klass) {
	ibus_virtkbd_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IBusVirtkbdPrivate));
	IBUS_PANEL_EXTENSION_CLASS (klass)->show = ibus_virtkbd_real_show;
	IBUS_PANEL_EXTENSION_CLASS (klass)->hide = ibus_virtkbd_real_hide;
	IBUS_PANEL_EXTENSION_CLASS (klass)->set_cursor_location = ibus_virtkbd_real_set_cursor_location;
	G_OBJECT_CLASS (klass)->get_property = _vala_ibus_virtkbd_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_ibus_virtkbd_set_property;
	G_OBJECT_CLASS (klass)->finalize = ibus_virtkbd_finalize;
	/**
	         * Keyboard type to be displayed.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), IBUS_VIRTKBD_KEYBOARD_TYPE, g_param_spec_string ("keyboard-type", "keyboard-type", "keyboard-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Signal emitted each time a symbol text is activated.
	         *
	         * @param text a symbol text
	         */
	g_signal_new ("text_activated", IBUS_TYPE_VIRTKBD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void ibus_virtkbd_instance_init (IBusVirtkbd * self) {
	self->priv = IBUS_VIRTKBD_GET_PRIVATE (self);
}


static void ibus_virtkbd_finalize (GObject* obj) {
	IBusVirtkbd * self;
	self = IBUS_VIRTKBD (obj);
	ibus_panel_extension_hide ((IBusPanelExtension*) self);
	_g_free0 (self->priv->_keyboard_type);
	_g_object_unref0 (self->priv->proxy);
	G_OBJECT_CLASS (ibus_virtkbd_parent_class)->finalize (obj);
}


/**
     * Proxy to access the virtual keyboard service.
     */
GType ibus_virtkbd_get_type (void) {
	static volatile gsize ibus_virtkbd_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_virtkbd_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IBusVirtkbdClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ibus_virtkbd_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IBusVirtkbd), 0, (GInstanceInitFunc) ibus_virtkbd_instance_init, NULL };
		GType ibus_virtkbd_type_id;
		ibus_virtkbd_type_id = g_type_register_static (IBUS_TYPE_PANEL_EXTENSION, "IBusVirtkbd", &g_define_type_info, 0);
		g_once_init_leave (&ibus_virtkbd_type_id__volatile, ibus_virtkbd_type_id);
	}
	return ibus_virtkbd_type_id__volatile;
}


static void _vala_ibus_virtkbd_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	IBusVirtkbd * self;
	self = IBUS_VIRTKBD (object);
	switch (property_id) {
		case IBUS_VIRTKBD_KEYBOARD_TYPE:
		g_value_set_string (value, ibus_virtkbd_get_keyboard_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_ibus_virtkbd_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	IBusVirtkbd * self;
	self = IBUS_VIRTKBD (object);
	switch (property_id) {
		case IBUS_VIRTKBD_KEYBOARD_TYPE:
		ibus_virtkbd_set_keyboard_type (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



