/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.text.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBox;
import org.jfree.text.TextLine;
import org.jfree.ui.RectangleInsets;

public class TextBoxTests
extends TestCase {
    static /* synthetic */ Class class$org$jfree$text$junit$TextBoxTests;

    public static Test suite() {
        return new TestSuite(class$org$jfree$text$junit$TextBoxTests == null ? (class$org$jfree$text$junit$TextBoxTests = TextBoxTests.class$("org.jfree.text.junit.TextBoxTests")) : class$org$jfree$text$junit$TextBoxTests);
    }

    public TextBoxTests(String name) {
        super(name);
    }

    public void testEquals() {
        TextBox b1 = new TextBox("Hello");
        TextBox b2 = new TextBox("Hello");
        TextBoxTests.assertTrue((boolean)b1.equals(b2));
        TextBoxTests.assertTrue((boolean)b2.equals(b1));
        b1.setOutlinePaint(Color.blue);
        TextBoxTests.assertFalse((boolean)b1.equals(b2));
        b2.setOutlinePaint(Color.blue);
        TextBoxTests.assertTrue((boolean)b1.equals(b2));
        b1.setOutlineStroke(new BasicStroke(1.1f));
        TextBoxTests.assertFalse((boolean)b1.equals(b2));
        b2.setOutlineStroke(new BasicStroke(1.1f));
        TextBoxTests.assertTrue((boolean)b1.equals(b2));
        b1.setInteriorGap(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
        TextBoxTests.assertFalse((boolean)b1.equals(b2));
        b2.setInteriorGap(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
        TextBoxTests.assertTrue((boolean)b1.equals(b2));
        b1.setBackgroundPaint(Color.blue);
        TextBoxTests.assertFalse((boolean)b1.equals(b2));
        b2.setBackgroundPaint(Color.blue);
        TextBoxTests.assertTrue((boolean)b1.equals(b2));
        b1.setShadowPaint(Color.blue);
        TextBoxTests.assertFalse((boolean)b1.equals(b2));
        b2.setShadowPaint(Color.blue);
        TextBoxTests.assertTrue((boolean)b1.equals(b2));
        b1.setShadowXOffset(1.0);
        TextBoxTests.assertFalse((boolean)b1.equals(b2));
        b2.setShadowXOffset(1.0);
        TextBoxTests.assertTrue((boolean)b1.equals(b2));
        b1.setShadowYOffset(1.0);
        TextBoxTests.assertFalse((boolean)b1.equals(b2));
        b2.setShadowYOffset(1.0);
        TextBoxTests.assertTrue((boolean)b1.equals(b2));
        TextBlock tb1 = new TextBlock();
        tb1.addLine(new TextLine("Testing"));
        b1.setTextBlock(tb1);
        TextBoxTests.assertFalse((boolean)b1.equals(b2));
        TextBlock tb2 = new TextBlock();
        tb2.addLine(new TextLine("Testing"));
        b2.setTextBlock(tb2);
        TextBoxTests.assertTrue((boolean)b1.equals(b2));
    }

    public void testSerialization() {
        TextBox b1 = new TextBox("Hello");
        TextBox b2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(b1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            b2 = (TextBox)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        TextBoxTests.assertEquals((Object)b1, b2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

