SET(K3D_OPENGL_FOUND 0)
SET(K3D_OPENGL_GLU_FOUND 0)

IF(APPLE)
	SET(K3D_OPENGL_INCLUDE_DIR /usr/X11R6/include CACHE PATH "Directory containing the OpenGL header files")
	SET(K3D_OPENGL_GL_LIBRARY /usr/X11R6/lib/libGL.dylib CACHE FILEPATH "The OpenGL shared library")
	SET(K3D_OPENGL_GLU_LIBRARY /usr/X11R6/lib/libGLU.dylib CACHE FILEPATH "The OpenGL GLU shared library")
ELSE(APPLE)
	INCLUDE(FindOpenGL)

	SET(K3D_OPENGL_INCLUDE_DIR ${OPENGL_INCLUDE_DIR} CACHE PATH "Directory containing the OpenGL header files")
	SET(K3D_OPENGL_GL_LIBRARY ${OPENGL_gl_LIBRARY} CACHE FILEPATH "The OpenGL shared library")
	SET(K3D_OPENGL_GLU_LIBRARY ${OPENGL_glu_LIBRARY} CACHE FILEPATH "The OpenGL GLU shared library")
ENDIF(APPLE)

IF(WIN32)
	SET(K3D_OPENGL_FOUND 1)
	SET(K3D_OPENGL_GLU_FOUND 1)
ELSE(WIN32)
	IF(EXISTS "${K3D_OPENGL_INCLUDE_DIR}" AND EXISTS "${K3D_OPENGL_GL_LIBRARY}")
		SET(K3D_OPENGL_FOUND 1)
	ENDIF(EXISTS "${K3D_OPENGL_INCLUDE_DIR}" AND EXISTS "${K3D_OPENGL_GL_LIBRARY}")

	IF(EXISTS "${K3D_OPENGL_INCLUDE_DIR}" AND EXISTS "${K3D_OPENGL_GLU_LIBRARY}")
		SET(K3D_OPENGL_GLU_FOUND 1)
	ENDIF(EXISTS "${K3D_OPENGL_INCLUDE_DIR}" AND EXISTS "${K3D_OPENGL_GLU_LIBRARY}")
ENDIF(WIN32)

MARK_AS_ADVANCED(K3D_OPENGL_INCLUDE_DIR)
MARK_AS_ADVANCED(K3D_OPENGL_GL_LIBRARY)
MARK_AS_ADVANCED(K3D_OPENGL_GLU_LIBRARY)

