#include "config.h"
#include "minato_buffer.h"
#include "minato_debug.h"
#include <stdlib.h>
#include <string.h>

//////////////////////////////////////////////////////////////////////
// 初期化
//////////////////////////////////////////////////////////////////////
#ifdef MDEBUG

buffer_obj* buffer_new_debug(int first_size, const char* fname, int line, const char* func_name)
{
   buffer_obj* self = (buffer_obj*)CheckMemLeak_Malloc(sizeof(buffer_obj), fname, line, func_name);

    self->mBuffer = MALLOC(first_size);
    self->mPointer = self->mBuffer;
    self->mBufferSize = first_size;

   return self;
}

#else

buffer_obj* buffer_new(int first_size)
{
    buffer_obj* self = (buffer_obj*)MALLOC(sizeof(buffer_obj));

    self->mBuffer = (char*)MALLOC(first_size);
    self->mPointer = self->mBuffer;
    self->mBufferSize = first_size;

   return self;
}

#endif

//////////////////////////////////////////////////////////////////////
// 消去
//////////////////////////////////////////////////////////////////////
void buffer_delete(buffer_obj* self)
{
    FREE(self->mBuffer);
    FREE(self);
}

void buffer_add_int(buffer_obj* self, int n)
{
    while(self->mPointer + sizeof(int)
            >= self->mBuffer + self->mBufferSize) 
    {
        self->mBufferSize = self->mBufferSize * 2;
        self->mBuffer = REALLOC(self->mBuffer, self->mBufferSize);
    }

    int* p = (int*)self->mPointer;
    *p = n;
    p++;
    self->mPointer = p;
}

void buffer_add_char(buffer_obj* self, char c)
{
    while(self->mPointer + sizeof(char)
            >= self->mBuffer + self->mBufferSize) 
    {
        self->mBufferSize = self->mBufferSize * 2;

        self->mBuffer = REALLOC(self->mBuffer, self->mBufferSize);
    }

    char* p = (char*)self->mPointer;
    *p = c;
    p++;
    self->mPointer = p;
}

/// ヌル終端文字列を追加
void buffer_add_pchar(buffer_obj* self, char* str)
{
    int size = strlen(str);

    while(self->mPointer + size
            >= self->mBuffer + self->mBufferSize) 
    {
        self->mBufferSize = self->mBufferSize * 2;
        self->mBuffer = REALLOC(self->mBuffer, self->mBufferSize);
    }

    char* p = self->mPointer;
    memcpy(p, str, size);
    p += size;
    self->mPointer = p;
}
/*
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>

int main()
{
    buffer_obj* buffer = BUFFER_NEW(1);

    printf("size %d\n", buffer->mBufferSize);
    buffer_add_pchar(buffer, "ab");

    printf("size %d\n", buffer->mBufferSize);
    buffer_add_char(buffer, 'A');

    printf("size %d\n", buffer->mBufferSize);
    buffer_add_int(buffer, 1);

    printf("size %d\n", buffer->mBufferSize);

    int fd = open("aaa", O_TRUNC|O_CREAT|O_WRONLY);
    if(write(fd, buffer->mBuffer, 8) < 0) {
        perror("write");
        exit(1);
    }

    close(fd);

    char* p = buffer->mBuffer;

    printf("char %c\n", *((char*)p));
    p++;
    printf("char %c\n", *((char*)p));
    p++;
    printf("char %c\n", *((char*)p));
    p++;

    int n = *((int*)p);
    printf("int %d\n", n);
    p+=sizeof(int)/sizeof(char);

    exit(0);
}
*/
