/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkaaddressmanager.h"
#include "kkaaddressmanagerjp.h"

#include <kinputdialog.h>
#include <klocale.h>
#include <kconfig.h>
#include <kdebug.h>

using namespace KKAddressBook;

KKAAddressManager* KKAAddressManager::manager( const QString& country )
{
	if( m_manager.contains( country ) ) return m_manager[country];

	if( country == "jp" )
	{
		m_manager[country] = new KKAAddressManagerJP();
		return m_manager[country];
	}
	else
	{
		if( !m_manager.contains( "C" ) )
		{
			m_manager["C"] = new KKAAddressManager();
		}
	}
	return m_manager["C"];
}

void KKAAddressManager::destruct()
{
		QMap<QString,KKAAddressManager*>::Iterator it;
		for ( it = m_manager.begin(); it != m_manager.end(); ++it )
		{
			delete m_manager[it.key()];
		}
}

KKAAddressManager::KKAAddressManager()
{
	readConfig();
}

KKAAddressManager::~KKAAddressManager()
{
	saveConfig();
}

bool KKAAddressManager::setup( QWidget* parent )
{
	bool ok;
	QString str = KInputDialog::getText( i18n( "Setup" ), i18n( "Input zipcode mask" ), m_mask, &ok, parent );
	if( ok )
	{
		m_mask = str;
	}
	return ok;
}

void KKAAddressManager::readConfig()
{
	readConfig( KGlobal::config() );
}

void KKAAddressManager::readConfig( KConfig* conf )
{
	conf->setGroup( "KKAAddressManager" );
	m_mask = conf->readEntry( "mask", QString::null );
}

void KKAAddressManager::saveConfig()
{
	saveConfig( KGlobal::config() );
}

void KKAAddressManager::saveConfig( KConfig* conf )
{
	conf->setGroup( "KKAAddressManager" );
	conf->writeEntry( "mask", m_mask );
}
