/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKAItem_H_
#define _KKAItem_H_

#include <klistview.h>

#include <qdom.h>

namespace KKAddressBook
{
	/**
	 * @short Base Class of KKAGroup And KKAPerson
	 * @author SUZUKI Tasuku <tasuku@linux-life.net>
	 */
	class KKAItem : public QObject, public KListViewItem
	{
		Q_OBJECT
	public:
		KKAItem( KListView* parent );
		KKAItem( KListViewItem* parent );

		static const char* tagName();
		virtual void readData( QDomNode node );
		virtual QDomElement saveData( QDomDocument& doc ) = 0;

	protected:
		virtual void readChildEach( QDomNode node ) = 0;
		void saveData( QDomDocument& doc, QDomElement& parent );
	};
}

#endif /* _KKAItem_H_ */
