/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKAKABC_H_
#define _KKAKABC_H_

#include <kabc/address.h>
#include <kabc/addressee.h>
#include "kkaaddressdata.h"

namespace KKAddressBook
{
	class KKAContactData;
	class KKATreeView;
	/**
	 * @author SUZUKI Tasuku
	 */
	class KKAKABC
	{
		public:
			static void doImport( KKATreeView* tvw );
			static void doExport( KKATreeView* tvw );
		
		private:
			static int getGroupNo( KKATreeView* tvw, const QString& basename );
			static void setData( KKAContactData* to, const KABC::Addressee& from );
			static void setAddress( KKAAddressData* to, KABC::Address from );
	};
}

#endif /* _KKAKABC_H_ */
