/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKAPRINTSTATUSWIDGET_H_
#define _KKAPRINTSTATUSWIDGET_H_

#include <qhbuttongroup.h>

#include "kkaaddressdata.h"

namespace KKAddressBook
{
	/**
	@author SUZUKI Tasuku
	*/
	class KKAPrintStatusWidget : public QHButtonGroup
	{
		Q_OBJECT
	public:
		KKAPrintStatusWidget( QWidget* parent = 0, const char* name = 0 );

		~KKAPrintStatusWidget();
		KKAAddressData::PrintStatus status() const
		{
			return (KKAAddressData::PrintStatus)selectedId();
		}

	public slots:
		void setStatus( KKAAddressData::PrintStatus s )
		{
			if( selectedId() == (int)s ) return;
			setButton( (int)s );
			emit statusChanged( s );
		}

	signals:
		void statusChanged( KKAAddressData::PrintStatus );

	private slots:
		void buttonClicked( int i );
	};
}
#endif
