/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kreetingkard.h"
#include "kkwidgetbase.h"
#include "kksender/kkswidget.h"
#include "kktemplate/kktwidget.h"
#include "kkdesigner/kkdwidget.h"
#include "kkaddressbook/kkawidget.h"

#include <qhbox.h>
#include <qvbox.h>
#include <qscrollview.h>
#include <qsplitter.h>

#include <klocale.h>
#include <klistview.h>

#include <kconfig.h>
#include <kiconloader.h>
#include <kaction.h>
#include <kdebug.h>
#include <kstatusbar.h>
#include <kjanuswidget.h>
#include <kcommand.h>

KreetingKard::KreetingKard()
	: KMainWindow( 0, "KreetingKard" )
{
	QFrame* page;
	m_currentIndex = 0;
// 	setMinimumSize( 600, 450 );
	m_base = new KJanusWidget( this, 0, KJanusWidget::IconList );
	m_base->setIconListAllVisible( false );
	m_cmdHistory = new KCommandHistory( actionCollection() );
	
	//BEGIN Template Tab
	page = m_base->addVBoxPage( i18n( "Templates" ), i18n( "Select a template" ), DesktopIcon( "kreetingkard_templates" ) );
	KKTemplate::KKTWidget* wgt_t = new KKTemplate::KKTWidget( m_cmdHistory, page );
	connect( wgt_t, SIGNAL( captionChanged( const QString& ) ), this, SLOT( setCaption( const QString& ) ) );
	m_pane.append( wgt_t );
	//END Template Tab

	//BEGIN Design Tab
	page = m_base->addVBoxPage( i18n( "Designer" ), i18n( "Design it" ), DesktopIcon( "kreetingkard" ) );
	KKDesigner::KKDWidget* wgt_d = new KKDesigner::KKDWidget( m_cmdHistory, page );
	connect( wgt_d, SIGNAL( captionChanged( const QString& ) ), this, SLOT( setCaption( const QString& ) ) );
	m_pane.append( wgt_d );
	//END Design Tab

	//BEGIN AddressBookTab
	page = m_base->addVBoxPage( i18n( "AddressBook" ), i18n( "AddressBook" ), DesktopIcon( "kreetingkard_address" ) );
	KKAddressBook::KKAWidget* wgt_a = new KKAddressBook::KKAWidget( m_cmdHistory, page );
	connect( wgt_a, SIGNAL( captionChanged( const QString& ) ), this, SLOT( setCaption( const QString& ) ) );
	m_pane.append( wgt_a );
	//END Address Book Tab

	//BEGIN Sender Tab
	page = m_base->addVBoxPage( i18n( "Sender" ), i18n( "Sender Info" ), DesktopIcon( "sender" ) );
	KKSender::KKSWidget* wgt_s = new KKSender::KKSWidget( m_cmdHistory, page );
	connect( wgt_s, SIGNAL( captionChanged( const QString& ) ), this, SLOT( setCaption( const QString& ) ) );
	m_pane.append( wgt_s );
	//END Sender Tab

	wgt_s->setDocument( wgt_d->document() );
	wgt_a->setDocument( wgt_d->document() );

	wgt_d->setSender( wgt_s->sender() );
	wgt_a->setSender( wgt_s->sender() );
	
	connect( wgt_t, SIGNAL( open( const QString& ) ), this, SLOT( fileNew( const QString& ) ) );
	connect( wgt_d, SIGNAL( openTemplate() ), wgt_t, SLOT( open() ) );

	connect( m_base, SIGNAL( aboutToShowPage( QWidget* ) ), this, SLOT( activeIndexChanged( QWidget* ) ) );

	statusBar()->insertItem( "", 0, 1 );
	statusBar()->setSizeGripEnabled( true );

	setCentralWidget( m_base );

	KStdAction::quit( this, SLOT( close() ), actionCollection() );

	readConfig();
	activeIndexChanged();
}

KreetingKard::~KreetingKard()
{
	saveConfig();
}

void KreetingKard::readConfig()
{
	KConfig *conf = KGlobal::config();
	conf->setGroup("KreetingKard");
	m_currentIndex = conf->readNumEntry( "CurrentPage", 0 );
	m_base->showPage( m_currentIndex );
	applyMainWindowSettings( conf, "window" );
	KKWidgetBase* current = m_pane.at( m_currentIndex );
	for( KKWidgetBase* wgt = m_pane.first(); wgt; wgt = m_pane.next() )
	{
		wgt->readConfig( conf );
		wgt->tabChanged( wgt == current );
	}
}

void KreetingKard::saveConfig()
{
	KConfig *conf = KGlobal::config();
	conf->setGroup("KreetingKard");
	conf->writeEntry( "CurrentPage", m_currentIndex );
	saveMainWindowSettings( conf, "window" );
	for( KKWidgetBase* wgt = m_pane.first(); wgt; wgt = m_pane.next() )
	{
		wgt->saveConfig( conf );
	}
}

void KreetingKard::activeIndexChanged( QWidget* )
{
	m_pane.at( m_currentIndex )->tabChanged( false );
	m_currentIndex = m_base->activePageIndex();
	
	createGUI( m_pane.at( m_currentIndex )->xmlFile() );
	m_pane.at( m_currentIndex )->tabChanged( true );
}

bool KreetingKard::queryClose()
{
	for( KKWidgetBase* wgt = m_pane.first(); wgt; wgt = m_pane.next() )
	{
		if( !wgt->closable() ) return false;
	}
	return true;
}

/**
 * @english
 * Open file from templates.
 *
 * @param filename File name to open
 * @endenglish
 *
 * @japanese
 * テンプレートからファイルを開く
 *
 * @param filename 開くファイル名
 * @endjapanese
 */
void KreetingKard::fileNew( const QString& filename )
{
	((KKDesigner::KKDWidget*)m_pane.at( Designer ))->fileNew( filename );
	m_base->showPage( Designer );
	activeIndexChanged();
}

/**
 * @english
 * Open file from command line args ( maybe file.kk is double clicked ).
 *
 * @param filename File name to open
 * @endenglish
 *
 * @japanese
 * コマンドライン引数からファイルを開く（file.kkをダブルクリックした時など）
 *
 * @param filename 開くファイル名
 * @endjapanese
 */
void KreetingKard::fileOpen( const QString& filename )
{
	((KKDesigner::KKDWidget*)m_pane.at( Designer ))->fileOpen( filename, true );
	m_base->showPage( Designer );
	activeIndexChanged();
}

QPtrList<KKAddressBook::KKAContactData> KreetingKard::printData()
{
	return ((KKAddressBook::KKAWidget*)m_pane.at( AddressBook ))->printData();
}
