/***************************************************************************
 *   Copyright (C) 2004 by Stefan Kombrink                                 *
 *   katakombi@web.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ADJBORDERWIZARD_H

#define ADJBORDERWIZARD_H

#include "adjborderwizardbase.h"
#include <qevent.h>

class AdjBorderWizard : public AdjBorderWizardBase
{
  Q_OBJECT
  
  public:
    AdjBorderWizard();
    ~AdjBorderWizard();

  signals:
    void changed();
        
  protected:
    int measureBorderX();
    int measureBorderY();
    
    void mouseMoveEvent( QMouseEvent * );
    
    void next();
    void back();
    
    void accept();
    void reject();

    void clearMeasuredResults();

  protected slots:
    void saveState();
    void disableState();
    void restoreState();
  
    void allowProceed();

  
  signals:
    void measurementDone();
  
  private:
    // determines how many mouse move events should
    // be taken to calculate a good average
    static const int m_numOfMinSamples = 100;
    int m_avgX, m_avgY, m_evCnt;
    int m_X[4],m_Y[4];

    // information we have to store
    int m_vertDelta, m_horizDelta;
    bool m_circScrolling, m_edgeMotion;
};


#endif
