/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef CfgFile_H_Included
#define CfgFile_H_Included

#include <qobject.h>
#include <qstring.h>

#include <list>
#include <map>

#include "AutoPtr.h"

class QFile;

//
//
//
class ConfigItem
  {
    public:
      typedef AutoPtr<ConfigItem> Ptr;
      typedef std::list<Ptr>      List;


    private:
      QString       m_strName,
                    m_strValue;
      bool          m_bIsGroup,
                    m_bIsComment;

    public:
                    ConfigItem();
                    ConfigItem(QString strItem)   { readFrom(strItem); }

                    ConfigItem(const ConfigItem & item)
                    {
                        *this = item;
                    }

      bool          isGroup() const               { return m_bIsGroup; }
      void          setGroup(bool bGroup = true)  { m_bIsGroup = bGroup; }

      bool          isComment() const             { return m_bIsComment; }
      void          setComment(bool bComm = true) { m_bIsComment = bComm; }

      QString       getName() const               { return m_strName; }
      void          setName(QString strName)      { m_strName = strName; }

      QString       getValue() const              { return m_strValue; }
      void          setValue(QString strValue)    { m_strValue = strValue; }

      bool          isValid() const               { return !m_strName.isEmpty(); }

      bool          readFrom(QString strItem);

      ConfigItem &  operator = (const ConfigItem & item);
  };


class CfgGroup
  {
    public:
      typedef AutoPtr<CfgGroup>               Ptr;
      typedef std::list<CfgGroup>             List;

    private:
      typedef ConfigItem::Ptr                 CfgItemPtr;
      typedef std::map<QString, CfgItemPtr>   CfgItemMap;

    private:
      QString           m_strTag;
      QStringList       m_itemNames;
      CfgItemMap        m_itemMap;

    public:
                        CfgGroup  (QString strTag = "") { setTag(strTag); }
                        CfgGroup  (const CfgGroup & group);
      virtual         ~ CfgGroup  () {}

      QString           getTag    () const          { return m_strTag; }
      void              setTag    (QString strTag)  { m_strTag = strTag; }

      void              setValue  (QString strName, QString strValue);
      QString           getValue  (QString strName) const;
      CfgItemPtr        getItem   (QString strName) const;

      void              deleteItem(QString strName);

      virtual void      clear     () { m_itemMap.clear(); m_itemNames.clear(); }
      virtual QString   toString  () const;

      void              setOptions(QString strOptions);
      QString           getOptions(const char * pExcluding[] = 0) const;

      void              getItemNames(QStringList & strList) const { strList = m_itemNames; }

      CfgGroup &        operator = (const CfgGroup & group);
  };


class CfgFile : public QObject
  {
    Q_OBJECT

    public:
      typedef QStringList::ConstIterator      GroupIterator;

    protected:
      typedef CfgGroup::Ptr                   CfgGroupPtr;
      typedef ConfigItem::Ptr                 CfgItemPtr;
      typedef std::map<QString, CfgGroupPtr>  CfgGroupMap;

    private:
      CfgGroupMap       m_groupMap;
      QStringList       m_groupNames;


    public:
                        CfgFile(const char * pObjName = "CfgFile")
                          : QObject(0, pObjName)
                        {
                        }

      virtual         ~ CfgFile       () {}

      virtual void      setValue      (QString strGroup, QString strName, QString strValue);
      virtual QString   getValue      (QString strGroup, QString strName) const;
      CfgItemPtr        getItem       (QString strGroup, QString strName) const;

      QStringList &     getGroupList  (QStringList & groups) const;

      virtual
        CfgGroupPtr     getGroup      (QString strGroup) const;

      virtual void      addGroup      (CfgGroupPtr ptrGroup);

      bool              parse         (QFile & file);
      bool              parse         (const QString & strCfg);

      int               countGroups   () const { return m_groupNames.size(); }
      void              deleteGroup   (QString strGroup);
      virtual void      clear         () { m_groupMap.clear(); m_groupNames.clear(); }
      virtual QString   toString      () const;

      void              setOptions    (QString strOptions);
      QString           getOptions    () const;

      void              setOptions    (QString strGroup, QString strOptions);
      QString           getOptions    (QString strGroup, const char * pExcluding[] = 0) const;
  };

#endif
