/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KYumConf_H_Included
#define KYumConf_H_Included

#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>

#include <kurl.h>

#include "CfgFile.h"

class QFile;
class QMutex;

//
//
//
class Repo : public CfgGroup
  {
    public:
      typedef AutoPtr<Repo>   Ptr;
      typedef std::list<Ptr>  List;

   private:
      QString         m_strFileName;

   public:
                      Repo();
                      Repo(const CfgGroup & group, QString strFileName);
                      Repo(const Repo & repo);

      QString         getFileName() const               { return m_strFileName; }
      void            setFileName(QString strFileName)  { m_strFileName = strFileName; }

      QString         getName   () const                { return getValue("Name"); }
      void            setName   (QString strName)       { setValue("Name", strName); }

      KURL            getBaseURL() const                { return KURL(getValue("BaseURL")); }
      void            setBaseURL(const KURL & url)      { setBaseURL(url.url()); }
      void            setBaseURL(QString strURL)        { setValue("BaseURL", strURL); }

      QString         getMirrorList() const             { return getValue("MirrorList"); }
      void            setMirrorList(QString strMirrors) { setValue("MirrorList", strMirrors); }

      void            setEnabled(bool bEnabled = true)  { setValue("enabled",  bEnabled? "1" : "0"); }
      void            setGPGCheck(bool bCheck = true)   { setValue("gpgcheck", bCheck? "1" : "0"); }

      bool            isEnabled() const                 { return getValue("enabled") == "1"; }
      bool            isGPGCheckOn() const              { return getValue("gpgcheck") == "1"; }

      QString         getOtherOptions() const;

      void            clear();

      QString         toString() const;

      bool            isValid() const { return !getTag().isEmpty() && !getName().isEmpty(); }

      void            copyFrom(const Repo & repo);
  };


//
//
//
class RepoFile
  {
    public:
      typedef AutoPtr<RepoFile>     Ptr;
      typedef std::list<Ptr>        List;
      typedef List::iterator        ListIterator;
      typedef List::const_iterator  ConstListIterator;


    private:
      QString           m_strFileName;
      Repo::List        m_repos;


    private:
      bool              parse(QFile & file);

    public:
                        RepoFile();
                        RepoFile(QString strFileName);

      QString           getFileName() const               { return m_strFileName; }
      void              setFileName(QString strFile)      { m_strFileName = strFile; }

      Repo::List &      getRepos()                        { return m_repos; }

      const
      Repo::List &      getRepos() const                  { return m_repos; }

      void              addRepo(Repo::Ptr ptrRepo);
      Repo::Ptr         findRepo    (QString strTag) const;
      void              deleteRepo  (QString strTag);
      int               countRepos  () const              { return m_repos.size(); }

      bool              load();
      bool              save();

      QString           toString() const;
  };


//
//
class KYumConf : public CfgFile
  {
    Q_OBJECT

    private:
      RepoFile::List    m_repoFiles;

    enum ProfileSection
      {
        c_SectionNone,
        c_SectionYumConf,
        c_SectionRepos
      };

    private:
      bool              parseProfileSection(ProfileSection section, QString strProfile);

      Repo::Ptr         pvtFindRepo (QString   strTag,
                                     QString * pStrFileName = 0) const;

    public:
                        KYumConf    ();
      virtual         ~ KYumConf    ();

      bool              loadMainCfg ();
      bool              loadAll     ();
      bool              saveMainCfg ();
      bool              loadRepos   ();
      bool              saveAll     ();
      bool              saveRepos   ();
      bool              saveRepo    (Repo::Ptr ptrRepo);

      QString           getRepoDir  () const;

      Repo::Ptr         findRepo    (QString   strTag,
                                     QString * pStrFileName = 0) const;

      RepoFile::List &  getRepoFiles()        { return m_repoFiles; }

      const
      RepoFile::List &  getRepoFiles() const  { return m_repoFiles; }

      RepoFile::Ptr     getFileWithRepo(Repo::Ptr ptrRepo) const;

      bool              addRepo(Repo::Ptr ptrRepo, QString & strRepoFile);
      bool              parseAndAddRepo(QString strProfile);

      void              deleteRepo  (Repo::Ptr ptrRepo);

      void              moveReposToRepoFile();

      QString           getLogFile  () const;
      QString           getDistroVerPkg() const;

      bool              saveProfile(QString strFileName);
      bool              loadProfile(QString strFileName);
      bool              loadProfile(QFile & file);

    signals:
      void              mainCfgLoaded ();
      void              mainCfgSaved  ();
      void              reposLoaded   ();
  };

#endif
