/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <stdlib.h>
#include <math.h>

#include <qregexp.h>

#include "StrTok.h"
#include "PackageInfo.h"


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

double PackageInfo::getPkgSize() const
{
    double size = 0.0;

    if ( 0 < m_strSize.length() )
    {
        StrTok  strTok(m_strSize);
        QString strUnit;

        strTok.nextToken(' ', strUnit);
        size = strtod(strUnit, 0);

        if ( strTok.nextToken(' ', strUnit) && !strUnit.isEmpty() )
        {
            switch ( strUnit[0].cell() )
            {
              case 'K':
              case 'k':  size /= 1024.0;
                         break;

              case 'M':
              case 'm':  /**/
                         break;

              case 'G':
              case 'g':  size *= 1024.0;
                         break;

              case 'B':
              case 'b':  size /= 1024.0 * 1024.0;
                         break;
            }
        }
    }

    double fract = floor((size - floor(size)) * 100.0 + 0.5) / 100.0;

    return floor(size) + fract;
}


/***************************************************************************/
/**
 *  Tries to get package information (package name, version, repository,
 *  and architecture) from a single line of yum's output. This is meant
 *  to be used for those yum commands that return one line of information
 *  per package (i.e. NOT the 'info' command).
 *
 ***************************************************************************/

bool PackageInfo::getFromLine(QString strLine)
{
    bool      bSuccess = false;
    QRegExp   sep("(\t| )+");
    StrTok    strTok(strLine);

    strTok.nextToken(sep, m_strName);
    strTok.skipWhitespace();

    strTok.nextToken(sep, m_strVersion);
    strTok.skipWhitespace();

    strTok.nextToken(sep, m_strRepoTag);
    strTok.skipWhitespace();

    if ( !m_strName.isEmpty() && !m_strVersion.isEmpty() && !m_strRepoTag.isEmpty() )
    {
        int     pos = m_strName.findRev('.');
        QString strArch;

        if ( 0 < pos )
        {
            m_strArch = m_strName.mid(pos + 1);
            m_strName = m_strName.mid(0, pos);
        }

        bSuccess = isValid();
    }

    return bSuccess;
}


