/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef YumConfView_h
#define YumConfView_h

#include <qthread.h>
#include <qfileinfo.h>

#include <ktextedit.h>


class YumConfView : public KTextEdit, public QThread
  {
    Q_OBJECT

    private:
      bool          m_bExitRequested,
                    m_bDirty;
      QMutex        m_mutex;
      QFileInfo     m_cfgFileInfo;

    public:
                    YumConfView   (QWidget * pParent);
      virtual     ~ YumConfView   ();

      bool          startThread   ();
      void          stopThread    ()        { m_bExitRequested = true; }
      bool          exitRequested () const  { return m_bExitRequested; }

      bool          isDirty       () const  { return m_bDirty; }

      void          cfgFileChanged();
      virtual bool  event         (QEvent * pEvent);

    signals:
      void          configSaved   (const QString & strConfig);

    public slots:
      virtual bool  close         ();
      virtual void  configLoaded  ();
      virtual void  configSaved   ();
      virtual void  configChanged (bool bDirty);

    protected:
      void          run           ();
  };

#endif
