/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.util.LittleEndian;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RecordInputStream
extends InputStream {
    public static final short MAX_RECORD_DATA_SIZE = 8224;
    private InputStream in;
    protected short currentSid;
    protected short currentLength;
    protected short nextSid;
    protected byte[] data;
    protected short recordOffset;
    protected long pos;
    private boolean autoContinue;
    byte[] NAN_data;

    public int read() throws IOException {
        this.checkRecordPosition();
        byte result = this.data[this.recordOffset];
        this.recordOffset = (short)(this.recordOffset + 1);
        ++this.pos;
        return result;
    }

    public short getSid() {
        return this.currentSid;
    }

    public short getLength() {
        return this.currentLength;
    }

    public short getRecordOffset() {
        return this.recordOffset;
    }

    public long getPos() {
        return this.pos;
    }

    public boolean hasNextRecord() {
        boolean bl = false;
        if (this.nextSid != 0) {
            bl = true;
        }
        return bl;
    }

    public void nextRecord() throws RecordFormatException {
        if (this.currentLength != -1 && this.currentLength != this.recordOffset) {
            System.out.println("WARN. Unread " + this.remaining() + " bytes of record 0x" + Integer.toHexString(this.currentSid));
        }
        this.currentSid = this.nextSid;
        this.pos += (long)2;
        this.autoContinue = true;
        try {
            this.recordOffset = 0;
            this.currentLength = LittleEndian.readShort(this.in);
            if (this.currentLength > 8224) {
                throw new RecordFormatException("The content of an excel record cannot exceed 8224 bytes");
            }
            this.pos += (long)2;
            this.in.read(this.data, 0, this.currentLength);
            this.nextSid = LittleEndian.readShort(this.in);
        }
        catch (IOException ex) {
            throw new RecordFormatException("Error reading bytes", ex);
        }
    }

    public void setAutoContinue(boolean enable) {
        this.autoContinue = enable;
    }

    public boolean getAutoContinue() {
        return this.autoContinue;
    }

    protected void checkRecordPosition() {
        if (this.remaining() <= 0) {
            if (this.isContinueNext() && this.autoContinue) {
                this.nextRecord();
            } else {
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    public byte readByte() {
        this.checkRecordPosition();
        byte result = this.data[this.recordOffset];
        this.recordOffset = (short)(this.recordOffset + 1);
        ++this.pos;
        return result;
    }

    public short readShort() {
        this.checkRecordPosition();
        short result = LittleEndian.getShort(this.data, this.recordOffset);
        this.recordOffset = (short)(this.recordOffset + 2);
        this.pos += (long)2;
        return result;
    }

    public int readInt() {
        this.checkRecordPosition();
        int result = LittleEndian.getInt(this.data, this.recordOffset);
        this.recordOffset = (short)(this.recordOffset + 4);
        this.pos += (long)4;
        return result;
    }

    public long readLong() {
        this.checkRecordPosition();
        long result = LittleEndian.getLong(this.data, this.recordOffset);
        this.recordOffset = (short)(this.recordOffset + 8);
        this.pos += 8L;
        return result;
    }

    public int readUShort() {
        this.checkRecordPosition();
        int result = LittleEndian.getUShort(this.data, this.recordOffset);
        this.recordOffset = (short)(this.recordOffset + 2);
        this.pos += (long)2;
        return result;
    }

    public double readDouble() {
        this.checkRecordPosition();
        this.NAN_data = null;
        double result = LittleEndian.getDouble(this.data, this.recordOffset);
        if (Double.isNaN(result)) {
            this.NAN_data = new byte[8];
            System.arraycopy(this.data, this.recordOffset, this.NAN_data, 0, 8);
        }
        this.recordOffset = (short)(this.recordOffset + 8);
        this.pos += 8L;
        return result;
    }

    public byte[] getNANData() {
        if (this.NAN_data == null) {
            throw new RecordFormatException("Do NOT call getNANData without calling readDouble that returns NaN");
        }
        return this.NAN_data;
    }

    public short[] readShortArray() {
        this.checkRecordPosition();
        short[] arr = LittleEndian.getShortArray(this.data, this.recordOffset);
        int size = 2 * (arr.length + 1);
        this.recordOffset = (short)(this.recordOffset + size);
        this.pos += (long)size;
        return arr;
    }

    public String readUnicodeLEString(int length) {
        if (length < 0 || this.remaining() / 2 < length && !this.isContinueNext()) {
            throw new IllegalArgumentException("Illegal length");
        }
        StringBuffer buf = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            if (this.remaining() == 0 && this.isContinueNext()) {
                this.nextRecord();
            }
            char ch = (char)this.readShort();
            buf.append(ch);
            ++i;
        }
        return buf.toString();
    }

    public String readCompressedUnicode(int length) {
        if (length < 0 || this.remaining() < length) {
            throw new IllegalArgumentException("Illegal length");
        }
        StringBuffer buf = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            if (this.remaining() == 0 && this.isContinueNext()) {
                this.nextRecord();
            }
            byte b = this.readByte();
            char ch = (char)(0xFF & b);
            buf.append(ch);
            ++i;
        }
        return buf.toString();
    }

    public UnicodeString readUnicodeString() {
        return new UnicodeString(this);
    }

    public byte[] readRemainder() {
        int size = this.remaining();
        byte[] result = new byte[size];
        System.arraycopy(this.data, this.recordOffset, result, 0, size);
        this.recordOffset = (short)(this.recordOffset + size);
        this.pos += (long)size;
        return result;
    }

    public byte[] readAllContinuedRemainder() {
        byte[] b;
        ByteArrayOutputStream out = new ByteArrayOutputStream(16448);
        while (this.isContinueNext()) {
            b = this.readRemainder();
            out.write(b, 0, b.length);
            this.nextRecord();
        }
        b = this.readRemainder();
        out.write(b, 0, b.length);
        return out.toByteArray();
    }

    public int remaining() {
        return this.currentLength - this.recordOffset;
    }

    public boolean isContinueNext() {
        boolean bl = false;
        if (this.nextSid == 60) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.currentLength = (short)-1;
        this.nextSid = (short)-1;
        this.data = new byte[8224];
        this.autoContinue = true;
        this.NAN_data = null;
    }

    public RecordInputStream(InputStream in) throws RecordFormatException {
        this.this();
        this.in = in;
        try {
            this.nextSid = LittleEndian.readShort(in);
        }
        catch (IOException ex) {
            throw new RecordFormatException("Error reading bytes", ex);
        }
    }
}

