/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UnknownRecord
extends Record {
    private short sid;
    private byte[] thedata;

    public int serialize(int offset, byte[] data) {
        if (this.thedata == null) {
            this.thedata = new byte[0];
        }
        LittleEndian.putShort(data, offset, this.sid);
        LittleEndian.putShort(data, 2 + offset, (short)this.thedata.length);
        if (this.thedata.length > 0) {
            System.arraycopy(this.thedata, 0, data, 4 + offset, this.thedata.length);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int retval = 4;
        if (this.thedata != null) {
            retval += this.thedata.length;
        }
        return retval;
    }

    protected void fillFields(byte[] data, short sid) {
        this.sid = sid;
        this.thedata = data;
    }

    protected void validateSid(short id) {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[UNKNOWN RECORD:" + Integer.toHexString(this.sid) + "]\n");
        buffer.append("    .id        = ").append(Integer.toHexString(this.sid)).append("\n");
        buffer.append("[/UNKNOWN RECORD]\n");
        return buffer.toString();
    }

    public short getSid() {
        return this.sid;
    }

    protected void fillFields(RecordInputStream in) {
        throw new RecordFormatException("Unknown record cannot be constructed via offset -- we need a copy of the data");
    }

    public Object clone() {
        UnknownRecord rec = new UnknownRecord();
        rec.sid = this.sid;
        rec.thedata = this.thedata;
        return rec;
    }

    private final /* synthetic */ void this() {
        this.sid = 0;
        this.thedata = null;
    }

    public UnknownRecord() {
        this.this();
    }

    public UnknownRecord(short id, byte[] data) {
        this.this();
        this.sid = id;
        this.thedata = data;
    }

    public UnknownRecord(RecordInputStream in) {
        this.this();
        this.sid = in.getSid();
        this.thedata = in.readRemainder();
    }
}

