/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.record.PaletteRecord;
import org.apache.poi.hssf.util.HSSFColor;

public class HSSFPalette {
    private PaletteRecord palette;

    public HSSFColor getColor(short index) {
        if (index == 64) {
            return HSSFColor.AUTOMATIC.getInstance();
        }
        byte[] b = this.palette.getColor(index);
        if (b != null) {
            return new CustomColor(index, b);
        }
        return null;
    }

    public HSSFColor findColor(byte red, byte green, byte blue) {
        byte[] b = this.palette.getColor((short)8);
        short i = 8;
        while (b != null) {
            if (b[0] == red && b[1] == green && b[2] == blue) {
                return new CustomColor(i, b);
            }
            short s = (short)(i + 1);
            i = s;
            b = this.palette.getColor(s);
        }
        return null;
    }

    public HSSFColor findSimilarColor(byte red, byte green, byte blue) {
        HSSFColor result = null;
        int minColorDistance = Integer.MAX_VALUE;
        byte[] b = this.palette.getColor((short)8);
        short i = 8;
        while (b != null) {
            int colorDistance = red - b[0] + green - b[1] + blue - b[2];
            if (colorDistance < minColorDistance) {
                result = this.getColor(i);
            }
            i = (short)(i + 1);
            b = this.palette.getColor(i);
        }
        return result;
    }

    public void setColorAtIndex(short index, byte red, byte green, byte blue) {
        this.palette.setColor(index, red, green, blue);
    }

    public HSSFColor addColor(byte red, byte green, byte blue) {
        byte[] b = this.palette.getColor((short)8);
        short i = 8;
        while (i < 64) {
            if (b == null) {
                this.setColorAtIndex(i, red, green, blue);
                return this.getColor(i);
            }
            i = (short)(i + 1);
            b = this.palette.getColor(i);
        }
        throw new RuntimeException("Could not find free color index");
    }

    protected HSSFPalette(PaletteRecord palette) {
        this.palette = palette;
    }

    private static class CustomColor
    extends HSSFColor {
        private short byteOffset;
        private byte red;
        private byte green;
        private byte blue;

        public short getIndex() {
            return this.byteOffset;
        }

        public short[] getTriplet() {
            return new short[]{(short)(this.red & 0xFF), (short)(this.green & 0xFF), (short)(this.blue & 0xFF)};
        }

        public String getHexString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getGnumericPart(this.red));
            sb.append(':');
            sb.append(this.getGnumericPart(this.green));
            sb.append(':');
            sb.append(this.getGnumericPart(this.blue));
            return sb.toString();
        }

        private final String getGnumericPart(byte color) {
            String s;
            if (color == 0) {
                s = "0";
            } else {
                int c = color & 0xFF;
                c = c << 8 | c;
                s = Integer.toHexString(c).toUpperCase();
                while (s.length() < 4) {
                    s = "0" + s;
                }
            }
            return s;
        }

        private CustomColor(short byteOffset, byte[] colors) {
            this(byteOffset, colors[0], colors[1], colors[2]);
        }

        private CustomColor(short byteOffset, byte red, byte green, byte blue) {
            this.byteOffset = byteOffset;
            this.red = red;
            this.green = green;
            this.blue = blue;
        }
    }
}

