/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.util;

import org.apache.poi.hssf.record.MergeCellsRecord;

public class Region
implements Comparable {
    private int rowFrom;
    private short colFrom;
    private int rowTo;
    private short colTo;

    public short getColumnFrom() {
        return this.colFrom;
    }

    public int getRowFrom() {
        return this.rowFrom;
    }

    public short getColumnTo() {
        return this.colTo;
    }

    public int getRowTo() {
        return this.rowTo;
    }

    public void setColumnFrom(short colFrom) {
        this.colFrom = colFrom;
    }

    public void setRowFrom(int rowFrom) {
        this.rowFrom = rowFrom;
    }

    public void setColumnTo(short colTo) {
        this.colTo = colTo;
    }

    public void setRowTo(int rowTo) {
        this.rowTo = rowTo;
    }

    public boolean contains(int row, short col) {
        return this.rowFrom <= row && this.rowTo >= row && this.colFrom <= col && this.colTo >= col;
    }

    public boolean equals(Region r) {
        boolean bl = false;
        if (this.compareTo(r) == 0) {
            bl = true;
        }
        return bl;
    }

    public int compareTo(Region r) {
        if (this.getRowFrom() == r.getRowFrom() && this.getColumnFrom() == r.getColumnFrom() && this.getRowTo() == r.getRowTo() && this.getColumnTo() == r.getColumnTo()) {
            return 0;
        }
        if (this.getRowFrom() < r.getRowFrom() || this.getColumnFrom() < r.getColumnFrom() || this.getRowTo() < r.getRowTo() || this.getColumnTo() < r.getColumnTo()) {
            return 1;
        }
        return -1;
    }

    public int compareTo(Object o) {
        return this.compareTo((Region)o);
    }

    public int getArea() {
        return (1 + (this.getRowTo() - this.getRowFrom())) * (1 + (this.getColumnTo() - this.getColumnFrom()));
    }

    public Region() {
    }

    public Region(int rowFrom, short colFrom, int rowTo, short colTo) {
        this.rowFrom = rowFrom;
        this.rowTo = rowTo;
        this.colFrom = colFrom;
        this.colTo = colTo;
    }

    public Region(MergeCellsRecord.MergedRegion region) {
        this(region.row_from, region.col_from, region.row_to, region.col_to);
    }
}

