#!/usr/bin/env bash

#*****************************************************************************
# xtcross.sh version 1.0.0
# ץǡκ
# Y.Hamuro
# 2003/01/07
#*****************************************************************************

#顼å
function help {
cat >/dev/stderr <<EOF
------------------------
xtcross.sh version 1.0.0
------------------------
)ɽ롣
) xtcross.sh -k Ԥˤʤ̾ -f ˤʤ̾ -d ͤι̾ [-iե] [-oϥե̾] [-T ǥ쥯ȥ̾]

) xtcross.sh -k ܵ -f ʬ -d  -i dat.xt -o rsl.xt
EOF
exit 1
}

#ѥ᡼Υåå
  rName='fold##.data'
  sName='fold##.test'
  while getopts ":k:f:d:i:o:h" opt; do
    case $opt in
      k  ) row=$OPTARG ;;
      f  ) col=$OPTARG ;;
      d  ) dat=$OPTARG ;;
      i  ) input=$OPTARG ;;
      o  ) output=$OPTARG ;;
      T  ) tmpD=$OPTARG ;;
      h  ) help ;;
      \? ) help ;;
    esac
  done
  shift $(($OPTIND -1 ))

  if [ "$tmpD" = "" ]; then
     tmpD=/tmp
  fi
  if [ "$input" = "" ]; then
     input=/dev/stdin
  fi
  if [ "$output" = "" ]; then
     output=/dev/stdout
  fi
  if [ "$row" = "" ]; then
     help; exit 1
  fi
  if [ "$col" = "" ]; then
     help; exit 1
  fi
  if [ "$dat" = "" ]; then
     help; exit 1
  fi

TD=$tmpD/xxx$$
mkdir -p $TD

#ɬ׹ܤڤФtmpե¸
xtcut -f $row,$col,$dat -i $input -o $TD.a

#ˡܵҤΥꥹȺ
xtcut -f $row -i $TD.a |
xtuniq -k $row -o $TD.cust

#ˡʬꥹȤκ -> ץȺ
xtcut -f $col -i $TD.a |
xtuniq -k $col |
xt2txt |
gawk '{print "joinCls",$1}' > $TD.sh

#ʬ˥եʬ䤹
xtsep -d $TD.sep.'$('$col')' -i $TD.a

#ʬΥեܵҤ򥭡joinؿ
function joinCls {
  xtjoin -n -k $row -m $TD.sep.$1 -f $dat:$1 -i $TD.cust -o $TD.p
  cp $TD.p $TD.cust
}

#ǥץȼ¹
. $TD.sh

cat <$TD.cust >$output

rm -rf $tmpD/xxx*
#===============================================================
