#!/usr/bin/env bash

#*****************************************************************************
# xtnfold version 1.0.2
# 交差検定用のデータセットの作成
# T.Nakahara
# 2002/01/12
# Y.Hamuro
# 2002/01/29 -tの追加, -dのディレクトリが最後/で終っている必用をなくす
# 2003/02/03 現在のコマンドに対応(1.0.1)
# 2004/01/21 top行 /bin/bash -> /usr/bin/env bash に変更(増田氏のご指摘)
# 2004/01/21 ヘルプでバージョン情報を表示するように変更(1.0.2)
#*****************************************************************************
#エラーメッセージ
function help {
cat >/dev/stderr <<EOF
------------------------
xtnfold.sh version 1.0.2
------------------------
概要) 交差検定用のデータセットを作成する。
書式) xtnfold.sh -iファイル -d出力ディレクトリ -nfold数 -cクラス項目 -S 乱数の種 [-t] [-oトレーニングファイル名] [-Oテストファイル名]
例) xtnfold.sh -i dat -d fold -n 5 -c Class -o fold##.train -O fold##.test
EOF
exit 1
}

#パラメータのセット
  rName='fold##.data'
  sName='fold##.test'
  while getopts ":i:d:n:c:S:k:o:O:th" opt; do
    case $opt in
      i  ) input=$OPTARG ;;
      d  ) path=$OPTARG ;;
      n  ) fold=$OPTARG ;;
      c  ) cls=$OPTARG ;;
      S  ) sed=$OPTARG ;;
      o  ) rName=$OPTARG ;;
      O  ) sName=$OPTARG ;;
      t  ) txt=1 ;;
      h  ) help ;;
      \? ) help ;;
    esac
  done
  shift $(($OPTIND -1 ))

  if [ "$input" = "" ]; then
     help; exit 1
  fi
  if [ "$path" = "" ]; then
     help; exit 1
  fi
  if [ "$fold" = "" ]; then
     help; exit 1
  fi
  if [ "$cls" = "" ]; then
     help; exit 1
  fi
  if [ "$sed" = "" ]; then
     sed=-1
  fi
  if [ "$rName" = "" ]; then
     help; exit 1
  fi
  if [ "$sName" = "" ]; then
     help; exit 1
  fi

#トレーニングとテストの同一名チェック
  if [ "$rName" = "$sName" ]; then
    echo 'file names for training and test must be different'
    exit 1
  fi

#入力ファイルチェック
  if [ ! -f $input ]; then
     echo 'file not found : '$input; exit 1
  fi

#-dのおけつ"/"をとる
path=`echo $path | sed 's/\/*$//'`

#ワークファイルのプレフィックスの設定
wf=/tmp/xt##$$-xtnfold

#テキストの場合、xmlTableに変換する
  if [ "$txt" = "1" ]; then
    fldCnt=`head -1 $input | gawk '{print NF}'`
    cnt=2
    fldName=1
    while [ $cnt -le $fldCnt ] ; do
      fldName=$fldName","$cnt
      cnt=$((cnt+1))
    done
    txt2xt -a $fldName -i $input -o $wf-01
    input=$wf-01
  fi

#出力ディレクトリが存在しないなら作成する
  if [ ! -d $path ]; then
     mkdir -p $path
  fi

#clsを分けるためにfold数にあわせてcls番号をふる
  xtrand -a rand -S $sed -i$input |
  xtcal  -k$cls -s rand%n -c 'down(keyLine()/(keyCnt()/'$fold'+0.00001),1)' -a val >$wf-03

#cls番号にあわせてそれぞれのファイルに出力する
  roop=0
  while [ "$roop" -lt "$fold" ]; do
    xtsel -c'$val -eq '$roop -i$wf-03\
          -u$wf-trn-$(($roop+1)) -o $wf-tst-$(($roop+1))
    roop=$((roop+1)) 
  done;

  roop=1
  while [ $roop -le $fold ] ; do
    trnName=`echo $rName | sed 's/##/'$roop'/'`
    tstName=`echo $sName | sed 's/##/'$roop'/'`
    tprName=$wf-trn-$roop
    tpsName=$wf-tst-$roop

    #テキストの場合、textに変換する
    if [ "$txt" = "1" ]; then
      xtcut -rfval,rand -i$tprName | xt2txt -o"$path"/$trnName
      xtcut -rfval,rand -i$tpsName | xt2txt -o"$path"/$tstName
    else 
      xtcut -rfval,rand -i$tprName -o"$path"/$trnName
      xtcut -rfval,rand -i$tpsName -o"$path"/$tstName
    fi
    roop=$((roop+1)) 
  done;

  rm $wf-*
  exit 0
