/*

Copyright (c) 2005 Red Hat Incorporated.
All rights reserved.

Redistribution and use in source and binary forms, with or without 
modification, are permitted provided that the following conditions are met: 

    Redistributions of source code must retain the above copyright 
    notice, this list of conditions and the following disclaimer.

    Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

    The name of Red Hat Incorporated may not be used to endorse 
    or promote products derived from this software without specific 
    prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.  IN NO EVENT SHALL RED HAT INCORPORATED BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND 
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

*/

#if defined(__r8c_cpu__) || defined(__m16c_cpu__)
#define A16
#define A(n,w) n
#define W w
#define ALIGN 1
#else
#define A24
#define A(n,w) w
#define W l
#define ALIGN 2
#endif

	.text

	.global _start
_start:
.LFB2:
	fset	U	/* User stack */
	ldc	#__stack,sp

#ifdef A16
	mov.b	#%hi8(__romdatastart),r1h
	mov.w	#%lo16(__romdatastart),a0
	mov.w	#__datastart,a1
#else
	mov.l	#__romdatastart,a0
	mov.l	#__datastart,a1
#endif
	mov.w	#__romdatacopysize,r3
	shl.w	#-1,r3
	smovf.w

#ifdef A16
	mov.w	#__bssstart,a1
#else
	mov.l	#__bssstart,a1
#endif
	mov.w	#__bsssize,r3
	shl.w	#-1,r3
	mov.w	#0,r0
	sstr.w

	jsr.a	__m32c_init

	jsr.a	_main
.LFE2:

#ifdef A24
	/* rv in r0, ok for arg0 */
#else
	mov.w	r0,r1
#endif

	jsr.a	_exit

	.text

	.global	_m32c_run_preinit_array
	.type	_m32c_run_preinit_array,@function
_m32c_run_preinit_array:
	mov.W	#__preinit_array_start,a0
	mov.W	#__preinit_array_end,a1
	jmp.w	_m32c_run_inilist

	.global	_m32c_run_init_array
	.type	_m32c_run_init_array,@function
_m32c_run_init_array:
	mov.W	#__init_array_start,a0
	mov.W	#__init_array_end,a1
	jmp.w	_m32c_run_inilist

	.global	_m32c_run_fini_array
	.type	_m32c_run_fini_array,@function
_m32c_run_fini_array:
	mov.W	#__fini_array_start,a0
	mov.W	#__fini_array_end,a1
	/* fall through */

_m32c_run_inilist:
next_inilist:
	cmp.W	a0,a1
	jeq	done_inilist
	pushm	a0,a1
	mov.W	[a0],a0
#ifdef A16
	mov.b:s	#0,a1	/* zero extends */
	jsri.a	a1a0
#else
	jsri.a	a0
#endif
	popm	a0,a1
	add.W	A(#2,#4),a0
	jmp.b	next_inilist
done_inilist:
	rts

	.section	.init,"ax",@progbits

	.global __m32c_init
__m32c_init:
	enter	#0

	.section	.fini,"ax",@progbits

	.global __m32c_fini
__m32c_fini:
	enter	#0
	jsr.a	_m32c_run_fini_array


;;; Provide Dwarf unwinding information that will help GDB stop
;;; backtraces at the right place.  This is stolen from assembly
;;; code generated by GCC with -dA.
	.section	.debug_frame,"",@progbits
.Lframe0:
	.4byte	.LECIE0-.LSCIE0	; Length of Common Information Entry
.LSCIE0:
	.4byte	0xffffffff	; CIE Identifier Tag
	.byte	0x1	; CIE Version
	.ascii "\0"	; CIE Augmentation
	.uleb128 0x1	; CIE Code Alignment Factor
	.sleb128 -1	; CIE Data Alignment Factor
	.byte	0xd	; CIE RA Column
	.byte	0xc	; DW_CFA_def_cfa
	.uleb128 0xc
	.uleb128 0x3
	.byte	0x8d	; DW_CFA_offset, column 0xd
	.uleb128 0x3
	.p2align ALIGN
.LECIE0:
.LSFDE0:
	.4byte	.LEFDE0-.LASFDE0	; FDE Length
.LASFDE0:
	.4byte	.Lframe0	; FDE CIE offset
	.4byte	.LFB2		; FDE initial location
	.4byte	.LFE2-.LFB2	; FDE address range
	.byte   0xf     	; DW_CFA_def_cfa_expression
	.uleb128 1		; length of expression
	.byte 	0x30		; DW_OP_lit0
	.p2align ALIGN
.LEFDE0:

	.text
