/*
Copyright 2011-2013  Francesco Cecconi <francesco.cecconi@gmail.com>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef VULNERABILITY_H
#define VULNERABILITY_H

#include "ui_welcomevulnwidget.h"
#include "ui_vulnerabilitywidget.h"

#include <QtCore/QObject>
#include <QtCore/QHash>
#include <QtCore/QList>
#include <QtCore/QPair>
#include <QCompleter>
#include <QStringListModel>
#include <QSplitter>
#include <QtWebKit/QWebView>

// local include
#include "addvulnerabilityurl.h"

class MainWindow;

class WelcomeVulnerability : public QWidget, private Ui::welcomeVulnWidgetForm
{
    Q_OBJECT
public:
    explicit WelcomeVulnerability(QWidget* parent = 0);
};

class VulnerabilityWidget : public QWidget, public Ui::VulnerabilityWidgetForm
{
    Q_OBJECT
public:
    explicit VulnerabilityWidget(QWidget* parent = 0);
};

class Vulnerability : public QObject
{
    Q_OBJECT

public:
    Vulnerability(MainWindow* parent);
    ~Vulnerability();
    /**
    * Load search url into dedicate combo.
    **/
    void loadSearchUrlIntoCombo();
    void syncSettings();

    VulnerabilityWidget* m_vulnerabilityWidget;


private:
    void updateCompleter();
    const QList< QPair<QString, QString> > getDefaultUrlList();

    QList<QWebView*> m_webViewList;
    MainWindow* m_ui;
    QSplitter* m_mainHorizontalSplitter;
    WelcomeVulnerability* m_welcomeUi;
    QWeakPointer<QCompleter> m_completerVuln;
    QWeakPointer<QStringListModel> m_vulnModel;

public slots:
    /**
     * Search Vulnerability with comboVulnRis string
     **/
    void searchVulnerability(const QUrl& address, const QString& tabName);
    void searchVulnerabilityFromCombo();
    void tabWebBack();
    void tabWebForward();
    void tabWebStop();
    void callVulnCheck();
    void objVulnButton();
    void showAddUrlUi();

private slots:
    void vulnPostScan();
    void addUrlToBookmarks(const QString urlName, const QString urlAddr);
    void linkCompleterToServices();
    void removeUrlToBookmarks();
    void closeVulnTab(int index);
    void updateComboServicesProperties();
    void updateComboVuln(const QString& value);
    void searchVulnFromTreeWidget();
};

#endif // VULNERABILITY_H
